import type { SerialLogger } from "../log/Logger.js";
import type { ZWaveSerialFrame } from "../parsers/ZWaveSerialFrame.js";
import type { ZWaveSerialMode } from "../serialport/definitions.js";
/** The internal plumbing to convert raw serial data to Z-Wave serial frames */
export declare class ZWaveSerialParser {
    constructor(logger: SerialLogger, signal?: AbortSignal);
    readonly readable: ReadableStream<ZWaveSerialFrame>;
    get writable(): WritableStream<Uint8Array>;
    private parser;
    private modeSwitch;
    get mode(): ZWaveSerialMode | undefined;
    set mode(mode: ZWaveSerialMode | undefined);
    ignoreAckHighNibbleOnce(): void;
}
//# sourceMappingURL=ZWaveSerialParser.d.ts.map