import { NodeType, type SerialApiInitData, type UnknownZWaveChipType, type ZWaveApiVersion } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class GetSerialApiInitDataRequest extends Message {
}
export interface GetSerialApiInitDataResponseOptions extends SerialApiInitData {
}
export declare class GetSerialApiInitDataResponse extends Message {
    constructor(options: GetSerialApiInitDataResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): GetSerialApiInitDataResponse;
    zwaveApiVersion: ZWaveApiVersion;
    isPrimary: boolean;
    nodeType: NodeType;
    supportsTimers: boolean;
    isSIS: boolean;
    nodeIds: readonly number[];
    zwaveChipType?: string | UnknownZWaveChipType;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
//# sourceMappingURL=GetSerialApiInitDataMessages.d.ts.map