var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { LongRangeChannel, MessagePriority, ZWaveError, ZWaveErrorCodes, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
let GetLongRangeChannelRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetLongRangeChannel), expectedResponse(FunctionType.GetLongRangeChannel), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetLongRangeChannelRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetLongRangeChannelRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return GetLongRangeChannelRequest = _classThis;
})();
export { GetLongRangeChannelRequest };
let GetLongRangeChannelResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetLongRangeChannel), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetLongRangeChannelResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetLongRangeChannelResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.channel = options.channel;
            this.supportsAutoChannelSelection =
                options.supportsAutoChannelSelection;
            this.autoChannelSelectionActive = options.autoChannelSelectionActive;
        }
        static from(raw, _ctx) {
            const channel = raw.payload[0];
            let supportsAutoChannelSelection;
            let autoChannelSelectionActive;
            if (raw.payload.length >= 2) {
                supportsAutoChannelSelection = !!(raw.payload[1] & 0b0001_0000);
                autoChannelSelectionActive = !!(raw.payload[1] & 0b0010_0000);
            }
            else {
                supportsAutoChannelSelection = false;
                autoChannelSelectionActive = false;
            }
            return new this({
                channel,
                supportsAutoChannelSelection,
                autoChannelSelectionActive,
            });
        }
        channel;
        supportsAutoChannelSelection;
        autoChannelSelectionActive;
    };
    return GetLongRangeChannelResponse = _classThis;
})();
export { GetLongRangeChannelResponse };
let SetLongRangeChannelRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SetLongRangeChannel), priority(MessagePriority.Controller), expectedResponse(FunctionType.SetLongRangeChannel)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SetLongRangeChannelRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetLongRangeChannelRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.channel = options.channel;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SetLongRangeChannelRequest({});
        }
        channel;
        serialize(ctx) {
            this.payload = Bytes.from([this.channel]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    channel: getEnumMemberName(LongRangeChannel, this.channel),
                },
            };
        }
    };
    return SetLongRangeChannelRequest = _classThis;
})();
export { SetLongRangeChannelRequest };
let SetLongRangeChannelResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SetLongRangeChannel)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SetLongRangeChannelResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetLongRangeChannelResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { success: this.success },
            };
        }
    };
    return SetLongRangeChannelResponse = _classThis;
})();
export { SetLongRangeChannelResponse };
//# sourceMappingURL=LongRangeChannelMessages.js.map