import { type CommandClasses } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum RemoveNodeType {
    Any = 1,
    Controller = 2,
    Slave = 3,
    Stop = 5
}
export declare enum RemoveNodeStatus {
    Ready = 1,
    NodeFound = 2,
    RemovingSlave = 3,
    RemovingController = 4,
    Reserved_0x05 = 5,
    Done = 6,
    Failed = 7
}
export interface RemoveNodeFromNetworkRequestOptions {
    removeNodeType?: RemoveNodeType;
    highPower?: boolean;
    networkWide?: boolean;
}
export declare class RemoveNodeFromNetworkRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): RemoveNodeFromNetworkRequestBase;
}
export declare class RemoveNodeFromNetworkRequest extends RemoveNodeFromNetworkRequestBase {
    constructor(options: RemoveNodeFromNetworkRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): RemoveNodeFromNetworkRequest;
    /** The type of node to remove */
    removeNodeType: RemoveNodeType | undefined;
    /** Whether to use high power */
    highPower: boolean;
    /** Whether to exclude network wide */
    networkWide: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export type RemoveNodeFromNetworkRequestStatusReportOptions = {
    status: RemoveNodeStatus.Ready | RemoveNodeStatus.NodeFound | RemoveNodeStatus.Failed | RemoveNodeStatus.Reserved_0x05 | RemoveNodeStatus.Done;
} | {
    status: RemoveNodeStatus.RemovingController | RemoveNodeStatus.RemovingSlave;
    nodeId: number;
};
export declare class RemoveNodeFromNetworkRequestStatusReport extends RemoveNodeFromNetworkRequestBase implements SuccessIndicator {
    constructor(options: RemoveNodeFromNetworkRequestStatusReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): RemoveNodeFromNetworkRequestStatusReport;
    readonly status: RemoveNodeStatus;
    readonly statusContext: RemoveNodeStatusContext | undefined;
    isOK(): boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
interface RemoveNodeStatusContext {
    nodeId: number;
    basic?: number;
    generic?: number;
    specific?: number;
    supportedCCs?: CommandClasses[];
    controlledCCs?: CommandClasses[];
}
export {};
//# sourceMappingURL=RemoveNodeFromNetworkRequest.d.ts.map