var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MAX_NODES, MAX_REPEATERS, MessagePriority, ZWaveDataRate, ZWaveError, ZWaveErrorCodes, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
let SetPriorityRouteRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SetPriorityRoute), priority(MessagePriority.Normal), expectedResponse(FunctionType.SetPriorityRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SetPriorityRouteRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetPriorityRouteRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (options.repeaters) {
                if (options.repeaters.length > MAX_REPEATERS
                    || options.repeaters.some((id) => id < 1 || id > MAX_NODES)) {
                    throw new ZWaveError(`The repeaters array must contain at most ${MAX_REPEATERS} node IDs between 1 and ${MAX_NODES}`, ZWaveErrorCodes.Argument_Invalid);
                }
                if (options.routeSpeed == undefined) {
                    throw new ZWaveError(`When setting a priority route, repeaters and route speed must be set together`, ZWaveErrorCodes.Argument_Invalid);
                }
                this.repeaters = options.repeaters;
                this.routeSpeed = options.routeSpeed;
            }
            this.destinationNodeId = options.destinationNodeId;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SetPriorityRouteRequest({});
        }
        destinationNodeId;
        repeaters;
        routeSpeed;
        serialize(ctx) {
            const nodeId = encodeNodeID(this.destinationNodeId, ctx.nodeIdType);
            if (this.repeaters == undefined || this.routeSpeed == undefined) {
                // Remove the priority route
                this.payload = nodeId;
            }
            else {
                // Set the priority route
                this.payload = Bytes.concat([
                    nodeId,
                    Bytes.from([
                        this.repeaters[0] ?? 0,
                        this.repeaters[1] ?? 0,
                        this.repeaters[2] ?? 0,
                        this.repeaters[3] ?? 0,
                        this.routeSpeed,
                    ]),
                ]);
            }
            return super.serialize(ctx);
        }
        toLogEntry() {
            let message = {
                "node ID": this.destinationNodeId,
            };
            if (this.repeaters != undefined && this.routeSpeed != undefined) {
                message = {
                    ...message,
                    repeaters: this.repeaters.length > 0
                        ? this.repeaters.join(" -> ")
                        : "none",
                    "route speed": getEnumMemberName(ZWaveDataRate, this.routeSpeed),
                };
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return SetPriorityRouteRequest = _classThis;
})();
export { SetPriorityRouteRequest };
let SetPriorityRouteResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SetPriorityRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SetPriorityRouteResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SetPriorityRouteResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.success = options.success;
        }
        static from(raw, ctx) {
            // Byte(s) 0/1 are the node ID - this is missing from the Host API specs
            const { /* nodeId, */ bytesRead } = parseNodeID(raw.payload, ctx.nodeIdType, 0);
            const success = raw.payload[bytesRead] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { success: this.success },
            };
        }
    };
    return SetPriorityRouteResponse = _classThis;
})();
export { SetPriorityRouteResponse };
//# sourceMappingURL=SetPriorityRouteMessages.js.map