var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { Powerlevel } from "@zwave-js/cc";
import { MessagePriority, TransmitStatus, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
let SendTestFrameRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SendTestFrame), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SendTestFrameRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendTestFrameRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return SendTestFrameRequest.from(raw, ctx);
            }
            else {
                return SendTestFrameTransmitReport.from(raw, ctx);
            }
        }
    };
    return SendTestFrameRequestBase = _classThis;
})();
export { SendTestFrameRequestBase };
let SendTestFrameRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.SendTestFrame), expectedCallback(FunctionType.SendTestFrame)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SendTestFrameRequestBase;
    var SendTestFrameRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendTestFrameRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.testNodeId = options.testNodeId;
            this.powerlevel = options.powerlevel;
        }
        static from(raw, ctx) {
            let offset = 0;
            const { nodeId: testNodeId, bytesRead: nodeIdBytes } = parseNodeID(raw.payload, ctx.nodeIdType, offset);
            offset += nodeIdBytes;
            const powerlevel = raw.payload[offset++];
            const callbackId = raw.payload[offset++];
            return new this({
                testNodeId,
                powerlevel,
                callbackId,
            });
        }
        testNodeId;
        powerlevel;
        serialize(ctx) {
            this.assertCallbackId();
            const nodeId = encodeNodeID(this.testNodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([
                nodeId,
                Bytes.from([
                    this.powerlevel,
                    this.callbackId,
                ]),
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "test node id": this.testNodeId,
                    powerlevel: getEnumMemberName(Powerlevel, this.powerlevel),
                    "callback id": this.callbackId ?? "(not set)",
                },
            };
        }
    };
    return SendTestFrameRequest = _classThis;
})();
export { SendTestFrameRequest };
let SendTestFrameResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SendTestFrame)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SendTestFrameResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendTestFrameResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.wasSent = options.wasSent;
        }
        static from(raw, _ctx) {
            const wasSent = raw.payload[0] !== 0;
            return new this({
                wasSent,
            });
        }
        wasSent;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "was sent": this.wasSent },
            };
        }
    };
    return SendTestFrameResponse = _classThis;
})();
export { SendTestFrameResponse };
export class SendTestFrameTransmitReport extends SendTestFrameRequestBase {
    constructor(options) {
        super(options);
        this.callbackId = options.callbackId;
        this.transmitStatus = options.transmitStatus;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const transmitStatus = raw.payload[1];
        return new this({
            callbackId,
            transmitStatus,
        });
    }
    transmitStatus;
    isOK() {
        return this.transmitStatus === TransmitStatus.OK;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId ?? "(not set)",
                "transmit status": getEnumMemberName(TransmitStatus, this.transmitStatus),
            },
        };
    }
}
//# sourceMappingURL=SendTestFrameMessages.js.map