import { CommandClass } from "@zwave-js/cc";
import type { Message } from "@zwave-js/serial";
import { ApplicationCommandRequest } from "./application/ApplicationCommandRequest.js";
import { BridgeApplicationCommandRequest } from "./application/BridgeApplicationCommandRequest.js";
import { type SendDataMessage } from "./transport/SendDataShared.js";
export type CommandRequest = ApplicationCommandRequest | BridgeApplicationCommandRequest;
export declare function isCommandRequest(msg: Message): msg is CommandRequest;
export interface MessageWithCC {
    serializedCC: Uint8Array | undefined;
    command: CommandClass | undefined;
}
export declare function isMessageWithCC(msg: Message): msg is SendDataMessage | CommandRequest;
export interface ContainsSerializedCC {
    serializedCC: Uint8Array;
}
export declare function containsSerializedCC<T extends object>(container: T | undefined): container is T & ContainsSerializedCC;
export interface ContainsCC<T extends CommandClass = CommandClass> {
    command: T;
}
export declare function containsCC<T extends object>(container: T | undefined): container is T & ContainsCC;
//# sourceMappingURL=utils.d.ts.map