import type { LogContainer } from "@zwave-js/core";
import type { ReadableWritablePair, UnderlyingSink, UnderlyingSource } from "node:stream/web";
import { SerialLogger } from "../log/Logger.js";
import type { ZnifferSerialFrame } from "../parsers/ZnifferSerialFrame.js";
import type { ZWaveSerialBindingFactory } from "../serialport/ZWaveSerialStream.js";
/** Re-usable stream factory to create new serial streams */
export declare class ZnifferSerialStreamFactory {
    constructor(binding: ZWaveSerialBindingFactory, loggers: LogContainer);
    private binding;
    protected logger: SerialLogger;
    createStream(): Promise<ZnifferSerialStream>;
}
/** Single-use serial stream. Has to be re-created after being closed. */
export declare class ZnifferSerialStream implements ReadableWritablePair<ZnifferSerialFrame, Uint8Array> {
    #private;
    constructor(source: UnderlyingSource<Uint8Array>, sink: UnderlyingSink<Uint8Array>, logger: SerialLogger);
    protected logger: SerialLogger;
    readonly readable: ReadableStream<ZnifferSerialFrame>;
    readonly writable: WritableStream<Uint8Array>;
    close(): Promise<void>;
    private _isOpen;
    get isOpen(): boolean;
    private _writer;
    writeAsync(data: Uint8Array): Promise<void>;
}
//# sourceMappingURL=ZnifferSerialStream.d.ts.map