"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EventTarget_exports = {};
__export(EventTarget_exports, {
  TypedEventTarget: () => TypedEventTarget
});
module.exports = __toCommonJS(EventTarget_exports);
class CustomEvent extends Event {
  static {
    __name(this, "CustomEvent");
  }
  constructor(type, detail) {
    super(type);
    this._detail = detail;
  }
  _detail;
  get detail() {
    return this._detail;
  }
}
class TypedEventTarget {
  static {
    __name(this, "TypedEventTarget");
  }
  // We lazily initialize the instance properties, so they can be used in mixins
  _eventTarget;
  get eventTarget() {
    this._eventTarget ??= new EventTarget();
    return this._eventTarget;
  }
  _listeners;
  get listeners() {
    this._listeners ??= /* @__PURE__ */ new Map();
    return this._listeners;
  }
  _wrappers;
  get wrappers() {
    this._wrappers ??= /* @__PURE__ */ new WeakMap();
    return this._wrappers;
  }
  getWrapper(event, callback, once = false) {
    if (this.wrappers.has(callback)) {
      return this.wrappers.get(callback);
    } else {
      const wrapper = /* @__PURE__ */ __name((e) => {
        const detail = e.detail;
        callback(...detail);
        if (once)
          this.listeners.get(event)?.delete(callback);
      }, "wrapper");
      this.wrappers.set(callback, wrapper);
      return wrapper;
    }
  }
  rememberListener(event, callback) {
    if (!this.listeners.has(event)) {
      this.listeners.set(event, /* @__PURE__ */ new Set());
    }
    this.listeners.get(event).add(callback);
  }
  on(event, callback) {
    this.eventTarget.addEventListener(event, this.getWrapper(event, callback));
    this.rememberListener(event, callback);
    return this;
  }
  once(event, callback) {
    this.eventTarget.addEventListener(event, this.getWrapper(event, callback, true), { once: true });
    return this;
  }
  removeListener(event, callback) {
    if (this.wrappers.has(callback)) {
      this.eventTarget.removeEventListener(event, this.wrappers.get(callback));
      this.wrappers.delete(callback);
    }
    if (this.listeners.has(event)) {
      this.listeners.get(event).delete(callback);
    }
    return this;
  }
  removeAllListeners(event) {
    if (event) {
      if (this.listeners.has(event)) {
        for (const callback of this.listeners.get(event)) {
          this.removeListener(event, callback);
        }
      }
    } else {
      for (const event2 of this.listeners.keys()) {
        this.removeAllListeners(event2);
      }
    }
    return this;
  }
  off(event, callback) {
    return this.removeListener(event, callback);
  }
  emit(event, ...args) {
    return this.eventTarget.dispatchEvent(new CustomEvent(event, args));
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TypedEventTarget
});
//# sourceMappingURL=EventTarget.js.map
