import type { ReadableWritablePair } from "node:stream/web";
import type { CopyFile, FileHandle, ManageDirectory, ReadFile, ReadFileSystemInfo, WriteFile } from "./bindings.js";
export declare function enumFilesRecursive(fs: ReadFileSystemInfo, rootDir: string, predicate?: (filename: string) => boolean): Promise<string[]>;
export declare function copyFilesRecursive(fs: ManageDirectory & CopyFile & ReadFileSystemInfo, sourceDir: string, targetDir: string, predicate?: (filename: string) => boolean): Promise<void>;
export declare function readTextFile(fs: ReadFile, filename: string, encoding?: BufferEncoding): Promise<string>;
export declare function writeTextFile(fs: WriteFile, filename: string, content: string, encoding?: BufferEncoding): Promise<void>;
export declare function readJSON<T = any>(fs: ReadFile, filename: string): Promise<T>;
export declare function pathExists(fs: ReadFileSystemInfo, filename: string): Promise<boolean>;
export declare function fileHandleToWritableStream(handle: Omit<FileHandle, "readable" | "writable">): WritableStream<Uint8Array>;
export declare function fileHandleToReadableStream(handle: Omit<FileHandle, "readable" | "writable">): ReadableStream<Uint8Array>;
export declare function fileHandleToStreams(handle: Omit<FileHandle, "readable" | "writable">): ReadableWritablePair<Uint8Array, Uint8Array>;
//# sourceMappingURL=fs.d.ts.map