"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var fs_exports = {};
__export(fs_exports, {
  copyFilesRecursive: () => copyFilesRecursive,
  enumFilesRecursive: () => enumFilesRecursive,
  fileHandleToReadableStream: () => fileHandleToReadableStream,
  fileHandleToStreams: () => fileHandleToStreams,
  fileHandleToWritableStream: () => fileHandleToWritableStream,
  pathExists: () => pathExists,
  readJSON: () => readJSON,
  readTextFile: () => readTextFile,
  writeTextFile: () => writeTextFile
});
module.exports = __toCommonJS(fs_exports);
var import_pathe = __toESM(require("pathe"), 1);
var import_Bytes = require("./Bytes.js");
var import_errors = require("./errors.js");
async function enumFilesRecursive(fs, rootDir, predicate) {
  const ret = [];
  try {
    const filesAndDirs = await fs.readDir(rootDir);
    for (const f of filesAndDirs) {
      const fullPath = import_pathe.default.join(rootDir, f);
      if ((await fs.stat(fullPath)).isDirectory()) {
        ret.push(...await enumFilesRecursive(fs, fullPath, predicate));
      } else if (predicate == void 0 || predicate(fullPath)) {
        ret.push(fullPath);
      }
    }
  } catch (e) {
    console.error(`Cannot read directory: "${rootDir}": ${(0, import_errors.getErrorMessage)(e, true)}`);
  }
  return ret;
}
__name(enumFilesRecursive, "enumFilesRecursive");
async function copyFilesRecursive(fs, sourceDir, targetDir, predicate) {
  const files = await enumFilesRecursive(fs, sourceDir, predicate);
  for (const file of files) {
    const relative = import_pathe.default.relative(sourceDir, file);
    const target = import_pathe.default.join(targetDir, relative);
    await fs.ensureDir(import_pathe.default.dirname(target));
    await fs.copyFile(file, target);
  }
}
__name(copyFilesRecursive, "copyFilesRecursive");
async function readTextFile(fs, filename, encoding = "utf8") {
  const buffer = await fs.readFile(filename);
  return import_Bytes.Bytes.view(buffer).toString(encoding);
}
__name(readTextFile, "readTextFile");
async function writeTextFile(fs, filename, content, encoding = "utf8") {
  const buffer = import_Bytes.Bytes.from(content, encoding);
  await fs.writeFile(filename, buffer);
}
__name(writeTextFile, "writeTextFile");
async function readJSON(fs, filename) {
  const content = await readTextFile(fs, filename);
  return JSON.parse(content);
}
__name(readJSON, "readJSON");
async function pathExists(fs, filename) {
  try {
    await fs.stat(filename);
    return true;
  } catch {
    return false;
  }
}
__name(pathExists, "pathExists");
function fileHandleToWritableStream(handle) {
  return new WritableStream({
    async write(chunk) {
      while (chunk.length > 0) {
        const { bytesWritten } = await handle.write(chunk);
        chunk = chunk.subarray(bytesWritten);
      }
    }
  });
}
__name(fileHandleToWritableStream, "fileHandleToWritableStream");
function fileHandleToReadableStream(handle) {
  return new ReadableStream({
    async pull(controller) {
      const { data } = await handle.read(null, 16 * 1024);
      controller.enqueue(data);
    }
  });
}
__name(fileHandleToReadableStream, "fileHandleToReadableStream");
function fileHandleToStreams(handle) {
  return {
    readable: fileHandleToReadableStream(handle),
    writable: fileHandleToWritableStream(handle)
  };
}
__name(fileHandleToStreams, "fileHandleToStreams");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  copyFilesRecursive,
  enumFilesRecursive,
  fileHandleToReadableStream,
  fileHandleToStreams,
  fileHandleToWritableStream,
  pathExists,
  readJSON,
  readTextFile,
  writeTextFile
});
//# sourceMappingURL=fs.js.map
