"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  cloneDeep: () => cloneDeep,
  discreteBinarySearch: () => discreteBinarySearch,
  discreteLinearSearch: () => discreteLinearSearch,
  evalOrStatic: () => evalOrStatic,
  getEnumMemberName: () => getEnumMemberName,
  isEnumMember: () => isEnumMember,
  keysOf: () => keysOf,
  mergeDeep: () => mergeDeep,
  noop: () => noop,
  padVersion: () => padVersion,
  pick: () => pick,
  pickDeep: () => pickDeep,
  sum: () => sum,
  throttle: () => throttle
});
module.exports = __toCommonJS(utils_exports);
var import_typeguards = require("alcalzone-shared/typeguards");
var import_strings = require("./strings.js");
function keysOf(obj) {
  return Object.keys(obj);
}
__name(keysOf, "keysOf");
function pick(obj, keys) {
  const ret = {};
  for (const key of keys) {
    if (key in obj)
      ret[key] = obj[key];
  }
  return ret;
}
__name(pick, "pick");
function pickDeep(object, path) {
  function _pickDeep(obj, pathArr) {
    if (!pathArr.length)
      return obj;
    if (!(0, import_typeguards.isObject)(obj) && !(0, import_typeguards.isArray)(obj))
      return void 0;
    const propName = pathArr.shift();
    return _pickDeep(obj[propName], pathArr);
  }
  __name(_pickDeep, "_pickDeep");
  return _pickDeep(object, path.split("."));
}
__name(pickDeep, "pickDeep");
function getEnumMemberName(enumeration, value) {
  return enumeration[value] || `unknown (${(0, import_strings.num2hex)(value)})`;
}
__name(getEnumMemberName, "getEnumMemberName");
function isEnumMember(enumeration, value) {
  return typeof enumeration[value] === "string";
}
__name(isEnumMember, "isEnumMember");
function throttle(fn, intervalMs, trailing = false) {
  let lastCall = 0;
  let timeout;
  return (...args) => {
    const now = Date.now();
    if (now >= lastCall + intervalMs) {
      lastCall = now;
      fn(...args);
    } else if (trailing) {
      if (timeout)
        clearTimeout(timeout);
      const delay = lastCall + intervalMs - now;
      timeout = setTimeout(() => {
        lastCall = now;
        fn(...args);
      }, delay);
    }
  };
}
__name(throttle, "throttle");
function mergeDeep(target, source, overwrite) {
  target = target || {};
  for (const [key, value] of Object.entries(source)) {
    if (key in target) {
      if (value === void 0) {
        if (overwrite)
          delete target[key];
      } else if (typeof value === "object") {
        target[key] = mergeDeep(target[key], value, overwrite);
      } else if (overwrite || typeof target[key] === "undefined") {
        target[key] = value;
      }
    } else if (value !== void 0) {
      target[key] = value;
    }
  }
  return target;
}
__name(mergeDeep, "mergeDeep");
function cloneDeep(source) {
  if ((0, import_typeguards.isArray)(source)) {
    return source.map((i) => cloneDeep(i));
  } else if ((0, import_typeguards.isObject)(source)) {
    const target = {};
    for (const [key, value] of Object.entries(source)) {
      target[key] = cloneDeep(value);
    }
    return target;
  } else {
    return source;
  }
}
__name(cloneDeep, "cloneDeep");
function padVersion(version) {
  if (version.split(".").length === 3)
    return version;
  return version + ".0";
}
__name(padVersion, "padVersion");
async function discreteBinarySearch(rangeMin, rangeMax, executor) {
  let min = rangeMin;
  let max = rangeMax;
  while (min < max) {
    const mid = min + Math.floor((max - min + 1) / 2);
    const result = await executor(mid);
    if (result) {
      min = mid;
    } else {
      max = mid - 1;
    }
  }
  if (min === rangeMin) {
    const result = await executor(min);
    if (!result)
      return void 0;
  }
  return min;
}
__name(discreteBinarySearch, "discreteBinarySearch");
async function discreteLinearSearch(rangeMin, rangeMax, executor) {
  for (let val = rangeMin; val <= rangeMax; val++) {
    const result = await executor(val);
    if (result === void 0)
      return void 0;
    if (!result) {
      if (val === rangeMin) {
        break;
      } else {
        return val - 1;
      }
    } else {
      if (val === rangeMax) {
        return rangeMax;
      }
    }
  }
}
__name(discreteLinearSearch, "discreteLinearSearch");
function sum(values) {
  return values.reduce((acc, cur) => acc + cur, 0);
}
__name(sum, "sum");
function noop() {
}
__name(noop, "noop");
function evalOrStatic(fnOrConst, ...args) {
  return typeof fnOrConst === "function" ? fnOrConst(...args) : fnOrConst;
}
__name(evalOrStatic, "evalOrStatic");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  cloneDeep,
  discreteBinarySearch,
  discreteLinearSearch,
  evalOrStatic,
  getEnumMemberName,
  isEnumMember,
  keysOf,
  mergeDeep,
  noop,
  padVersion,
  pick,
  pickDeep,
  sum,
  throttle
});
//# sourceMappingURL=utils.js.map
