"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MockControllerCapabilities_exports = {};
__export(MockControllerCapabilities_exports, {
  getDefaultMockControllerCapabilities: () => getDefaultMockControllerCapabilities,
  getDefaultSupportedFunctionTypes: () => getDefaultSupportedFunctionTypes
});
module.exports = __toCommonJS(MockControllerCapabilities_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
function getDefaultSupportedFunctionTypes() {
  return [
    import_serial.FunctionType.GetSerialApiInitData,
    import_serial.FunctionType.GetControllerCapabilities,
    import_serial.FunctionType.SendData,
    import_serial.FunctionType.SendDataMulticast,
    import_serial.FunctionType.SendDataBridge,
    import_serial.FunctionType.SendDataMulticastBridge,
    import_serial.FunctionType.GetControllerVersion,
    import_serial.FunctionType.GetControllerId,
    import_serial.FunctionType.GetNodeProtocolInfo,
    import_serial.FunctionType.RequestNodeInfo,
    import_serial.FunctionType.AssignSUCReturnRoute,
    import_serial.FunctionType.AddNodeToNetwork,
    import_serial.FunctionType.RemoveNodeFromNetwork
  ];
}
__name(getDefaultSupportedFunctionTypes, "getDefaultSupportedFunctionTypes");
function getDefaultMockControllerCapabilities() {
  return {
    firmwareVersion: "1.0",
    manufacturerId: 65535,
    productType: 65535,
    productId: 65534,
    supportedFunctionTypes: getDefaultSupportedFunctionTypes(),
    controllerType: import_core.ZWaveLibraryTypes["Static Controller"],
    libraryVersion: "Z-Wave 7.17.99",
    zwaveApiVersion: {
      kind: "legacy",
      version: 9
    },
    isSecondary: false,
    isSISPresent: true,
    isStaticUpdateController: true,
    wasRealPrimary: true,
    isUsingHomeIdFromOtherNetwork: false,
    noNodesIncluded: false,
    sucNodeId: 0,
    supportsTimers: false,
    zwaveChipType: {
      // EFR32ZG14 / ZGM130S
      type: 7,
      version: 0
    },
    supportsLongRange: false,
    watchdogEnabled: false
  };
}
__name(getDefaultMockControllerCapabilities, "getDefaultMockControllerCapabilities");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDefaultMockControllerCapabilities,
  getDefaultSupportedFunctionTypes
});
//# sourceMappingURL=MockControllerCapabilities.js.map
