"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MockNodeCapabilities_exports = {};
__export(MockNodeCapabilities_exports, {
  ccCaps: () => ccCaps,
  getDefaultMockEndpointCapabilities: () => getDefaultMockEndpointCapabilities,
  getDefaultMockNodeCapabilities: () => getDefaultMockNodeCapabilities
});
module.exports = __toCommonJS(MockNodeCapabilities_exports);
var import_core = require("@zwave-js/core");
function ccCaps(caps) {
  return caps;
}
__name(ccCaps, "ccCaps");
function getDefaultMockNodeCapabilities() {
  return {
    firmwareVersion: "1.0",
    manufacturerId: 65535,
    productType: 65535,
    productId: 65534,
    isListening: true,
    isFrequentListening: false,
    isRouting: true,
    supportedDataRates: [9600, 4e4, 1e5],
    protocolVersion: 3,
    optionalFunctionality: true,
    nodeType: import_core.NodeType["End Node"],
    supportsSecurity: false,
    supportsBeaming: true,
    basicDeviceClass: import_core.BasicDeviceClass["Routing End Node"],
    genericDeviceClass: 6,
    // Appliance
    specificDeviceClass: 1,
    // General Appliance
    txDelay: 10
  };
}
__name(getDefaultMockNodeCapabilities, "getDefaultMockNodeCapabilities");
function getDefaultMockEndpointCapabilities(nodeCaps) {
  return {
    genericDeviceClass: nodeCaps.genericDeviceClass,
    specificDeviceClass: nodeCaps.specificDeviceClass
  };
}
__name(getDefaultMockEndpointCapabilities, "getDefaultMockEndpointCapabilities");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ccCaps,
  getDefaultMockEndpointCapabilities,
  getDefaultMockNodeCapabilities
});
//# sourceMappingURL=MockNodeCapabilities.js.map
