import { type TaskBuilder } from "./Task.js";
/** Returns a timestamp with nano-second precision */
export declare function highResTimestamp(): number;
/** Does nothing. Can be used for empty `.catch(...)` calls. */
export declare function noop(): void;
export type FnOrStatic<TArgs extends any[], TReturn> = ((...args: TArgs) => TReturn) | TReturn;
export type ReturnTypeOrStatic<T> = T extends (...args: any[]) => infer R ? R : T;
export declare function evalOrStatic<T>(fnOrConst: T, ...args: any[]): ReturnTypeOrStatic<T>;
export type WaitForReturnType<T> = T extends Promise<infer U> ? U : T extends TaskBuilder<infer U> ? U : never;
export declare function waitFor<T extends Promise<unknown> | TaskBuilder<unknown>>(thing: T): AsyncGenerator<() => T, WaitForReturnType<T>>;
//# sourceMappingURL=utils.d.ts.map