/** Returns a timestamp with nano-second precision */
export function highResTimestamp() {
    if (typeof process !== "undefined") {
        const [s, ns] = process.hrtime();
        return s * 1e9 + ns;
    }
    else if (performance != undefined) {
        return performance.now() * 1e6;
    }
    else {
        throw new Error("No high-resolution timer available");
    }
}
/** Does nothing. Can be used for empty `.catch(...)` calls. */
export function noop() {
    // intentionally empty
}
export function evalOrStatic(fnOrConst, ...args) {
    // @ts-expect-error https://github.com/microsoft/TypeScript/issues/61337
    return typeof fnOrConst === "function" ? fnOrConst(...args) : fnOrConst;
}
export async function* waitFor(thing) {
    const result = yield () => thing;
    return result;
}
//# sourceMappingURL=utils.js.map