import { type Firmware } from "@zwave-js/core";
import type { FirmwareUpdateDeviceID, FirmwareUpdateFileInfo, FirmwareUpdateInfo } from "./_Types.js";
export interface GetAvailableFirmwareUpdateOptions {
    userAgent: string;
    apiKey?: string;
    includePrereleases?: boolean;
}
/**
 * Retrieves the available firmware updates for the node with the given fingerprint.
 * Returns the service response or `undefined` in case of an error.
 */
export declare function getAvailableFirmwareUpdates(deviceId: FirmwareUpdateDeviceID, options: GetAvailableFirmwareUpdateOptions): Promise<FirmwareUpdateInfo[]>;
export declare function downloadFirmwareUpdate(file: FirmwareUpdateFileInfo): Promise<Firmware>;
//# sourceMappingURL=FirmwareUpdateService.d.ts.map