import { type CommandClasses, SecurityClass } from "@zwave-js/core";
import type { Database, ReadFile, ReadFileSystemInfo } from "@zwave-js/shared/bindings";
/**
 * Defines the keys that are used to store certain properties in the network cache.
 */
export declare const cacheKeys: {
    readonly controller: {
        readonly provisioningList: "controller.provisioningList";
        readonly associations: (groupId: number) => string;
        readonly securityKeys: (secClass: SecurityClass) => string;
        readonly securityKeysLongRange: (secClass: SecurityClass) => string;
        readonly privateKey: "controller.privateKey";
    };
    readonly node: (nodeId: number) => {
        _baseKey: string;
        _securityClassBaseKey: string;
        _priorityReturnRouteBaseKey: string;
        interviewStage: string;
        deviceClass: string;
        isListening: string;
        isFrequentListening: string;
        isRouting: string;
        supportedDataRates: string;
        protocolVersion: string;
        nodeType: string;
        supportsSecurity: string;
        supportsBeaming: string;
        securityClass: (secClass: SecurityClass) => string;
        dsk: string;
        endpoint: (index: number) => {
            _baseKey: string;
            _ccBaseKey: string;
            commandClass: (ccId: CommandClasses) => string;
        };
        hasSUCReturnRoute: string;
        priorityReturnRoute: (destinationNodeId: number) => string;
        prioritySUCReturnRoute: string;
        customReturnRoutes: (destinationNodeId: number) => string;
        customSUCReturnRoutes: string;
        defaultTransitionDuration: string;
        defaultVolume: string;
        lastSeen: string;
        deviceConfigHash: string;
    };
};
export declare const cacheKeyUtils: {
    readonly nodeIdFromKey: (key: string) => number | undefined;
    readonly nodePropertyFromKey: (key: string) => string | undefined;
    readonly isEndpointKey: (key: string) => boolean;
    readonly endpointIndexFromKey: (key: string) => number | undefined;
    readonly destinationFromPriorityReturnRouteKey: (key: string) => number | undefined;
};
export declare function deserializeNetworkCacheValue(key: string, value: unknown): unknown;
export declare function serializeNetworkCacheValue(key: string, value: unknown): unknown;
export declare function migrateLegacyNetworkCache(homeId: number, networkCache: Database<any>, valueDB: Database<unknown>, fs: ReadFileSystemInfo & ReadFile, cacheDir: string): Promise<void>;
//# sourceMappingURL=NetworkCache.d.ts.map