"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Statistics_exports = {};
__export(Statistics_exports, {
  StatisticsHost: () => StatisticsHost
});
module.exports = __toCommonJS(Statistics_exports);
var import_shared = require("@zwave-js/shared");
class StatisticsHost {
  static {
    __name(this, "StatisticsHost");
  }
  _statistics;
  get statistics() {
    if (!this._statistics)
      this.resetStatistics();
    return Object.freeze(this._statistics);
  }
  resetStatistics() {
    this.updateStatistics(() => this.createEmpty());
  }
  /** Can be overridden in derived classes to specify additional args to be included in the statistics event callback. */
  getAdditionalEventArgs() {
    return [];
  }
  _emitUpdate;
  updateStatistics(updater) {
    this._statistics = updater(this._statistics ?? this.createEmpty());
    if (!this._emitUpdate) {
      this._emitUpdate = (0, import_shared.throttle)(this.emit.bind(this, "statistics updated", ...this.getAdditionalEventArgs()), 250, true);
    }
    this._emitUpdate(this._statistics);
  }
  incrementStatistics(property) {
    this.updateStatistics((s) => {
      const value = s[property];
      if (typeof value === "number") {
        return {
          ...s,
          [property]: value + 1
        };
      } else {
        return s;
      }
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  StatisticsHost
});
//# sourceMappingURL=Statistics.js.map
