import { type CommandClass } from "@zwave-js/cc";
import { type DataDirection, type LogContainer, type LogContext, type RSSI, ZWaveLoggerBase } from "@zwave-js/core";
import type { ZnifferDataMessage } from "@zwave-js/serial";
import type { BeamStop, LongRangeBeamStart, LongRangeMPDU, ZWaveBeamStart, ZWaveMPDU } from "../zniffer/MPDU.js";
import type { Zniffer } from "../zniffer/Zniffer.js";
export declare const ZNIFFER_LABEL = "ZNIFFR";
export interface ZnifferLogContext extends LogContext<"zniffer"> {
    direction?: DataDirection;
}
export declare class ZnifferLogger extends ZWaveLoggerBase<ZnifferLogContext> {
    private readonly zniffer;
    constructor(zniffer: Zniffer, loggers: LogContainer);
    private isLogVisible;
    /**
     * Logs a message
     * @param msg The message to output
     */
    print(message: string, level?: "debug" | "verbose" | "warn" | "error" | "info"): void;
    crcError(frame: ZnifferDataMessage, rssi?: RSSI): void;
    mpdu(mpdu: ZWaveMPDU | LongRangeMPDU, payloadCC?: CommandClass): void;
    beam(beam: ZWaveBeamStart | LongRangeBeamStart | BeamStop): void;
}
//# sourceMappingURL=Zniffer.d.ts.map