"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssociationCC_exports = {};
__export(AssociationCC_exports, {
  handleAssociationGet: () => handleAssociationGet,
  handleAssociationRemove: () => handleAssociationRemove,
  handleAssociationSet: () => handleAssociationSet,
  handleAssociationSpecificGroupGet: () => handleAssociationSpecificGroupGet
});
module.exports = __toCommonJS(AssociationCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("./_shared.js");
async function handleAssociationGet(ctx, controller, node, command) {
  const groupId = 1;
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Association, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  const nodeIds = controller.associations.filter((a) => a.endpoint == void 0).map((a) => a.nodeId) ?? [];
  await api.sendReport({
    groupId,
    maxNodes: import_shared.MAX_ASSOCIATIONS,
    nodeIds,
    reportsToFollow: 0
  });
}
__name(handleAssociationGet, "handleAssociationGet");
function handleAssociationSet(ctx, controller, node, command) {
  if (command.groupId !== 1) {
    throw new import_core.ZWaveError(`Association group ${command.groupId} is not supported.`, import_core.ZWaveErrorCodes.CC_OperationFailed);
  }
  const newAssociations = command.nodeIds.filter((newNodeId) => !controller.associations.some(({ nodeId, endpoint }) => endpoint === void 0 && nodeId === newNodeId)).map((nodeId) => ({ nodeId }));
  const associations = [...controller.associations];
  associations.push(...newAssociations);
  if (associations.length > import_shared.MAX_ASSOCIATIONS) {
    throw new import_core.ZWaveError(`Association group ${command.groupId} is full`, import_core.ZWaveErrorCodes.CC_OperationFailed);
  }
  controller.associations = associations;
}
__name(handleAssociationSet, "handleAssociationSet");
function handleAssociationRemove(ctx, controller, node, command) {
  if (!!command.groupId && command.groupId !== 1) {
    return;
  }
  if (!command.nodeIds?.length) {
    controller.associations = [];
  } else {
    controller.associations = controller.associations.filter(({ nodeId, endpoint }) => endpoint === void 0 && !command.nodeIds.includes(nodeId));
  }
}
__name(handleAssociationRemove, "handleAssociationRemove");
async function handleAssociationSpecificGroupGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Association, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportSpecificGroup(0);
}
__name(handleAssociationSpecificGroupGet, "handleAssociationSpecificGroupGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleAssociationGet,
  handleAssociationRemove,
  handleAssociationSet,
  handleAssociationSpecificGroupGet
});
//# sourceMappingURL=AssociationCC.js.map
