"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var PowerlevelCC_exports = {};
__export(PowerlevelCC_exports, {
  handlePowerlevelGet: () => handlePowerlevelGet,
  handlePowerlevelSet: () => handlePowerlevelSet,
  handlePowerlevelTestNodeGet: () => handlePowerlevelTestNodeGet,
  handlePowerlevelTestNodeReport: () => handlePowerlevelTestNodeReport,
  handlePowerlevelTestNodeSet: () => handlePowerlevelTestNodeSet
});
module.exports = __toCommonJS(PowerlevelCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
function handlePowerlevelSet(driver, node, command) {
  if (!(command.powerlevel in import_cc.Powerlevel)) {
    throw new import_core.ZWaveError(`Invalid powerlevel ${command.powerlevel}.`, import_core.ZWaveErrorCodes.CC_OperationFailed);
  }
  driver.controller.powerlevel = {
    powerlevel: command.powerlevel,
    until: command.timeout ? new Date(Date.now() + command.timeout * 1e3) : /* @__PURE__ */ new Date()
  };
}
__name(handlePowerlevelSet, "handlePowerlevelSet");
async function handlePowerlevelGet(driver, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Powerlevel, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  const { powerlevel, until } = driver.controller.powerlevel;
  if (
    // Setting elapsed
    until.getTime() < Date.now() || powerlevel === import_cc.Powerlevel["Normal Power"]
  ) {
    await api.reportPowerlevel({
      powerlevel: import_cc.Powerlevel["Normal Power"]
    });
  } else {
    const timeoutSeconds = Math.max(0, Math.min(Math.round((until.getTime() - Date.now()) / 1e3), 255));
    await api.reportPowerlevel({
      powerlevel,
      timeout: timeoutSeconds
    });
  }
}
__name(handlePowerlevelGet, "handlePowerlevelGet");
async function handlePowerlevelTestNodeSet(driver, node, command) {
  if (!(command.powerlevel in import_cc.Powerlevel)) {
    throw new import_core.ZWaveError(`Invalid powerlevel ${command.powerlevel}.`, import_core.ZWaveErrorCodes.CC_OperationFailed);
  } else if (command.testFrameCount < 1) {
    throw new import_core.ZWaveError("testFrameCount must be at least 1", import_core.ZWaveErrorCodes.CC_OperationFailed);
  }
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Powerlevel, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  try {
    const acknowledgedFrames = await driver.sendNOPPowerFrames(command.testNodeId, command.powerlevel, command.testFrameCount);
    void api.sendNodeTestReport({
      status: acknowledgedFrames > 0 ? import_cc.PowerlevelTestStatus.Success : import_cc.PowerlevelTestStatus.Failed,
      testNodeId: command.testNodeId,
      acknowledgedFrames
    }).catch(import_shared.noop);
  } catch {
    void api.sendNodeTestReport({
      status: import_cc.PowerlevelTestStatus.Failed,
      testNodeId: command.testNodeId,
      acknowledgedFrames: 0
    }).catch(import_shared.noop);
  }
}
__name(handlePowerlevelTestNodeSet, "handlePowerlevelTestNodeSet");
async function handlePowerlevelTestNodeGet(driver, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Powerlevel, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  const status = driver.getNOPPowerTestStatus();
  if (status) {
    await api.sendNodeTestReport({
      status: status.inProgress ? import_cc.PowerlevelTestStatus["In Progress"] : status.acknowledgedFrames > 0 ? import_cc.PowerlevelTestStatus.Success : import_cc.PowerlevelTestStatus.Failed,
      ...status
    });
  } else {
    await api.sendNodeTestReport({
      status: import_cc.PowerlevelTestStatus.Success,
      testNodeId: 0,
      acknowledgedFrames: 0
    });
  }
}
__name(handlePowerlevelTestNodeGet, "handlePowerlevelTestNodeGet");
function handlePowerlevelTestNodeReport(ctx, node, command) {
  node.emit("notification", node, import_core.CommandClasses.Powerlevel, (0, import_shared.pick)(command, ["testNodeId", "status", "acknowledgedFrames"]));
}
__name(handlePowerlevelTestNodeReport, "handlePowerlevelTestNodeReport");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handlePowerlevelGet,
  handlePowerlevelSet,
  handlePowerlevelTestNodeGet,
  handlePowerlevelTestNodeReport,
  handlePowerlevelTestNodeSet
});
//# sourceMappingURL=PowerlevelCC.js.map
