"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Node_exports = {};
__export(Node_exports, {
  ZWaveNode: () => ZWaveNode
});
module.exports = __toCommonJS(Node_exports);
var import_cc = require("@zwave-js/cc");
var import_AssociationCC = require("@zwave-js/cc/AssociationCC");
var import_AssociationGroupInfoCC = require("@zwave-js/cc/AssociationGroupInfoCC");
var import_BasicCC = require("@zwave-js/cc/BasicCC");
var import_BinarySwitchCC = require("@zwave-js/cc/BinarySwitchCC");
var import_CentralSceneCC = require("@zwave-js/cc/CentralSceneCC");
var import_ClockCC = require("@zwave-js/cc/ClockCC");
var import_EntryControlCC = require("@zwave-js/cc/EntryControlCC");
var import_FirmwareUpdateMetaDataCC = require("@zwave-js/cc/FirmwareUpdateMetaDataCC");
var import_HailCC = require("@zwave-js/cc/HailCC");
var import_ManufacturerSpecificCC = require("@zwave-js/cc/ManufacturerSpecificCC");
var import_MultilevelSwitchCC = require("@zwave-js/cc/MultilevelSwitchCC");
var import_NodeNamingCC = require("@zwave-js/cc/NodeNamingCC");
var import_NotificationCC = require("@zwave-js/cc/NotificationCC");
var import_PowerlevelCC = require("@zwave-js/cc/PowerlevelCC");
var import_SceneActivationCC = require("@zwave-js/cc/SceneActivationCC");
var import_Security2CC = require("@zwave-js/cc/Security2CC");
var import_SecurityCC = require("@zwave-js/cc/SecurityCC");
var import_ThermostatModeCC = require("@zwave-js/cc/ThermostatModeCC");
var import_VersionCC = require("@zwave-js/cc/VersionCC");
var import_WakeUpCC = require("@zwave-js/cc/WakeUpCC");
var import_ZWavePlusCC = require("@zwave-js/cc/ZWavePlusCC");
var import_config = require("@zwave-js/config");
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_serialapi = require("@zwave-js/serial/serialapi");
var import_shared = require("@zwave-js/shared");
var import_async = require("alcalzone-shared/async");
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
var import_math = require("alcalzone-shared/math");
var import_pathe = __toESM(require("pathe"), 1);
var import_NetworkCache = require("../driver/NetworkCache.js");
var import_AssociationCC2 = require("./CCHandlers/AssociationCC.js");
var import_AssociationGroupInformationCC = require("./CCHandlers/AssociationGroupInformationCC.js");
var import_BasicCC2 = require("./CCHandlers/BasicCC.js");
var import_BatteryCC = require("./CCHandlers/BatteryCC.js");
var import_BinarySwitchCC2 = require("./CCHandlers/BinarySwitchCC.js");
var import_CentralSceneCC2 = require("./CCHandlers/CentralSceneCC.js");
var import_ClockCC2 = require("./CCHandlers/ClockCC.js");
var import_DeviceResetLocallyCC = require("./CCHandlers/DeviceResetLocallyCC.js");
var import_EntryControlCC2 = require("./CCHandlers/EntryControlCC.js");
var import_HailCC2 = require("./CCHandlers/HailCC.js");
var import_IndicatorCC = require("./CCHandlers/IndicatorCC.js");
var import_ManufacturerSpecificCC2 = require("./CCHandlers/ManufacturerSpecificCC.js");
var import_MultiChannelAssociationCC = require("./CCHandlers/MultiChannelAssociationCC.js");
var import_MultilevelSwitchCC2 = require("./CCHandlers/MultilevelSwitchCC.js");
var import_NotificationCC2 = require("./CCHandlers/NotificationCC.js");
var import_PowerlevelCC2 = require("./CCHandlers/PowerlevelCC.js");
var import_ThermostatModeCC2 = require("./CCHandlers/ThermostatModeCC.js");
var import_TimeCC = require("./CCHandlers/TimeCC.js");
var import_VersionCC2 = require("./CCHandlers/VersionCC.js");
var import_WakeUpCC2 = require("./CCHandlers/WakeUpCC.js");
var import_ZWavePlusCC2 = require("./CCHandlers/ZWavePlusCC.js");
var import_DeviceClass = require("./DeviceClass.js");
var import_HealthCheck = require("./HealthCheck.js");
var import_NodeStatistics = require("./NodeStatistics.js");
var import_Types = require("./_Types.js");
var import_mixins = require("./mixins/index.js");
var nodeUtils = __toESM(require("./utils.js"), 1);
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let ZWaveNode = (() => {
  let _classDecorators = [(0, import_shared.Mixin)([import_shared.TypedEventTarget, import_NodeStatistics.NodeStatisticsHost])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_mixins.ZWaveNodeMixins;
  var ZWaveNode2 = class extends _classSuper {
    static {
      __name(this, "ZWaveNode");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveNode2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(id, driver, deviceClass, supportedCCs = [], controlledCCs = [], valueDB) {
      super(
        id,
        driver,
        // Define this node's intrinsic endpoint as the root device (0)
        0,
        deviceClass,
        supportedCCs,
        valueDB
      );
      for (const cc of controlledCCs)
        this.addCC(cc, { isControlled: true });
    }
    /**
     * Cleans up all resources used by this node
     */
    destroy() {
      for (const timeout of [
        this.centralSceneHandlerStore.keyHeldDownContext?.timeout,
        ...this.notificationHandlerStore.idleTimeouts.values()
      ]) {
        timeout?.clear();
      }
      this.removeAllListeners();
      this.cancelAllScheduledPolls();
    }
    /**
     * The device specific key (DSK) of this node in binary format.
     * This is only set if included with Security S2.
     */
    get dsk() {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).dsk);
    }
    /** @internal */
    set dsk(value) {
      const cacheKey = import_NetworkCache.cacheKeys.node(this.id).dsk;
      this.driver.cacheSet(cacheKey, value);
    }
    /**
     * The user-defined name of this node. Uses the value reported by `Node Naming and Location CC` if it exists.
     *
     * **Note:** Setting this value only updates the name locally. To permanently change the name of the node, use
     * the `commandClasses` API.
     */
    get name() {
      return this.getValue(import_NodeNamingCC.NodeNamingAndLocationCCValues.name.id);
    }
    set name(value) {
      if (value != void 0) {
        this._valueDB.setValue(import_NodeNamingCC.NodeNamingAndLocationCCValues.name.id, value);
      } else {
        this._valueDB.removeValue(import_NodeNamingCC.NodeNamingAndLocationCCValues.name.id);
      }
    }
    /**
     * The user-defined location of this node. Uses the value reported by `Node Naming and Location CC` if it exists.
     *
     * **Note:** Setting this value only updates the location locally. To permanently change the location of the node, use
     * the `commandClasses` API.
     */
    get location() {
      return this.getValue(import_NodeNamingCC.NodeNamingAndLocationCCValues.location.id);
    }
    set location(value) {
      if (value != void 0) {
        this._valueDB.setValue(import_NodeNamingCC.NodeNamingAndLocationCCValues.location.id, value);
      } else {
        this._valueDB.removeValue(import_NodeNamingCC.NodeNamingAndLocationCCValues.location.id);
      }
    }
    /** Whether a SUC return route was configured for this node */
    get hasSUCReturnRoute() {
      return !!this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).hasSUCReturnRoute);
    }
    set hasSUCReturnRoute(value) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).hasSUCReturnRoute, value);
    }
    /** The last time a message was received from this node */
    get lastSeen() {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).lastSeen);
    }
    /** @internal */
    set lastSeen(value) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).lastSeen, value);
      this.updateStatistics((cur) => ({
        ...cur,
        lastSeen: value
      }));
    }
    /**
     * The default volume level to be used for activating a Sound Switch.
     * Can be overridden by command-specific options.
     */
    get defaultVolume() {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).defaultVolume);
    }
    set defaultVolume(value) {
      if (value != void 0 && (value < 0 || value > 100)) {
        throw new import_core.ZWaveError(`The default volume must be a number between 0 and 100!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).defaultVolume, value);
    }
    /**
     * The default transition duration to be used for transitions like dimming lights or activating scenes.
     * Can be overridden by command-specific options.
     */
    get defaultTransitionDuration() {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).defaultTransitionDuration);
    }
    set defaultTransitionDuration(value) {
      if (typeof value === "string")
        value = import_core.Duration.from(value);
      if (import_core.Duration.isDuration(value))
        value = value.toString();
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).defaultTransitionDuration, value);
    }
    /** Returns a list of all value names that are defined on all endpoints of this node */
    getDefinedValueIDs() {
      if (this.isControllerNode) {
        const proprietary = this.driver.controller.proprietary;
        for (const impl of Object.values(proprietary)) {
          if (typeof impl.getDefinedValueIDs === "function") {
            return impl.getDefinedValueIDs();
          }
        }
        return [];
      } else {
        return nodeUtils.getDefinedValueIDs(this.driver, this);
      }
    }
    /**
     * Updates a value for a given property of a given CommandClass on the node.
     * This will communicate with the node!
     */
    async setValue(valueId, value, options) {
      valueId = (0, import_core.normalizeValueID)(valueId);
      if (this.isControllerNode) {
        const proprietary = this.driver.controller.proprietary;
        for (const impl of Object.values(proprietary)) {
          if (typeof impl.setValue === "function") {
            return impl.setValue(valueId, value);
          }
        }
      }
      const loglevel = this.driver.getLogConfig().level;
      try {
        const endpointInstance = this.getEndpoint(valueId.endpoint || 0);
        if (!endpointInstance) {
          return {
            status: import_cc.SetValueStatus.EndpointNotFound,
            message: `Endpoint ${valueId.endpoint} does not exist on Node ${this.id}`
          };
        }
        let api = endpointInstance.commandClasses[valueId.commandClass];
        if (!api.setValue) {
          return {
            status: import_cc.SetValueStatus.NotImplemented,
            message: `The ${(0, import_core.getCCName)(valueId.commandClass)} CC does not support setting values`
          };
        }
        if (loglevel === "silly") {
          this.driver.controllerLog.logNode(this.id, {
            endpoint: valueId.endpoint,
            message: `[setValue] calling SET_VALUE API ${api.constructor.name}:
  property:     ${valueId.property}
  property key: ${valueId.propertyKey}
  optimistic:   ${api.isSetValueOptimistic(valueId)}`,
            level: "silly"
          });
        }
        options ??= {};
        options.transitionDuration ??= this.defaultTransitionDuration;
        options.volume ??= this.defaultVolume;
        const valueIdProps = {
          property: valueId.property,
          propertyKey: valueId.propertyKey
        };
        const hooks = api.setValueHooks?.(valueIdProps, value, options);
        if (hooks?.supervisionDelayedUpdates) {
          api = api.withOptions({
            requestStatusUpdates: true,
            onUpdate: /* @__PURE__ */ __name(async (update) => {
              try {
                if (update.status === import_core.SupervisionStatus.Success) {
                  await hooks.supervisionOnSuccess();
                } else if (update.status === import_core.SupervisionStatus.Fail) {
                  await hooks.supervisionOnFailure();
                }
              } catch {
              }
            }, "onUpdate")
          });
        }
        if (typeof options.onProgress === "function") {
          api = api.withOptions({
            onProgress: options.onProgress
          });
        }
        const result = await api.setValue.call(api, valueIdProps, value, options);
        if (loglevel === "silly") {
          let message = `[setValue] result of SET_VALUE API call for ${api.constructor.name}:`;
          if (result) {
            if ((0, import_core.isSupervisionResult)(result)) {
              message += ` (SupervisionResult)
  status:   ${(0, import_shared.getEnumMemberName)(import_core.SupervisionStatus, result.status)}`;
              if (result.remainingDuration) {
                message += `
  duration: ${result.remainingDuration.toString()}`;
              }
            } else {
              message += " (other) " + JSON.stringify(result, null, 2);
            }
          } else {
            message += " undefined";
          }
          this.driver.controllerLog.logNode(this.id, {
            endpoint: valueId.endpoint,
            message,
            level: "silly"
          });
        }
        if (api.isSetValueOptimistic(valueId) && (0, import_core.isUnsupervisedOrSucceeded)(result)) {
          const emitEvent = !!result || !!this.driver.options.emitValueUpdateAfterSetValue;
          if (loglevel === "silly") {
            const message = emitEvent ? "updating value with event" : "updating value without event";
            this.driver.controllerLog.logNode(this.id, {
              endpoint: valueId.endpoint,
              message: `[setValue] ${message}`,
              level: "silly"
            });
          }
          const options2 = {};
          if (emitEvent) {
            options2.source = "driver";
          } else {
            options2.noEvent = true;
          }
          options2.updateTimestamp = (0, import_core.supervisedCommandSucceeded)(result);
          this._valueDB.setValue(valueId, value, options2);
        } else if (loglevel === "silly") {
          this.driver.controllerLog.logNode(this.id, {
            endpoint: valueId.endpoint,
            message: `[setValue] not updating value`,
            level: "silly"
          });
        }
        if (hooks) {
          const supervisedAndSuccessful = (0, import_core.isSupervisionResult)(result) && result.status === import_core.SupervisionStatus.Success;
          const shouldUpdateOptimistically = api.isSetValueOptimistic(valueId) && (supervisedAndSuccessful || !this.driver.options.disableOptimisticValueUpdate && result == void 0);
          if (shouldUpdateOptimistically) {
            hooks.optimisticallyUpdateRelatedValues?.(supervisedAndSuccessful);
          }
          if (!(0, import_core.supervisedCommandSucceeded)(result) || hooks.forceVerifyChanges?.()) {
            await hooks.verifyChanges?.(result);
          }
        }
        return (0, import_cc.supervisionResultToSetValueResult)(result);
      } catch (e) {
        if ((0, import_core.isZWaveError)(e)) {
          let result;
          switch (e.code) {
            // This CC or API is not implemented
            case import_core.ZWaveErrorCodes.CC_NotImplemented:
            case import_core.ZWaveErrorCodes.CC_NoAPI:
              result = {
                status: import_cc.SetValueStatus.NotImplemented,
                message: e.message
              };
              break;
            // A user tried to set an invalid value
            case import_core.ZWaveErrorCodes.Argument_Invalid:
              result = {
                status: import_cc.SetValueStatus.InvalidValue,
                message: e.message
              };
              break;
          }
          if (loglevel === "silly") {
            this.driver.controllerLog.logNode(this.id, {
              endpoint: valueId.endpoint,
              message: `[setValue] raised ZWaveError (${!!result ? "handled" : "not handled"}, code ${(0, import_shared.getEnumMemberName)(import_core.ZWaveErrorCodes, e.code)}): ${e.message}`,
              level: "silly"
            });
          }
          if (result)
            return result;
        }
        throw e;
      }
    }
    /**
     * Requests a value for a given property of a given CommandClass by polling the node.
     * **Warning:** Some value IDs share a command, so make sure not to blindly call this for every property
     */
    pollValue(valueId, sendCommandOptions = {}) {
      valueId = (0, import_core.normalizeValueID)(valueId);
      if (this.isControllerNode) {
        const proprietary = this.driver.controller.proprietary;
        for (const impl of Object.values(proprietary)) {
          if (typeof impl.pollValue === "function") {
            return impl.pollValue(valueId);
          }
        }
      }
      const endpointInstance = this.getEndpoint(valueId.endpoint || 0);
      if (!endpointInstance) {
        throw new import_core.ZWaveError(`Endpoint ${valueId.endpoint} does not exist on Node ${this.id}`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const api = endpointInstance.commandClasses[valueId.commandClass].withOptions({
        // We do not want to delay more important communication by polling, so give it
        // the lowest priority and don't retry unless overwritten by the options
        maxSendAttempts: 1,
        priority: import_core.MessagePriority.Poll,
        ...sendCommandOptions
      });
      if (!api.pollValue) {
        throw new import_core.ZWaveError(`The pollValue API is not implemented for CC ${(0, import_core.getCCName)(valueId.commandClass)}!`, import_core.ZWaveErrorCodes.CC_NoAPI);
      }
      return api.pollValue.call(api, {
        property: valueId.property,
        propertyKey: valueId.propertyKey
      });
    }
    /** Returns a list of all `"notification"` event arguments that are known to be supported by this node */
    getSupportedNotificationEvents() {
      return nodeUtils.getSupportedNotificationEvents(this.driver, this);
    }
    _interviewAttempts = 0;
    /** How many attempts to interview this node have already been made */
    get interviewAttempts() {
      return this._interviewAttempts;
    }
    _hasEmittedNoS2NetworkKeyError = false;
    _hasEmittedNoS0NetworkKeyError = false;
    /**
     * Starts or resumes a deferred initial interview of this node.
     *
     * **WARNING:** This is only allowed when the initial interview was deferred using the
     * `interview.disableOnNodeAdded` option. Otherwise, this method will throw an error.
     *
     * **NOTE:** It is advised to NOT await this method as it can take a very long time (minutes to hours)!
     */
    async interview() {
      if (this.isControllerNode)
        return;
      if (!this.driver.options.interview?.disableOnNodeAdded) {
        throw new import_core.ZWaveError(`Calling ZWaveNode.interview() is not allowed because automatic node interviews are enabled. Wait for the driver to interview the node or use ZWaveNode.refreshInfo() to re-interview a node.`, import_core.ZWaveErrorCodes.Driver_FeatureDisabled);
      }
      return this.driver.interviewNodeInternal(this);
    }
    _refreshInfoPending = false;
    /**
     * Resets all information about this node and forces a fresh interview.
     * **Note:** This does nothing for the controller node.
     *
     * **WARNING:** Take care NOT to call this method when the node is already being interviewed.
     * Otherwise the node information may become inconsistent.
     */
    async refreshInfo(options = {}) {
      if (this.isControllerNode)
        return;
      if (this._refreshInfoPending)
        return;
      this._refreshInfoPending = true;
      const { resetSecurityClasses = false, waitForWakeup = true } = options;
      let didWakeUp = false;
      const wasAwake = this.status === import_Types.NodeStatus.Awake;
      if (waitForWakeup && this.canSleep && !wasAwake && this.supportsCC(import_core.CommandClasses["Wake Up"])) {
        this.driver.controllerLog.logNode(this.id, "Re-interview scheduled, waiting for node to wake up...");
        didWakeUp = await this.waitForWakeup().then(() => true).catch(() => false);
      }
      const name = this.name;
      const location = this.location;
      const preservedValues = [];
      const preservedMetadata = [];
      if (this.supportsCC(import_core.CommandClasses["User Code"]) && !this.driver.options.interview.queryAllUserCodes) {
        const mustBackup = /* @__PURE__ */ __name((v) => import_cc.UserCodeCCValues.userCode.is(v) || import_cc.UserCodeCCValues.userIdStatus.is(v) || import_cc.UserCodeCCValues.userCodeChecksum.is(v), "mustBackup");
        const values = this.valueDB.getValues(import_core.CommandClasses["User Code"]).filter(mustBackup);
        preservedValues.push(...values);
        const meta = this.valueDB.getAllMetadata(import_core.CommandClasses["User Code"]).filter(mustBackup);
        preservedMetadata.push(...meta);
      }
      if (resetSecurityClasses)
        this.securityClasses.clear();
      this._interviewAttempts = 0;
      this.interviewStage = import_Types.InterviewStage.None;
      this.ready = false;
      this.deviceClass = void 0;
      this.isListening = void 0;
      this.isFrequentListening = void 0;
      this.isRouting = void 0;
      this.supportedDataRates = void 0;
      this.protocolVersion = void 0;
      this.nodeType = void 0;
      this.supportsSecurity = void 0;
      this.supportsBeaming = void 0;
      this.deviceConfig = void 0;
      this.currentDeviceConfigHash = void 0;
      this.cachedDeviceConfigHash = void 0;
      this._hasEmittedNoS0NetworkKeyError = false;
      this._hasEmittedNoS2NetworkKeyError = false;
      for (const ep of this.getAllEndpoints()) {
        ep["reset"]();
      }
      this._valueDB.clear({ noEvent: true });
      this._endpointInstances.clear();
      super.reset();
      this.restartReadyMachine();
      this.restartStatusMachine();
      this.cancelAllScheduledPolls();
      if (name != void 0)
        this.name = name;
      if (location != void 0)
        this.location = location;
      for (const { value, ...valueId } of preservedValues) {
        this.valueDB.setValue(valueId, value, { noEvent: true });
      }
      for (const { metadata, ...valueId } of preservedMetadata) {
        this.valueDB.setMetadata(valueId, metadata, { noEvent: true });
      }
      this.keepAwake = false;
      if (didWakeUp || wasAwake) {
        this.isListening = false;
        this.isFrequentListening = false;
        this.markAsAwake();
      }
      void this.driver.interviewNodeInternal(this);
      this._refreshInfoPending = false;
    }
    /**
     * @internal
     * Interviews this node. Returns true when it succeeded, false otherwise
     *
     * WARNING: Do not call this method from application code. To refresh the information
     * for a specific node, use `node.refreshInfo()` instead
     */
    async interviewInternal() {
      if (this.interviewStage === import_Types.InterviewStage.Complete) {
        this.driver.controllerLog.logNode(this.id, `skipping interview because it is already completed`);
        return true;
      } else {
        this.driver.controllerLog.interviewStart(this);
      }
      this._interviewAttempts++;
      const tryInterviewStage = /* @__PURE__ */ __name(async (method) => {
        try {
          await method();
          return true;
        } catch (e) {
          if ((0, import_core.isTransmissionError)(e)) {
            return false;
          }
          throw e;
        }
      }, "tryInterviewStage");
      if (this.interviewStage === import_Types.InterviewStage.None) {
        this.driver.controllerLog.logNode(this.id, `new node, doing a full interview...`);
        this.emit("interview started", this);
        await this.queryProtocolInfo();
      }
      if (!this.isControllerNode) {
        if ((this.isListening || this.isFrequentListening) && this.status !== import_Types.NodeStatus.Alive) {
          if (!await this.ping()) {
            return false;
          }
        }
        if (this.interviewStage === import_Types.InterviewStage.ProtocolInfo) {
          if (!await tryInterviewStage(() => this.interviewNodeInfo())) {
            return false;
          }
        }
        if (this.interviewStage === import_Types.InterviewStage.NodeInfo) {
          if (await this.interviewCCs()) {
            this.setInterviewStage(import_Types.InterviewStage.CommandClasses);
          } else {
            return false;
          }
        }
      }
      if (this.isControllerNode && this.interviewStage === import_Types.InterviewStage.ProtocolInfo || !this.isControllerNode && this.interviewStage === import_Types.InterviewStage.CommandClasses) {
        await this.overwriteConfig();
      }
      this.cachedDeviceConfigHash = await this.deviceConfig?.getHash();
      this.setInterviewStage(import_Types.InterviewStage.Complete);
      this.updateReadyMachine({ value: "INTERVIEW_DONE" });
      this.emit("interview completed", this);
      return true;
    }
    /** Updates this node's interview stage and saves to cache when appropriate */
    setInterviewStage(completedStage) {
      this.interviewStage = completedStage;
      this.emit("interview stage completed", this, (0, import_shared.getEnumMemberName)(import_Types.InterviewStage, completedStage));
      this.driver.controllerLog.interviewStage(this);
    }
    /** Step #1 of the node interview */
    async queryProtocolInfo() {
      this.driver.controllerLog.logNode(this.id, {
        message: "querying protocol info...",
        direction: "outbound"
      });
      this.driver.requestStorage.set(import_serial.FunctionType.GetNodeProtocolInfo, {
        nodeId: this.id
      });
      const resp = await this.driver.sendMessage(new import_serialapi.GetNodeProtocolInfoRequest({
        requestedNodeId: this.id
      }));
      this.isListening = resp.isListening;
      this.isFrequentListening = resp.isFrequentListening;
      this.isRouting = resp.isRouting;
      this.supportedDataRates = resp.supportedDataRates;
      this.protocolVersion = resp.protocolVersion;
      this.nodeType = resp.nodeType;
      this.supportsSecurity = resp.supportsSecurity;
      this.supportsBeaming = resp.supportsBeaming;
      this.deviceClass = new import_DeviceClass.DeviceClass(resp.basicDeviceClass, resp.genericDeviceClass, resp.specificDeviceClass);
      const logMessage = `received response for protocol info:
basic device class:    ${(0, import_shared.getEnumMemberName)(import_core.BasicDeviceClass, this.deviceClass.basic)}
generic device class:  ${this.deviceClass.generic.label}
specific device class: ${this.deviceClass.specific.label}
node type:             ${(0, import_shared.getEnumMemberName)(import_core.NodeType, this.nodeType)}
is always listening:   ${this.isListening}
is frequent listening: ${this.isFrequentListening}
can route messages:    ${this.isRouting}
supports security:     ${this.supportsSecurity}
supports beaming:      ${this.supportsBeaming}
maximum data rate:     ${this.maxDataRate} kbps
protocol version:      ${this.protocolVersion}`;
      this.driver.controllerLog.logNode(this.id, {
        message: logMessage,
        direction: "inbound"
      });
      if (this.canSleep) {
        if (this.status === import_Types.NodeStatus.Alive) {
          this.markAsAwake();
        } else if (this.status !== import_Types.NodeStatus.Awake) {
          this.markAsAsleep();
        }
      }
      this.setInterviewStage(import_Types.InterviewStage.ProtocolInfo);
    }
    /**
     * Pings the node to see if it responds
     * @param tryReallyHard Whether the controller should resort to route resolution
     * and explorer frames if the communication fails. Setting this option to `true`
     * can result in multi-second delays.
     */
    async ping(tryReallyHard = false) {
      if (this.isControllerNode) {
        this.driver.controllerLog.logNode(this.id, "is the controller node, cannot ping", "warn");
        return true;
      }
      this.driver.controllerLog.logNode(this.id, {
        message: "pinging the node...",
        direction: "outbound"
      });
      try {
        let api = this.commandClasses["No Operation"];
        if (tryReallyHard) {
          api = api.withOptions({
            transmitOptions: import_core.TransmitOptions.DEFAULT
          });
        }
        await api.send();
        this.driver.controllerLog.logNode(this.id, {
          message: "ping successful",
          direction: "inbound"
        });
        return true;
      } catch (e) {
        this.driver.controllerLog.logNode(this.id, `ping failed: ${(0, import_shared.getErrorMessage)(e)}`);
        return false;
      }
    }
    /**
     * Step #5 of the node interview
     * Request node info
     */
    async interviewNodeInfo() {
      if (this.isControllerNode) {
        this.driver.controllerLog.logNode(this.id, "is the controller node, cannot query node info", "warn");
        return;
      }
      for (let attempts = 1; attempts <= 2; attempts++) {
        this.driver.controllerLog.logNode(this.id, {
          message: "querying node info...",
          direction: "outbound"
        });
        try {
          const nodeInfo = await this.requestNodeInfo();
          const logLines = [
            "node info received",
            "supported CCs:"
          ];
          for (const cc of nodeInfo.supportedCCs) {
            logLines.push(`\xB7 ${(0, import_core.getCCName)(cc)}`);
          }
          this.driver.controllerLog.logNode(this.id, {
            message: logLines.join("\n"),
            direction: "inbound"
          });
          this.updateNodeInfo(nodeInfo);
          break;
        } catch (e) {
          if ((0, import_core.isZWaveError)(e)) {
            if (attempts === 1 && this.canSleep && this.status !== import_Types.NodeStatus.Asleep && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              this.driver.controllerLog.logNode(this.id, `Querying the node info failed, the node is probably asleep. Retrying after wakeup...`, "error");
              this.markAsAsleep();
              continue;
            }
            if (e.code === import_core.ZWaveErrorCodes.Controller_ResponseNOK || e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              this.driver.controllerLog.logNode(this.id, `Querying the node info failed`, "error");
            }
            throw e;
          }
        }
      }
      this.setInterviewStage(import_Types.InterviewStage.NodeInfo);
    }
    async requestNodeInfo() {
      const resp = await this.driver.sendMessage(new import_serialapi.RequestNodeInfoRequest({ nodeId: this.id }));
      if (resp instanceof import_serialapi.RequestNodeInfoResponse && !resp.wasSent) {
        throw new import_core.ZWaveError(`Querying the node info failed`, import_core.ZWaveErrorCodes.Controller_ResponseNOK);
      } else if (resp instanceof import_serialapi.ApplicationUpdateRequestNodeInfoRequestFailed) {
        throw new import_core.ZWaveError(`Querying the node info failed`, import_core.ZWaveErrorCodes.Controller_CallbackNOK);
      } else if (resp instanceof import_serialapi.ApplicationUpdateRequestNodeInfoReceived) {
        const logLines = ["node info received", "supported CCs:"];
        for (const cc of resp.nodeInformation.supportedCCs) {
          logLines.push(`\xB7 ${(0, import_core.getCCName)(cc)}`);
        }
        this.driver.controllerLog.logNode(this.id, {
          message: logLines.join("\n"),
          direction: "inbound"
        });
        return resp.nodeInformation;
      }
      throw new import_core.ZWaveError(`Received unexpected response to RequestNodeInfoRequest`, import_core.ZWaveErrorCodes.Controller_CommandError);
    }
    /** Step #? of the node interview */
    async interviewCCs() {
      if (this.isControllerNode) {
        this.driver.controllerLog.logNode(this.id, "is the controller node, cannot interview CCs", "warn");
        return true;
      }
      const securityManager2 = this.driver.getSecurityManager2(this.id);
      const interviewEndpoint = /* @__PURE__ */ __name(async (endpoint, cc, force = false) => {
        let instance;
        try {
          if (force) {
            instance = import_cc.CommandClass.createInstanceUnchecked(endpoint, cc);
          } else {
            instance = endpoint.createCCInstance(cc);
          }
        } catch (e) {
          if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.CC_NotSupported) {
            return "continue";
          }
          throw e;
        }
        if (endpoint.isCCSecure(cc) && !this.driver.securityManager && !securityManager2) {
          this.driver.controllerLog.logNode(this.id, `Skipping interview for secure CC ${(0, import_core.getCCName)(cc)} because no network key is configured!`, "error");
          return "continue";
        }
        if (instance.isInterviewComplete(this.driver))
          return "continue";
        try {
          await instance.interview(this.driver);
        } catch (e) {
          if ((0, import_core.isTransmissionError)(e)) {
            return false;
          }
          throw e;
        }
      }, "interviewEndpoint");
      if (this.supportsCC(import_core.CommandClasses["Security 2"])) {
        this.addCC(import_core.CommandClasses["Security 2"], { secure: true });
        const securityClass = this.getHighestSecurityClass();
        if (securityClass == void 0 || (0, import_core.securityClassIsS2)(securityClass)) {
          this.driver.controllerLog.logNode(this.id, "Root device interview: Security S2", "silly");
          if (!securityManager2) {
            if (!this._hasEmittedNoS2NetworkKeyError) {
              const errorMessage = `supports Security S2, but no S2 network keys were configured. The interview might not include all functionality.`;
              this.driver.controllerLog.logNode(this.id, errorMessage, "error");
              this.driver.emit("error", new import_core.ZWaveError(`Node ${this.id.toString().padStart(3, "0")} ${errorMessage}`, import_core.ZWaveErrorCodes.Controller_NodeInsecureCommunication));
              this._hasEmittedNoS2NetworkKeyError = true;
            }
          } else {
            const action = await interviewEndpoint(this, import_core.CommandClasses["Security 2"]);
            if (typeof action === "boolean")
              return action;
          }
        }
      } else {
        for (const secClass of [
          import_core.SecurityClass.S2_AccessControl,
          import_core.SecurityClass.S2_Authenticated,
          import_core.SecurityClass.S2_Unauthenticated
        ]) {
          if (this.hasSecurityClass(secClass) === import_core.NOT_KNOWN) {
            this.securityClasses.set(secClass, false);
          }
        }
      }
      if (this.supportsCC(import_core.CommandClasses.Security)) {
        this.addCC(import_core.CommandClasses.Security, { secure: true });
        if (this.hasSecurityClass(import_core.SecurityClass.S0_Legacy) !== false) {
          this.driver.controllerLog.logNode(this.id, "Root device interview: Security S0", "silly");
          if (!this.driver.securityManager) {
            if (!this._hasEmittedNoS0NetworkKeyError) {
              const errorMessage = `supports Security S0, but the S0 network key was not configured. The interview might not include all functionality.`;
              this.driver.controllerLog.logNode(this.id, errorMessage, "error");
              this.driver.emit("error", new import_core.ZWaveError(`Node ${this.id.toString().padStart(3, "0")} ${errorMessage}`, import_core.ZWaveErrorCodes.Controller_NodeInsecureCommunication));
              this._hasEmittedNoS0NetworkKeyError = true;
            }
          } else {
            const action = await interviewEndpoint(this, import_core.CommandClasses.Security);
            if (typeof action === "boolean")
              return action;
          }
        }
      } else {
        if (this.hasSecurityClass(import_core.SecurityClass.S0_Legacy) === import_core.NOT_KNOWN) {
          this.securityClasses.set(import_core.SecurityClass.S0_Legacy, false);
        }
      }
      if (this.supportsCC(import_core.CommandClasses["Manufacturer Specific"])) {
        this.driver.controllerLog.logNode(this.id, "Root device interview: Manufacturer Specific", "silly");
        const action = await interviewEndpoint(this, import_core.CommandClasses["Manufacturer Specific"]);
        if (typeof action === "boolean")
          return action;
      }
      if (this.supportsCC(import_core.CommandClasses.Version)) {
        this.driver.controllerLog.logNode(this.id, "Root device interview: Version", "silly");
        const action = await interviewEndpoint(this, import_core.CommandClasses.Version);
        if (typeof action === "boolean")
          return action;
        await this.loadDeviceConfig();
        this.applyCommandClassesCompatFlag(0);
      } else {
        this.driver.controllerLog.logNode(this.id, "Version CC is not supported. Using the highest implemented version for each CC", "debug");
        for (const [ccId, info] of this.getCCs()) {
          if (info.isSupported || ccId === import_core.CommandClasses.Basic) {
            this.addCC(ccId, { version: (0, import_cc.getImplementedVersion)(ccId) });
          }
        }
      }
      if (this.supportsCC(import_core.CommandClasses["Wake Up"])) {
        this.driver.controllerLog.logNode(this.id, "Root device interview: Wake Up", "silly");
        const action = await interviewEndpoint(this, import_core.CommandClasses["Wake Up"]);
        if (typeof action === "boolean")
          return action;
      }
      this.modifySupportedCCBeforeInterview(this);
      const specialCCs = [
        import_core.CommandClasses.Security,
        import_core.CommandClasses["Security 2"],
        import_core.CommandClasses["Manufacturer Specific"],
        import_core.CommandClasses.Version,
        import_core.CommandClasses["Wake Up"],
        // Basic CC is interviewed last
        import_core.CommandClasses.Basic
      ];
      const rootInterviewGraphBeforeEndpoints = this.buildCCInterviewGraph([
        ...specialCCs,
        ...import_core.applicationCCs
      ]);
      let rootInterviewOrderBeforeEndpoints;
      const rootInterviewGraphAfterEndpoints = this.buildCCInterviewGraph([
        ...specialCCs,
        ...import_core.nonApplicationCCs
      ]);
      let rootInterviewOrderAfterEndpoints;
      try {
        rootInterviewOrderBeforeEndpoints = (0, import_core.topologicalSort)(rootInterviewGraphBeforeEndpoints);
        rootInterviewOrderAfterEndpoints = (0, import_core.topologicalSort)(rootInterviewGraphAfterEndpoints);
      } catch {
        throw new import_core.ZWaveError("The CC interview cannot be completed because there are circular dependencies between CCs!", import_core.ZWaveErrorCodes.CC_Invalid);
      }
      this.driver.controllerLog.logNode(this.id, `Root device interviews before endpoints: ${rootInterviewOrderBeforeEndpoints.map((cc) => `
\xB7 ${(0, import_core.getCCName)(cc)}`).join("")}`, "silly");
      this.driver.controllerLog.logNode(this.id, `Root device interviews after endpoints: ${rootInterviewOrderAfterEndpoints.map((cc) => `
\xB7 ${(0, import_core.getCCName)(cc)}`).join("")}`, "silly");
      for (const cc of rootInterviewOrderBeforeEndpoints) {
        this.driver.controllerLog.logNode(this.id, `Root device interview: ${(0, import_core.getCCName)(cc)}`, "silly");
        const action = await interviewEndpoint(this, cc);
        if (action === "continue")
          continue;
        else if (typeof action === "boolean")
          return action;
      }
      this.applyCommandClassesCompatFlag();
      for (const endpointIndex of this.getEndpointIndizes()) {
        const endpoint = this.getEndpoint(endpointIndex);
        if (!endpoint)
          continue;
        const securityClass = this.getHighestSecurityClass();
        const endpointMissingS2 = (0, import_core.securityClassIsS2)(securityClass) && this.supportsCC(import_core.CommandClasses["Security 2"]) && !endpoint.supportsCC(import_core.CommandClasses["Security 2"]);
        if (endpointMissingS2) {
          endpoint.addCC(import_core.CommandClasses["Security 2"], this.implementedCommandClasses.get(import_core.CommandClasses["Security 2"]));
        }
        if (endpoint.supportsCC(import_core.CommandClasses["Security 2"])) {
          endpoint.addCC(import_core.CommandClasses["Security 2"], { secure: true });
          if ((0, import_core.securityClassIsS2)(securityClass) && !!securityManager2) {
            this.driver.controllerLog.logNode(this.id, {
              endpoint: endpoint.index,
              message: `Endpoint ${endpoint.index} interview: Security S2`,
              level: "silly"
            });
            const action = await interviewEndpoint(endpoint, import_core.CommandClasses["Security 2"]);
            if (typeof action === "boolean")
              return action;
          }
        }
        if (endpoint.supportsCC(import_core.CommandClasses.Security)) {
          endpoint.addCC(import_core.CommandClasses.Security, { secure: true });
          if (securityClass === import_core.SecurityClass.S0_Legacy && !!this.driver.securityManager) {
            this.driver.controllerLog.logNode(this.id, {
              endpoint: endpoint.index,
              message: `Endpoint ${endpoint.index} interview: Security S0`,
              level: "silly"
            });
            const action = await interviewEndpoint(endpoint, import_core.CommandClasses.Security);
            if (typeof action === "boolean")
              return action;
          }
        }
        const endpointMissingS0 = securityClass === import_core.SecurityClass.S0_Legacy && this.supportsCC(import_core.CommandClasses.Security) && !endpoint.supportsCC(import_core.CommandClasses.Security);
        if (endpointMissingS0) {
          const possibleTests = [
            {
              ccId: import_core.CommandClasses["Z-Wave Plus Info"],
              test: /* @__PURE__ */ __name(() => endpoint.commandClasses["Z-Wave Plus Info"].get(), "test")
            },
            {
              ccId: import_core.CommandClasses["Binary Switch"],
              test: /* @__PURE__ */ __name(() => endpoint.commandClasses["Binary Switch"].get(), "test")
            },
            {
              ccId: import_core.CommandClasses["Binary Sensor"],
              test: /* @__PURE__ */ __name(() => endpoint.commandClasses["Binary Sensor"].get(), "test")
            },
            {
              ccId: import_core.CommandClasses["Multilevel Switch"],
              test: /* @__PURE__ */ __name(() => endpoint.commandClasses["Multilevel Switch"].get(), "test")
            },
            {
              ccId: import_core.CommandClasses["Multilevel Sensor"],
              test: /* @__PURE__ */ __name(() => endpoint.commandClasses["Multilevel Sensor"].get(), "test")
            }
            // TODO: add other tests if necessary
          ];
          const foundTest = possibleTests.find((t) => endpoint.supportsCC(t.ccId));
          if (foundTest) {
            this.driver.controllerLog.logNode(this.id, {
              endpoint: endpoint.index,
              message: `is included using Security S0, but endpoint ${endpoint.index} does not list the CC. Testing if it accepts secure commands anyways.`,
              level: "silly"
            });
            const { ccId, test } = foundTest;
            endpoint.addCC(ccId, { secure: true });
            const success = !!await test().catch(() => false);
            if (success) {
              this.driver.controllerLog.logNode(this.id, {
                endpoint: endpoint.index,
                message: `Endpoint ${endpoint.index} accepts/expects secure commands`,
                level: "silly"
              });
              for (const [ccId2] of endpoint.getCCs()) {
                endpoint.addCC(ccId2, { secure: true });
              }
            } else {
              this.driver.controllerLog.logNode(this.id, {
                endpoint: endpoint.index,
                message: `Endpoint ${endpoint.index} is actually not using S0`,
                level: "silly"
              });
              endpoint.addCC(ccId, { secure: false });
            }
          } else {
            this.driver.controllerLog.logNode(this.id, {
              endpoint: endpoint.index,
              message: `is included using Security S0, but endpoint ${endpoint.index} does not list the CC. Found no way to test if accepts secure commands anyways.`,
              level: "silly"
            });
          }
        }
        if (this.supportsCC(import_core.CommandClasses.Version)) {
          this.driver.controllerLog.logNode(this.id, {
            endpoint: endpoint.index,
            message: `Endpoint ${endpoint.index} interview: ${(0, import_core.getCCName)(import_core.CommandClasses.Version)}`,
            level: "silly"
          });
          const action = await interviewEndpoint(endpoint, import_core.CommandClasses.Version, true);
          if (typeof action === "boolean")
            return action;
        } else {
          this.driver.controllerLog.logNode(this.id, {
            endpoint: endpoint.index,
            message: "Version CC is not supported. Using the highest implemented version for each CC",
            level: "debug"
          });
          for (const [ccId, info] of endpoint.getCCs()) {
            if (info.isSupported || ccId === import_core.CommandClasses.Basic) {
              endpoint.addCC(ccId, {
                version: (0, import_cc.getImplementedVersion)(ccId)
              });
            }
          }
        }
        this.applyCommandClassesCompatFlag(endpoint.index);
        this.modifySupportedCCBeforeInterview(endpoint);
        const endpointInterviewGraph = endpoint.buildCCInterviewGraph([
          import_core.CommandClasses.Security,
          import_core.CommandClasses["Security 2"],
          import_core.CommandClasses.Version,
          import_core.CommandClasses.Basic
        ]);
        let endpointInterviewOrder;
        try {
          endpointInterviewOrder = (0, import_core.topologicalSort)(endpointInterviewGraph);
        } catch {
          throw new import_core.ZWaveError("The CC interview cannot be completed because there are circular dependencies between CCs!", import_core.ZWaveErrorCodes.CC_Invalid);
        }
        this.driver.controllerLog.logNode(this.id, {
          endpoint: endpoint.index,
          message: `Endpoint ${endpoint.index} interview order: ${endpointInterviewOrder.map((cc) => `
\xB7 ${(0, import_core.getCCName)(cc)}`).join("")}`,
          level: "silly"
        });
        for (const cc of endpointInterviewOrder) {
          this.driver.controllerLog.logNode(this.id, {
            endpoint: endpoint.index,
            message: `Endpoint ${endpoint.index} interview: ${(0, import_core.getCCName)(cc)}`,
            level: "silly"
          });
          const action = await interviewEndpoint(endpoint, cc);
          if (action === "continue")
            continue;
          else if (typeof action === "boolean")
            return action;
        }
      }
      for (const cc of rootInterviewOrderAfterEndpoints) {
        this.driver.controllerLog.logNode(this.id, `Root device interview: ${(0, import_core.getCCName)(cc)}`, "silly");
        const action = await interviewEndpoint(this, cc);
        if (action === "continue")
          continue;
        else if (typeof action === "boolean")
          return action;
      }
      const compat = this.deviceConfig?.compat;
      if (!this.wasCCRemovedViaConfig(import_core.CommandClasses.Basic) && this.getCCVersion(import_core.CommandClasses.Basic) > 0) {
        if (this.maySupportBasicCC()) {
          this.driver.controllerLog.logNode(this.id, `Root device interview: ${(0, import_core.getCCName)(import_core.CommandClasses.Basic)}`, "silly");
          const action = await interviewEndpoint(this, import_core.CommandClasses.Basic, true);
          if (typeof action === "boolean")
            return action;
        } else {
          if (compat?.mapBasicReport === false || compat?.mapBasicSet === "report") {
            this.addCC(import_core.CommandClasses.Basic, { isControlled: true });
          }
        }
      }
      for (const endpointIndex of this.getEndpointIndizes()) {
        const endpoint = this.getEndpoint(endpointIndex);
        if (!endpoint)
          continue;
        if (endpoint.wasCCRemovedViaConfig(import_core.CommandClasses.Basic))
          continue;
        if (endpoint.getCCVersion(import_core.CommandClasses.Basic) === 0)
          continue;
        if (endpoint.maySupportBasicCC()) {
          this.driver.controllerLog.logNode(this.id, {
            endpoint: endpoint.index,
            message: `Endpoint ${endpoint.index} interview: Basic CC`,
            level: "silly"
          });
          const action = await interviewEndpoint(endpoint, import_core.CommandClasses.Basic, true);
          if (typeof action === "boolean")
            return action;
        } else {
          if (compat?.mapBasicReport === false || compat?.mapBasicSet === "report") {
            endpoint.addCC(import_core.CommandClasses.Basic, {
              isControlled: true
            });
          }
        }
      }
      return true;
    }
    /**
     * @internal
     * Handles the receipt of a NIF / NodeUpdatePayload
     */
    updateNodeInfo(nodeInfo) {
      if (this.interviewStage < import_Types.InterviewStage.NodeInfo) {
        for (const cc of nodeInfo.supportedCCs) {
          if (cc === import_core.CommandClasses.Basic) {
            continue;
          }
          this.addCC(cc, { isSupported: true });
        }
      }
      this.markAsAwake();
      if (this.interviewStage === import_Types.InterviewStage.Complete && !this.supportsCC(import_core.CommandClasses["Z-Wave Plus Info"]) && (!this.valueDB.getValue(import_AssociationCC.AssociationCCValues.hasLifeline.id) || !import_cc.utils.doesAnyLifelineSendActuatorOrSensorReports(this.driver, this))) {
        const delay = this.deviceConfig?.compat?.manualValueRefreshDelayMs || 0;
        this.driver.controllerLog.logNode(this.id, {
          message: `Node does not send unsolicited updates; refreshing actuator and sensor values${delay > 0 ? ` in ${delay} ms` : ""}...`
        });
        setTimeout(() => this.refreshValues(), delay);
      }
    }
    /**
     * Rediscovers all capabilities of a single CC on this node and all endpoints.
     * This can be considered a more targeted variant of `refreshInfo`.
     *
     * WARNING: It is not recommended to await this method!
     */
    async interviewCC(cc) {
      const endpoints = this.getAllEndpoints();
      endpoints.push(endpoints.shift());
      for (const endpoint of endpoints) {
        const instance = endpoint.createCCInstanceUnsafe(cc);
        if (instance) {
          try {
            await instance.interview(this.driver);
          } catch (e) {
            this.driver.controllerLog.logNode(this.id, `failed to interview CC ${(0, import_core.getCCName)(cc)}, endpoint ${endpoint.index}: ${(0, import_shared.getErrorMessage)(e)}`, "error");
          }
        }
      }
    }
    /**
     * Refreshes all non-static values of a single CC from this node (all endpoints).
     * WARNING: It is not recommended to await this method!
     */
    async refreshCCValues(cc) {
      for (const endpoint of this.getAllEndpoints()) {
        const instance = endpoint.createCCInstanceUnsafe(cc);
        if (instance) {
          try {
            await instance.refreshValues(this.driver);
          } catch (e) {
            this.driver.controllerLog.logNode(this.id, `failed to refresh values for ${(0, import_core.getCCName)(cc)}, endpoint ${endpoint.index}: ${(0, import_shared.getErrorMessage)(e)}`, "error");
          }
        }
      }
    }
    /**
     * Refreshes all non-static values from this node's actuator and sensor CCs.
     * WARNING: It is not recommended to await this method!
     */
    async refreshValues() {
      for (const endpoint of this.getAllEndpoints()) {
        for (const cc of endpoint.getSupportedCCInstances()) {
          if (!import_core.actuatorCCs.includes(cc.ccId) && !import_core.sensorCCs.includes(cc.ccId)) {
            continue;
          }
          try {
            await cc.refreshValues(this.driver);
          } catch (e) {
            this.driver.controllerLog.logNode(this.id, `failed to refresh values for ${(0, import_core.getCCName)(cc.ccId)}, endpoint ${endpoint.index}: ${(0, import_shared.getErrorMessage)(e)}`, "error");
          }
        }
      }
    }
    /**
     * Refreshes the values of all CCs that should be reporting regularly, but haven't been updated recently
     * @internal
     */
    async autoRefreshValues() {
      if (this.status === import_Types.NodeStatus.Dead)
        return;
      for (const endpoint of this.getAllEndpoints()) {
        for (const cc of endpoint.getSupportedCCInstances()) {
          if (!cc.shouldRefreshValues(this.driver))
            continue;
          this.driver.controllerLog.logNode(this.id, {
            message: `${(0, import_core.getCCName)(cc.ccId)} CC values may be stale, refreshing...`,
            endpoint: endpoint.index,
            direction: "outbound"
          });
          try {
            await cc.refreshValues(this.driver);
          } catch (e) {
            this.driver.controllerLog.logNode(this.id, {
              message: `failed to refresh values for ${(0, import_core.getCCName)(cc.ccId)} CC: ${(0, import_shared.getErrorMessage)(e)}`,
              endpoint: endpoint.index,
              level: "error"
            });
          }
        }
      }
    }
    /**
     * Uses the `commandClasses` compat flag defined in the node's config file to
     * override the reported command classes.
     * @param endpointIndex If given, limits the application of the compat flag to the given endpoint.
     */
    applyCommandClassesCompatFlag(endpointIndex) {
      if (this.deviceConfig) {
        const addCCs = this.deviceConfig.compat?.addCCs;
        if (addCCs) {
          for (const [cc, { endpoints }] of addCCs) {
            if (endpointIndex === void 0) {
              for (const [ep, info] of endpoints) {
                this.getEndpoint(ep)?.addCC(cc, info);
              }
            } else if (endpoints.has(endpointIndex)) {
              this.getEndpoint(endpointIndex)?.addCC(cc, endpoints.get(endpointIndex));
            }
          }
        }
        const removeCCs = this.deviceConfig.compat?.removeCCs;
        if (removeCCs) {
          for (const [cc, endpoints] of removeCCs) {
            if (endpoints === "*") {
              if (endpointIndex === void 0) {
                for (const ep of this.getAllEndpoints()) {
                  ep.removeCC(cc);
                }
              } else {
                this.getEndpoint(endpointIndex)?.removeCC(cc);
              }
            } else {
              if (endpointIndex === void 0) {
                for (const ep of endpoints) {
                  this.getEndpoint(ep)?.removeCC(cc);
                }
              } else if (endpoints.includes(endpointIndex)) {
                this.getEndpoint(endpointIndex)?.removeCC(cc);
              }
            }
          }
        }
      }
    }
    /**
     * Updates the supported CCs of the given endpoint depending on compat flags
     * and certification requirements
     */
    modifySupportedCCBeforeInterview(endpoint) {
      if (endpoint.supportsCC(import_core.CommandClasses["Multilevel Switch"]) && endpoint.supportsCC(import_core.CommandClasses["Window Covering"])) {
        endpoint.removeCC(import_core.CommandClasses["Multilevel Switch"]);
      }
    }
    /** Overwrites the reported configuration with information from a config file */
    async overwriteConfig() {
      if (this.isControllerNode) {
        await this.loadDeviceConfig();
      }
      if (this.deviceConfig) {
        const addCCs = this.deviceConfig.compat?.addCCs;
        if (addCCs) {
          for (const [cc, { endpoints }] of addCCs) {
            for (const [ep, info] of endpoints) {
              this.getEndpoint(ep)?.addCC(cc, info);
            }
          }
        }
        const removeCCs = this.deviceConfig.compat?.removeCCs;
        if (removeCCs) {
          for (const [cc, endpoints] of removeCCs) {
            if (endpoints === "*") {
              for (const ep of this.getAllEndpoints()) {
                ep.removeCC(cc);
              }
            } else {
              for (const ep of endpoints) {
                this.getEndpoint(ep)?.removeCC(cc);
              }
            }
          }
        }
      }
      this.setInterviewStage(import_Types.InterviewStage.OverwriteConfig);
    }
    centralSceneHandlerStore = (0, import_CentralSceneCC2.getDefaultCentralSceneHandlerStore)();
    clockHandlerStore = (0, import_ClockCC2.getDefaultClockHandlerStore)();
    hailHandlerStore = (0, import_HailCC2.getDefaultHailHandlerStore)();
    notificationHandlerStore = (0, import_NotificationCC2.getDefaultNotificationHandlerStore)();
    wakeUpHandlerStore = (0, import_WakeUpCC2.getDefaultWakeUpHandlerStore)();
    entryControlHandlerStore = (0, import_EntryControlCC2.getDefaultEntryControlHandlerStore)();
    /**
     * @internal
     * Handles a CommandClass that was received from this node
     */
    async handleCommand(command) {
      if (command.endpointIndex === 0 && command.constructor.name.endsWith("Report") && this.getEndpointCount() >= 1 && this.deviceConfig?.compat?.mapRootReportsToEndpoint != void 0) {
        const endpoint2 = this.getEndpoint(this.deviceConfig?.compat?.mapRootReportsToEndpoint);
        if (endpoint2 && endpoint2.supportsCC(command.ccId)) {
          this.driver.controllerLog.logNode(this.id, `Mapping unsolicited report from root device to endpoint #${endpoint2.index}`);
          command.endpointIndex = endpoint2.index;
          command.persistValues(this.driver);
        }
      }
      if (command.constructor.name.endsWith("Get") && !(command instanceof import_SecurityCC.SecurityCCNonceGet) && !(command instanceof import_Security2CC.Security2CCNonceGet)) {
        this.markAsAwake();
      }
      const endpoint = this.getEndpoint(command.endpointIndex);
      if (endpoint?.wasCCRemovedViaConfig(command.ccId)) {
        this.driver.controllerLog.logNode(this.id, {
          endpoint: endpoint.index,
          direction: "inbound",
          message: `Ignoring ${command.constructor.name} because CC support was removed via config file`
        });
        return;
      }
      if (command instanceof import_BasicCC.BasicCC) {
        return (0, import_BasicCC2.handleBasicCommand)(this.driver, this, command);
      } else if (command instanceof import_MultilevelSwitchCC.MultilevelSwitchCC) {
        return (0, import_MultilevelSwitchCC2.handleMultilevelSwitchCommand)(this.driver, this, command);
      } else if (command instanceof import_BinarySwitchCC.BinarySwitchCCSet) {
        return (0, import_BinarySwitchCC2.handleBinarySwitchCommand)(this.driver, this, command);
      } else if (command instanceof import_ThermostatModeCC.ThermostatModeCCSet) {
        return (0, import_ThermostatModeCC2.handleThermostatModeCommand)(this.driver, this, command);
      } else if (command instanceof import_CentralSceneCC.CentralSceneCCNotification) {
        return (0, import_CentralSceneCC2.handleCentralSceneNotification)(this.driver, this, command, this.centralSceneHandlerStore);
      } else if (command instanceof import_WakeUpCC.WakeUpCCWakeUpNotification) {
        return (0, import_WakeUpCC2.handleWakeUpNotification)(this.driver, this, command, this.wakeUpHandlerStore);
      } else if (command instanceof import_NotificationCC.NotificationCCReport) {
        return (0, import_NotificationCC2.handleNotificationReport)(this.driver, this, command, this.notificationHandlerStore);
      } else if (command instanceof import_cc.BatteryCCReport) {
        return (0, import_BatteryCC.handleBatteryReport)(this.driver, this, command);
      } else if (command instanceof import_ClockCC.ClockCCReport) {
        return (0, import_ClockCC2.handleClockReport)(this.driver, this, command, this.clockHandlerStore);
      } else if (command instanceof import_HailCC.HailCC) {
        return (0, import_HailCC2.handleHail)(this.driver, this, command, this.hailHandlerStore);
      } else if (command instanceof import_FirmwareUpdateMetaDataCC.FirmwareUpdateMetaDataCCGet) {
        return this.handleUnexpectedFirmwareUpdateGet(command);
      } else if (command instanceof import_FirmwareUpdateMetaDataCC.FirmwareUpdateMetaDataCCMetaDataGet) {
        return this.handleFirmwareUpdateMetaDataGet(command);
      } else if (command instanceof import_FirmwareUpdateMetaDataCC.FirmwareUpdateMetaDataCCRequestGet) {
        return this.handleFirmwareUpdateRequestGet(command);
      } else if (command instanceof import_FirmwareUpdateMetaDataCC.FirmwareUpdateMetaDataCCPrepareGet) {
        return this.handleFirmwareUpdatePrepareGet(command);
      } else if (command instanceof import_EntryControlCC.EntryControlCCNotification) {
        return (0, import_EntryControlCC2.handleEntryControlNotification)(this.driver, this, command, this.entryControlHandlerStore);
      } else if (command instanceof import_cc.TimeCCTimeGet) {
        return (0, import_TimeCC.handleTimeGet)(this.driver, this, command);
      } else if (command instanceof import_cc.TimeCCDateGet) {
        return (0, import_TimeCC.handleDateGet)(this.driver, this, command);
      } else if (command instanceof import_cc.TimeCCTimeOffsetGet) {
        return (0, import_TimeCC.handleTimeOffsetGet)(this.driver, this, command);
      } else if (command instanceof import_ZWavePlusCC.ZWavePlusCCGet) {
        return (0, import_ZWavePlusCC2.handleZWavePlusGet)(this.driver, this, command, this.driver.options.vendor);
      } else if (command instanceof import_VersionCC.VersionCCGet) {
        return (0, import_VersionCC2.handleVersionGet)(this.driver, this.driver.controller, this, command, this.driver.options.vendor);
      } else if (command instanceof import_VersionCC.VersionCCCommandClassGet) {
        let reportVersion;
        if (this.driver.options.features.disableCommandClasses?.includes(command.requestedCC)) {
          reportVersion = 0;
        }
        return (0, import_VersionCC2.handleVersionCommandClassGet)(this.driver, this, command, reportVersion);
      } else if (command instanceof import_VersionCC.VersionCCCapabilitiesGet) {
        return (0, import_VersionCC2.handleVersionCapabilitiesGet)(this.driver, this, command);
      } else if (command instanceof import_ManufacturerSpecificCC.ManufacturerSpecificCCGet) {
        return (0, import_ManufacturerSpecificCC2.handleManufacturerSpecificGet)(this.driver, this, command, this.driver.options.vendor);
      } else if (command instanceof import_AssociationGroupInfoCC.AssociationGroupInfoCCNameGet) {
        return (0, import_AssociationGroupInformationCC.handleAGINameGet)(this.driver, this, command);
      } else if (command instanceof import_AssociationGroupInfoCC.AssociationGroupInfoCCInfoGet) {
        return (0, import_AssociationGroupInformationCC.handleAGIInfoGet)(this.driver, this, command);
      } else if (command instanceof import_AssociationGroupInfoCC.AssociationGroupInfoCCCommandListGet) {
        return (0, import_AssociationGroupInformationCC.handleAGICommandListGet)(this.driver, this, command);
      } else if (command instanceof import_AssociationCC.AssociationCCSupportedGroupingsGet) {
        return (0, import_AssociationGroupInformationCC.handleAssociationSupportedGroupingsGet)(this.driver, this, command);
      } else if (command instanceof import_AssociationCC.AssociationCCGet) {
        return (0, import_AssociationCC2.handleAssociationGet)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_AssociationCC.AssociationCCSet) {
        return (0, import_AssociationCC2.handleAssociationSet)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_AssociationCC.AssociationCCRemove) {
        return (0, import_AssociationCC2.handleAssociationRemove)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_AssociationCC.AssociationCCSpecificGroupGet) {
        return (0, import_AssociationCC2.handleAssociationSpecificGroupGet)(this.driver, this, command);
      } else if (command instanceof import_cc.MultiChannelAssociationCCSupportedGroupingsGet) {
        return (0, import_MultiChannelAssociationCC.handleMultiChannelAssociationSupportedGroupingsGet)(this.driver, this, command);
      } else if (command instanceof import_cc.MultiChannelAssociationCCGet) {
        return (0, import_MultiChannelAssociationCC.handleMultiChannelAssociationGet)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_cc.MultiChannelAssociationCCSet) {
        return (0, import_MultiChannelAssociationCC.handleMultiChannelAssociationSet)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_cc.MultiChannelAssociationCCRemove) {
        return (0, import_MultiChannelAssociationCC.handleMultiChannelAssociationRemove)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_cc.IndicatorCCSupportedGet) {
        return (0, import_IndicatorCC.handleIndicatorSupportedGet)(this.driver, this, command);
      } else if (command instanceof import_cc.IndicatorCCSet) {
        return (0, import_IndicatorCC.handleIndicatorSet)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_cc.IndicatorCCGet) {
        return (0, import_IndicatorCC.handleIndicatorGet)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_cc.IndicatorCCDescriptionGet) {
        return (0, import_IndicatorCC.handleIndicatorDescriptionGet)(this.driver, this, command);
      } else if (command instanceof import_PowerlevelCC.PowerlevelCCSet) {
        return (0, import_PowerlevelCC2.handlePowerlevelSet)(this.driver, this, command);
      } else if (command instanceof import_PowerlevelCC.PowerlevelCCGet) {
        return (0, import_PowerlevelCC2.handlePowerlevelGet)(this.driver, this, command);
      } else if (command instanceof import_PowerlevelCC.PowerlevelCCTestNodeSet) {
        return (0, import_PowerlevelCC2.handlePowerlevelTestNodeSet)(this.driver, this, command);
      } else if (command instanceof import_PowerlevelCC.PowerlevelCCTestNodeGet) {
        return (0, import_PowerlevelCC2.handlePowerlevelTestNodeGet)(this.driver, this, command);
      } else if (command instanceof import_PowerlevelCC.PowerlevelCCTestNodeReport) {
        return (0, import_PowerlevelCC2.handlePowerlevelTestNodeReport)(this.driver, this, command);
      } else if (command instanceof import_cc.DeviceResetLocallyCCNotification) {
        return (0, import_DeviceResetLocallyCC.handleDeviceResetLocallyNotification)(this.driver, this.driver.controller, this, command);
      } else if (command instanceof import_cc.MultiCommandCCCommandEncapsulation) {
        for (const cmd of command.encapsulated) {
          await this.handleCommand(cmd);
        }
        return;
      }
      switch (true) {
        // Reports are either a response to a Get command or
        // automatically store their values in the Value DB.
        // No need to manually handle them - other than what we've already done
        case command.constructor.name.endsWith("Report"):
        // When this command is received, its values get emitted as an event.
        // Nothing else to do here
        case command instanceof import_SceneActivationCC.SceneActivationCCSet:
          return;
      }
      this.driver.controllerLog.logNode(this.id, {
        message: `TODO: no handler for application command`,
        direction: "inbound"
      });
      if (command.encapsulationFlags & import_core.EncapsulationFlags.Supervision) {
        throw new import_core.ZWaveError("No handler for application command", import_core.ZWaveErrorCodes.CC_NotSupported);
      }
    }
    manuallyIdleNotificationValue(notificationTypeOrValueID, prevValue, endpointIndex = 0) {
      let notificationType;
      if (typeof notificationTypeOrValueID === "number") {
        notificationType = notificationTypeOrValueID;
      } else {
        notificationType = this.valueDB.getMetadata(notificationTypeOrValueID)?.ccSpecific?.notificationType;
        if (notificationType === void 0) {
          return;
        }
        prevValue = this.valueDB.getValue(notificationTypeOrValueID);
        endpointIndex = notificationTypeOrValueID.endpoint ?? 0;
      }
      if (!this.getEndpoint(endpointIndex)?.supportsCC(import_core.CommandClasses.Notification)) {
        return;
      }
      const notification = (0, import_core.getNotification)(notificationType);
      if (!notification)
        return;
      return (0, import_NotificationCC2.manuallyIdleNotificationValueInternal)(this.driver, this, this.notificationHandlerStore, notification, prevValue, endpointIndex);
    }
    /**
     * @internal
     * Deserializes the information of this node from a cache.
     */
    async deserialize() {
      if (!this.driver.networkCache)
        return;
      if (!this.isControllerNode) {
        await this.loadDeviceConfig();
      }
      if (this.interviewStage === import_Types.InterviewStage.Complete) {
        this.updateReadyMachine({ value: "RESTART_FROM_CACHE" });
      }
    }
    /**
     * Instructs the node to send powerlevel test frames to the other node using the given powerlevel. Returns how many frames were acknowledged during the test.
     *
     * **Note:** Depending on the number of test frames, this may take a while
     */
    async testPowerlevel(testNodeId, powerlevel, healthCheckTestFrameCount2, onProgress) {
      const api = this.commandClasses.Powerlevel;
      const wasKeptAwake = this.keepAwake;
      if (this.canSleep)
        this.keepAwake = true;
      const result = /* @__PURE__ */ __name((value) => {
        this.keepAwake = wasKeptAwake;
        return value;
      }, "result");
      await api.startNodeTest(testNodeId, powerlevel, healthCheckTestFrameCount2);
      const expectedDurationMs = Math.round(healthCheckTestFrameCount2 / 5 * 1e3);
      const pollFrequencyMs = expectedDurationMs >= 6e4 ? 2e4 : 5e3;
      let continuousErrors = 0;
      let previousProgress = 0;
      while (true) {
        const report = await this.driver.waitForCommand((cc) => cc.nodeId === this.id && cc instanceof import_PowerlevelCC.PowerlevelCCTestNodeReport, pollFrequencyMs).catch(() => void 0);
        const status = report ? (0, import_shared.pick)(report, ["status", "acknowledgedFrames"]) : await api.getNodeTestStatus().catch(() => void 0);
        if (!status || status.status === import_cc.PowerlevelTestStatus["In Progress"] && status.acknowledgedFrames === previousProgress) {
          if (continuousErrors > 5)
            return result(0);
          continuousErrors++;
          continue;
        } else {
          previousProgress = status.acknowledgedFrames;
          continuousErrors = 0;
        }
        if (status.status === import_cc.PowerlevelTestStatus.Failed) {
          return result(0);
        } else if (status.status === import_cc.PowerlevelTestStatus.Success) {
          return result(status.acknowledgedFrames);
        } else if (onProgress) {
          onProgress(status.acknowledgedFrames, healthCheckTestFrameCount2);
        }
      }
    }
    _healthCheckInProgress = false;
    /**
     * Returns whether a health check is currently in progress for this node
     */
    isHealthCheckInProgress() {
      return this._healthCheckInProgress;
    }
    _healthCheckAborted = false;
    _abortHealthCheckPromise;
    /**
     * Aborts an ongoing health check if one is currently in progress.
     *
     * **Note:** The health check may take a few seconds to actually be aborted.
     * When it is, the promise returned by {@link checkLifelineHealth} or
     * {@link checkRouteHealth} will be resolved with the results obtained so far.
     */
    abortHealthCheck() {
      if (!this._healthCheckInProgress)
        return;
      this._healthCheckAborted = true;
      this._abortHealthCheckPromise?.resolve();
    }
    /**
     * Checks the health of connection between the controller and this node and returns the results.
     */
    async checkLifelineHealth(rounds = 5, onProgress) {
      if (this._healthCheckInProgress) {
        throw new import_core.ZWaveError("A health check is already in progress for this node!", import_core.ZWaveErrorCodes.HealthCheck_Busy);
      }
      if (rounds > 10 || rounds < 1) {
        throw new import_core.ZWaveError("The number of health check rounds must be between 1 and 10!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      try {
        this._healthCheckInProgress = true;
        this._healthCheckAborted = false;
        this._abortHealthCheckPromise = (0, import_deferred_promise.createDeferredPromise)();
        return await this.checkLifelineHealthInternal(rounds, onProgress);
      } finally {
        this._healthCheckInProgress = false;
        this._healthCheckAborted = false;
        this._abortHealthCheckPromise = void 0;
      }
    }
    async checkLifelineHealthInternal(rounds, onProgress) {
      const start = Date.now();
      const computeRating = /* @__PURE__ */ __name((result) => {
        const failedPings = Math.max(result.failedPingsController ?? 0, result.failedPingsNode);
        const numNeighbors = result.numNeighbors;
        const minPowerlevel = result.minPowerlevel ?? import_cc.Powerlevel["-6 dBm"];
        const snrMargin = result.snrMargin ?? 17;
        const latency = result.latency;
        if (failedPings === 10)
          return 0;
        if (failedPings > 2)
          return 1;
        if (failedPings === 2 || latency > 1e3)
          return 2;
        if (failedPings === 1 || latency > 500)
          return 3;
        if (latency > 250)
          return 4;
        if (latency > 100)
          return 5;
        if (minPowerlevel < import_cc.Powerlevel["-6 dBm"] || snrMargin < 17) {
          if (numNeighbors == void 0)
            return 7;
          return numNeighbors > 2 ? 7 : 6;
        }
        if (numNeighbors != void 0 && numNeighbors <= 2)
          return 8;
        if (latency > 50)
          return 9;
        return 10;
      }, "computeRating");
      this.driver.controllerLog.logNode(this.id, `Starting lifeline health check (${rounds} round${rounds !== 1 ? "s" : ""})...`);
      const results = [];
      const aborted = /* @__PURE__ */ __name(() => {
        this.driver.controllerLog.logNode(this.id, `Lifeline health check aborted`);
        if (results.length === 0) {
          return {
            rating: 0,
            results: []
          };
        } else {
          return {
            rating: Math.min(...results.map((r) => r.rating)),
            results
          };
        }
      }, "aborted");
      if (this.canSleep && this.status !== import_Types.NodeStatus.Awake) {
        this.driver.controllerLog.logNode(this.id, `waiting for node to wake up...`);
        await Promise.race([
          this.waitForWakeup(),
          this._abortHealthCheckPromise
        ]);
        if (this._healthCheckAborted)
          return aborted();
      }
      for (let round = 1; round <= rounds; round++) {
        if (this._healthCheckAborted)
          return aborted();
        let numNeighbors;
        if (this.protocol === import_core.Protocols.ZWave) {
          numNeighbors = (await this.driver.controller.getNodeNeighbors(this.id, true)).length;
        }
        let txReport;
        let routeChanges;
        let rssi;
        let channel;
        let snrMargin;
        let failedPingsNode = 0;
        let latency = 0;
        const pingAPI = this.commandClasses["No Operation"].withOptions({
          // Don't change the node status when the ACK is missing. We're likely testing the limits here.
          changeNodeStatusOnMissingACK: false,
          // Avoid using explorer frames, because they can create a ton of delay
          transmitOptions: import_core.TransmitOptions.ACK | import_core.TransmitOptions.AutoRoute,
          // And remember the transmit report, so we can evaluate it
          onTXReport: /* @__PURE__ */ __name((report) => {
            txReport = report;
          }, "onTXReport")
        });
        for (let i = 1; i <= import_HealthCheck.healthCheckTestFrameCount; i++) {
          if (this._healthCheckAborted)
            return aborted();
          const start2 = Date.now();
          txReport = void 0;
          const pingResult = await pingAPI.send().then(() => true, () => false);
          const rtt = Date.now() - start2;
          latency = Math.max(latency, txReport ? txReport.txTicks * 10 : rtt);
          if (!pingResult) {
            failedPingsNode++;
          } else if (txReport) {
            routeChanges ??= 0;
            if (txReport.routingAttempts > 1) {
              routeChanges++;
            }
            if (txReport.ackRSSI != void 0 && !(0, import_core.isRssiError)(txReport.ackRSSI)) {
              if (txReport.measuredNoiseFloor != void 0 && !(0, import_core.isRssiError)(txReport.measuredNoiseFloor)) {
                const currentSNRMargin = txReport.ackRSSI - txReport.measuredNoiseFloor;
                if (snrMargin == void 0 || currentSNRMargin < snrMargin) {
                  snrMargin = currentSNRMargin;
                }
              }
              if (rssi == void 0 || txReport.ackRSSI < rssi) {
                rssi = txReport.ackRSSI;
                channel = txReport.ackChannelNo;
              }
            }
          }
        }
        if (snrMargin == void 0 && rssi != void 0 && rssi < import_core.RssiError.NoSignalDetected && channel != void 0) {
          const backgroundRSSI = await this.driver.controller.getBackgroundRSSI();
          if (`rssiChannel${channel}` in backgroundRSSI) {
            const bgRSSI = backgroundRSSI[`rssiChannel${channel}`];
            if ((0, import_core.isRssiError)(bgRSSI)) {
              if (bgRSSI === import_core.RssiError.ReceiverSaturated) {
                snrMargin = 0;
              } else if (bgRSSI === import_core.RssiError.NoSignalDetected) {
                snrMargin = rssi + 128;
              } else {
                snrMargin = void 0;
              }
            } else {
              snrMargin = rssi - bgRSSI;
            }
          }
        }
        const ret = {
          latency,
          failedPingsNode,
          numNeighbors,
          routeChanges,
          snrMargin,
          rating: 0
        };
        if (this.supportsCC(import_core.CommandClasses.Powerlevel)) {
          let failedPingsController = 0;
          const executor = /* @__PURE__ */ __name(async (powerlevel) => {
            if (this._healthCheckAborted)
              return void 0;
            this.driver.controllerLog.logNode(this.id, `Sending ${import_HealthCheck.healthCheckTestFrameCount} pings to controller at ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, powerlevel)}...`);
            const result = await this.testPowerlevel(this.driver.controller.ownNodeId, powerlevel, import_HealthCheck.healthCheckTestFrameCount);
            failedPingsController = import_HealthCheck.healthCheckTestFrameCount - result;
            this.driver.controllerLog.logNode(this.id, `At ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, powerlevel)}, ${result}/${import_HealthCheck.healthCheckTestFrameCount} pings were acknowledged...`);
            await (0, import_async.wait)(1e3);
            return failedPingsController === 0;
          }, "executor");
          try {
            const powerlevel = await (0, import_shared.discreteLinearSearch)(
              import_cc.Powerlevel["Normal Power"],
              // minimum reduction
              import_cc.Powerlevel["-9 dBm"],
              // maximum reduction
              executor
            );
            if (this._healthCheckAborted)
              return aborted();
            if (powerlevel == void 0) {
              ret.minPowerlevel = import_cc.Powerlevel["Normal Power"];
              ret.failedPingsController = failedPingsController;
            } else {
              ret.minPowerlevel = powerlevel;
            }
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              ret.minPowerlevel = import_cc.Powerlevel["Normal Power"];
              ret.failedPingsController = import_HealthCheck.healthCheckTestFrameCount;
            } else {
              throw e;
            }
          }
        }
        ret.rating = computeRating(ret);
        results.push(ret);
        onProgress?.(round, rounds, ret.rating, { ...ret });
      }
      const duration = Date.now() - start;
      const rating = Math.min(...results.map((r) => r.rating));
      const summary = { results, rating };
      this.driver.controllerLog.logNode(this.id, `Lifeline health check complete in ${duration} ms
${(0, import_HealthCheck.formatLifelineHealthCheckSummary)(summary)}`);
      return summary;
    }
    /**
     * Checks the health of connection between this node and the target node and returns the results.
     */
    async checkRouteHealth(targetNodeId, rounds = 5, onProgress) {
      if (this._healthCheckInProgress) {
        throw new import_core.ZWaveError("A health check is already in progress for this node!", import_core.ZWaveErrorCodes.HealthCheck_Busy);
      }
      if (rounds > 10 || rounds < 1) {
        throw new import_core.ZWaveError("The number of health check rounds must be between 1 and 10!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      try {
        this._healthCheckInProgress = true;
        this._healthCheckAborted = false;
        this._abortHealthCheckPromise = (0, import_deferred_promise.createDeferredPromise)();
        return await this.checkRouteHealthInternal(targetNodeId, rounds, onProgress);
      } finally {
        this._healthCheckInProgress = false;
        this._healthCheckAborted = false;
        this._abortHealthCheckPromise = void 0;
      }
    }
    async checkRouteHealthInternal(targetNodeId, rounds, onProgress) {
      const otherNode = this.driver.controller.nodes.getOrThrow(targetNodeId);
      if (this.protocol === import_core.Protocols.ZWaveLongRange) {
        throw new import_core.ZWaveError(`Cannot perform route health check for Long Range node ${this.id}.`, import_core.ZWaveErrorCodes.Controller_NotSupportedForLongRange);
      } else if (otherNode.protocol === import_core.Protocols.ZWaveLongRange) {
        throw new import_core.ZWaveError(`Cannot perform route health check for Long Range node ${otherNode.id}.`, import_core.ZWaveErrorCodes.Controller_NotSupportedForLongRange);
      }
      if (otherNode.canSleep) {
        throw new import_core.ZWaveError("Nodes which can sleep are not a valid target for a route health check!", import_core.ZWaveErrorCodes.CC_NotSupported);
      } else if (this.canSleep && !this.supportsCC(import_core.CommandClasses.Powerlevel)) {
        throw new import_core.ZWaveError("For a route health check, nodes which can sleep must support Powerlevel CC!", import_core.ZWaveErrorCodes.CC_NotSupported);
      } else if (!this.supportsCC(import_core.CommandClasses.Powerlevel) && !otherNode.supportsCC(import_core.CommandClasses.Powerlevel)) {
        throw new import_core.ZWaveError("For a route health check, at least one of the nodes must support Powerlevel CC!", import_core.ZWaveErrorCodes.CC_NotSupported);
      }
      const healthCheckTestFrameCount2 = 10;
      const start = Date.now();
      const computeRating = /* @__PURE__ */ __name((result) => {
        const failedPings = Math.max(result.failedPingsToSource ?? 0, result.failedPingsToTarget ?? 0);
        const numNeighbors = result.numNeighbors;
        const minPowerlevel = Math.max(result.minPowerlevelSource ?? import_cc.Powerlevel["-6 dBm"], result.minPowerlevelTarget ?? import_cc.Powerlevel["-6 dBm"]);
        if (failedPings === 10)
          return 0;
        if (failedPings > 2)
          return 1;
        if (failedPings === 2)
          return 2;
        if (failedPings === 1)
          return 3;
        if (minPowerlevel < import_cc.Powerlevel["-6 dBm"]) {
          return numNeighbors > 2 ? 7 : 6;
        }
        if (numNeighbors <= 2)
          return 8;
        return 10;
      }, "computeRating");
      this.driver.controllerLog.logNode(this.id, `Starting route health check to node ${targetNodeId} (${rounds} round${rounds !== 1 ? "s" : ""})...`);
      const results = [];
      const aborted = /* @__PURE__ */ __name(() => {
        this.driver.controllerLog.logNode(this.id, `Route health check to node ${targetNodeId} aborted`);
        if (results.length === 0) {
          return {
            rating: 0,
            results: []
          };
        } else {
          return {
            rating: Math.min(...results.map((r) => r.rating)),
            results
          };
        }
      }, "aborted");
      if (this.canSleep && this.status !== import_Types.NodeStatus.Awake) {
        this.driver.controllerLog.logNode(this.id, `waiting for node to wake up...`);
        await Promise.race([
          this.waitForWakeup(),
          this._abortHealthCheckPromise
        ]);
        if (this._healthCheckAborted)
          return aborted();
      }
      for (let round = 1; round <= rounds; round++) {
        if (this._healthCheckAborted)
          return aborted();
        const numNeighbors = Math.min((await this.driver.controller.getNodeNeighbors(this.id, true)).length, (await this.driver.controller.getNodeNeighbors(targetNodeId, true)).length);
        let failedPings = 0;
        let failedPingsToSource;
        let minPowerlevelSource;
        let failedPingsToTarget;
        let minPowerlevelTarget;
        const executor = /* @__PURE__ */ __name((node, otherNode2) => async (powerlevel) => {
          if (this._healthCheckAborted)
            return void 0;
          this.driver.controllerLog.logNode(node.id, `Sending ${healthCheckTestFrameCount2} pings to node ${otherNode2.id} at ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, powerlevel)}...`);
          const result = await node.testPowerlevel(otherNode2.id, powerlevel, healthCheckTestFrameCount2);
          failedPings = healthCheckTestFrameCount2 - result;
          this.driver.controllerLog.logNode(node.id, `At ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, powerlevel)}, ${result}/${healthCheckTestFrameCount2} pings were acknowledged by node ${otherNode2.id}...`);
          await (0, import_async.wait)(1e3);
          return failedPings === 0;
        }, "executor");
        if (this.supportsCC(import_core.CommandClasses.Powerlevel)) {
          try {
            const powerlevel = await (0, import_shared.discreteLinearSearch)(
              import_cc.Powerlevel["Normal Power"],
              // minimum reduction
              import_cc.Powerlevel["-9 dBm"],
              // maximum reduction
              executor(this, otherNode)
            );
            if (this._healthCheckAborted)
              return aborted();
            if (powerlevel == void 0) {
              minPowerlevelSource = import_cc.Powerlevel["Normal Power"];
              failedPingsToTarget = failedPings;
            } else {
              minPowerlevelSource = powerlevel;
              failedPingsToTarget = 0;
            }
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              minPowerlevelSource = import_cc.Powerlevel["Normal Power"];
              failedPingsToTarget = healthCheckTestFrameCount2;
            } else {
              throw e;
            }
          }
        }
        if (this._healthCheckAborted)
          return aborted();
        if (!this.canSleep && otherNode.supportsCC(import_core.CommandClasses.Powerlevel)) {
          try {
            const powerlevel = await (0, import_shared.discreteLinearSearch)(
              import_cc.Powerlevel["Normal Power"],
              // minimum reduction
              import_cc.Powerlevel["-9 dBm"],
              // maximum reduction
              executor(otherNode, this)
            );
            if (powerlevel == void 0) {
              minPowerlevelTarget = import_cc.Powerlevel["Normal Power"];
              failedPingsToSource = failedPings;
            } else {
              minPowerlevelTarget = powerlevel;
              failedPingsToSource = 0;
            }
          } catch (e) {
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              minPowerlevelTarget = import_cc.Powerlevel["Normal Power"];
              failedPingsToSource = healthCheckTestFrameCount2;
            } else {
              throw e;
            }
          }
        }
        const ret = {
          numNeighbors,
          failedPingsToSource,
          failedPingsToTarget,
          minPowerlevelSource,
          minPowerlevelTarget,
          rating: 0
        };
        ret.rating = computeRating(ret);
        results.push(ret);
        onProgress?.(round, rounds, ret.rating, { ...ret });
      }
      const duration = Date.now() - start;
      const rating = Math.min(...results.map((r) => r.rating));
      const summary = { results, rating };
      this.driver.controllerLog.logNode(this.id, `Route health check to node ${otherNode.id} complete in ${duration} ms
${(0, import_HealthCheck.formatRouteHealthCheckSummary)(this.id, otherNode.id, summary)}`);
      return summary;
    }
    _linkReliabilityCheckInProgress = false;
    /**
     * Returns whether a link reliability check is currently in progress for this node
     */
    isLinkReliabilityCheckInProgress() {
      return this._linkReliabilityCheckInProgress;
    }
    _linkReliabilityCheckAborted = false;
    _abortLinkReliabilityCheckPromise;
    /**
     * Aborts an ongoing link reliability check if one is currently in progress.
     *
     * **Note:** The link reliability check may take a few seconds to actually be aborted.
     * When it is, the promise returned by {@link checkLinkReliability} will be resolved with the results obtained so far.
     */
    abortLinkReliabilityCheck() {
      if (!this._linkReliabilityCheckInProgress)
        return;
      this._linkReliabilityCheckAborted = true;
      this._abortLinkReliabilityCheckPromise?.resolve();
    }
    /**
     * Tests the reliability of the link between the controller and this node and returns the results.
     */
    async checkLinkReliability(options) {
      if (this._linkReliabilityCheckInProgress) {
        throw new import_core.ZWaveError("A link reliability check is already in progress for this node!", import_core.ZWaveErrorCodes.LinkReliabilityCheck_Busy);
      }
      if (typeof options.rounds === "number" && options.rounds < 1) {
        throw new import_core.ZWaveError("The number of rounds must be at least 1!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      try {
        this._linkReliabilityCheckInProgress = true;
        this._linkReliabilityCheckAborted = false;
        this._abortLinkReliabilityCheckPromise = (0, import_deferred_promise.createDeferredPromise)();
        switch (options.mode) {
          case import_Types.LinkReliabilityCheckMode.BasicSetOnOff:
            return await this.checkLinkReliabilityBasicSetOnOff(options);
        }
      } finally {
        this._linkReliabilityCheckInProgress = false;
        this._linkReliabilityCheckAborted = false;
        this._abortLinkReliabilityCheckPromise = void 0;
      }
    }
    async checkLinkReliabilityBasicSetOnOff(options) {
      this.driver.controllerLog.logNode(this.id, `Starting link reliability check (Basic Set On/Off) with ${options.rounds} round${options.rounds !== 1 ? "s" : ""}...`);
      const useSupervision = this.supportsCC(import_core.CommandClasses.Supervision);
      const result = {
        rounds: 0,
        commandsSent: 0,
        commandErrors: 0,
        missingResponses: useSupervision ? 0 : void 0,
        latency: {
          min: Number.POSITIVE_INFINITY,
          max: 0,
          average: 0
        },
        rtt: {
          min: Number.POSITIVE_INFINITY,
          max: 0,
          average: 0
        },
        ackRSSI: {
          min: 0,
          max: Number.NEGATIVE_INFINITY,
          average: Number.NEGATIVE_INFINITY
        },
        responseRSSI: useSupervision ? {
          min: 0,
          max: Number.NEGATIVE_INFINITY,
          average: Number.NEGATIVE_INFINITY
        } : void 0
      };
      const aborted = /* @__PURE__ */ __name(() => {
        this.driver.controllerLog.logNode(this.id, `Link reliability check aborted`);
        return result;
      }, "aborted");
      let lastProgressReport = 0;
      const reportProgress = /* @__PURE__ */ __name(() => {
        if (Date.now() - lastProgressReport >= 250) {
          options.onProgress?.((0, import_shared.cloneDeep)(result));
          lastProgressReport = Date.now();
        }
      }, "reportProgress");
      if (this.canSleep && this.status !== import_Types.NodeStatus.Awake) {
        this.driver.controllerLog.logNode(this.id, `waiting for node to wake up...`);
        await Promise.race([
          this.waitForWakeup(),
          this._abortLinkReliabilityCheckPromise
        ]);
        if (this._linkReliabilityCheckAborted)
          return aborted();
      }
      let txReport;
      const basicSetAPI = this.commandClasses.Basic.withOptions({
        // Don't change the node status when the ACK is missing. We're likely testing the limits here.
        changeNodeStatusOnMissingACK: false,
        // Avoid using explorer frames, because they can create a ton of delay
        transmitOptions: import_core.TransmitOptions.ACK | import_core.TransmitOptions.AutoRoute,
        // Do not wait for SOS NonceReports, as it slows down the test
        s2VerifyDelivery: false,
        // And remember the transmit report, so we can evaluate it
        onTXReport: /* @__PURE__ */ __name((report) => {
          txReport = report;
        }, "onTXReport")
      });
      let lastStart;
      for (let round = 1; round <= (options.rounds ?? Number.POSITIVE_INFINITY); round++) {
        if (this._linkReliabilityCheckAborted)
          return aborted();
        result.rounds = round;
        lastStart = Date.now();
        txReport = void 0;
        try {
          await basicSetAPI.set(round % 2 === 1 ? 255 : 0);
          result.commandsSent++;
          const rtt = Date.now() - lastStart;
          result.rtt.min = Math.min(result.rtt.min, rtt);
          result.rtt.max = Math.max(result.rtt.max, rtt);
          result.rtt.average += (rtt - result.rtt.average) / round;
          if (txReport) {
            const latency = txReport.txTicks * 10;
            if (result.latency) {
              result.latency.min = Math.min(result.latency.min, latency);
              result.latency.max = Math.max(result.latency.max, latency);
              result.latency.average += (latency - result.latency.average) / round;
            } else {
              result.latency = {
                min: latency,
                max: latency,
                average: latency
              };
            }
          }
        } catch (e) {
          if ((0, import_core.isZWaveError)(e)) {
            if (e.code === import_core.ZWaveErrorCodes.Controller_ResponseNOK || e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              result.commandErrors++;
            } else if (e.code === import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
              result.missingResponses ??= 0;
              result.missingResponses++;
            }
          }
        }
        if (txReport?.ackRSSI != void 0 && !(0, import_core.isRssiError)(txReport.ackRSSI)) {
          result.ackRSSI.min = Math.min(result.ackRSSI.min, txReport.ackRSSI);
          result.ackRSSI.max = Math.max(result.ackRSSI.max, txReport.ackRSSI);
          if (Number.isFinite(result.ackRSSI.average)) {
            result.ackRSSI.average += (txReport.ackRSSI - result.ackRSSI.average) / round;
          } else {
            result.ackRSSI.average = txReport.ackRSSI;
          }
        }
        reportProgress();
        const waitDurationMs = Math.max(0, options.interval - (Date.now() - lastStart));
        await Promise.race([
          (0, import_async.wait)(waitDurationMs, true),
          this._abortLinkReliabilityCheckPromise
        ]);
      }
      return result;
    }
    /**
     * Updates the average RTT of this node
     * @internal
     */
    updateRTT(sentMessage) {
      if (sentMessage.rtt) {
        const rttMs = sentMessage.rtt / 1e6;
        this.updateStatistics((current) => ({
          ...current,
          rtt: current.rtt != void 0 ? (0, import_math.roundTo)(current.rtt * 0.75 + rttMs * 0.25, 1) : (0, import_math.roundTo)(rttMs, 1)
        }));
      }
    }
    /**
     * Updates route/transmission statistics for this node
     * @internal
     */
    updateRouteStatistics(txReport) {
      this.updateStatistics((current) => {
        const ret = { ...current };
        if (txReport.ackRSSI != void 0 && txReport.ackRSSI !== import_core.RssiError.NotAvailable) {
          ret.rssi = ret.rssi == void 0 || (0, import_core.isRssiError)(txReport.ackRSSI) ? txReport.ackRSSI : Math.round(ret.rssi * 0.75 + txReport.ackRSSI * 0.25);
        }
        const newStats = {
          protocolDataRate: txReport.routeSpeed,
          repeaters: txReport.repeaterNodeIds ?? [],
          rssi: txReport.ackRSSI ?? ret.lwr?.rssi
        };
        if (txReport.ackRepeaterRSSI != void 0) {
          newStats.repeaterRSSI = txReport.ackRepeaterRSSI;
        }
        if (txReport.failedRouteLastFunctionalNodeId && txReport.failedRouteFirstNonFunctionalNodeId) {
          newStats.routeFailedBetween = [
            txReport.failedRouteLastFunctionalNodeId,
            txReport.failedRouteFirstNonFunctionalNodeId
          ];
        }
        if (ret.lwr && !(0, import_NodeStatistics.routeStatisticsEquals)(ret.lwr, newStats)) {
          ret.nlwr = ret.lwr;
        }
        ret.lwr = newStats;
        return ret;
      });
    }
    /**
     * Sets the current date, time and timezone (or a subset of those) on the node using one or more of the respective CCs.
     * Returns whether the operation was successful.
     */
    async setDateAndTime(now = /* @__PURE__ */ new Date()) {
      const timeParametersAPI = this.commandClasses["Time Parameters"];
      const timeAPI = this.commandClasses.Time;
      const clockAPI = this.commandClasses.Clock;
      const scheduleEntryLockAPI = this.commandClasses["Schedule Entry Lock"];
      if (timeParametersAPI.isSupported() && timeParametersAPI.supportsCommand(import_cc.TimeParametersCommand.Set)) {
        try {
          const result = await timeParametersAPI.set(now);
          if ((0, import_core.supervisedCommandFailed)(result))
            return false;
        } catch {
          return false;
        }
      } else if (clockAPI.isSupported() && clockAPI.supportsCommand(import_cc.ClockCommand.Set)) {
        try {
          const hours = now.getHours();
          const minutes = now.getMinutes();
          let weekday = now.getDay();
          if (weekday === 0)
            weekday = 7;
          const result = await clockAPI.set(hours, minutes, weekday);
          if ((0, import_core.supervisedCommandFailed)(result))
            return false;
        } catch {
          return false;
        }
      } else if (timeAPI.isSupported() && timeAPI.supportsCommand(import_cc.TimeCommand.DateReport) && timeAPI.supportsCommand(import_cc.TimeCommand.TimeReport)) {
        const api = timeAPI.withOptions({
          useSupervision: false
        });
        try {
          const year = now.getFullYear();
          const month = now.getMonth() + 1;
          const day = now.getDate();
          await api.reportDate(year, month, day);
          const verification = await api.getDate();
          if (!verification || verification.year !== year || verification.month !== month || verification.day !== day) {
            return false;
          }
        } catch {
          return false;
        }
        try {
          const hour = now.getHours();
          const minute = now.getMinutes();
          const second = now.getSeconds();
          await api.reportTime(hour, minute, second);
          const verification = await api.getTime();
          if (!verification)
            return false;
          const secondsPerDay = 24 * 60 * 60;
          const expected = hour * 60 * 60 + minute * 60 + second;
          const expectedMin = expected - 30;
          const expectedMax = expected + 30;
          const actual = verification.hour * 60 * 60 + verification.minute * 60 + verification.second;
          if (actual >= expectedMin && actual <= expectedMax) {
          } else if (actual + secondsPerDay >= expectedMin && actual + secondsPerDay <= expectedMax) {
          } else {
            return false;
          }
        } catch {
          return false;
        }
      }
      const timezone = (0, import_core.getDSTInfo)(now);
      if (timeAPI.isSupported() && timeAPI.supportsCommand(import_cc.TimeCommand.TimeOffsetSet)) {
        try {
          const result = await timeAPI.setTimezone(timezone);
          if ((0, import_core.supervisedCommandFailed)(result))
            return false;
        } catch {
          return false;
        }
      } else if (scheduleEntryLockAPI.isSupported() && scheduleEntryLockAPI.supportsCommand(import_cc.ScheduleEntryLockCommand.TimeOffsetSet)) {
        try {
          const result = await scheduleEntryLockAPI.setTimezone(timezone);
          if ((0, import_core.supervisedCommandFailed)(result))
            return false;
        } catch {
          return false;
        }
      }
      return true;
    }
    /**
     * Returns the current date, time and timezone (or a subset of those) on the node using one or more of the respective CCs.
     */
    async getDateAndTime() {
      const timeParametersAPI = this.commandClasses["Time Parameters"];
      const timeAPI = this.commandClasses.Time;
      const clockAPI = this.commandClasses.Clock;
      const scheduleEntryLockAPI = this.commandClasses["Schedule Entry Lock"];
      const response = {};
      if (timeParametersAPI.isSupported() && timeParametersAPI.supportsCommand(import_cc.TimeParametersCommand.Get)) {
        try {
          const result = await timeParametersAPI.get();
          if (result) {
            Object.assign(response, {
              hour: result.getUTCHours(),
              minute: result.getUTCMinutes(),
              second: result.getUTCSeconds(),
              standardOffset: 0,
              dstOffset: 0,
              weekday: result.getUTCDay(),
              day: result.getUTCDate(),
              month: result.getUTCMonth() + 1,
              year: result.getUTCFullYear()
            });
          }
          return response;
        } catch {
        }
      }
      if (clockAPI.isSupported() && clockAPI.supportsCommand(import_cc.ClockCommand.Get)) {
        try {
          const result = await clockAPI.get();
          if (result) {
            Object.assign(response, {
              hour: result.hour,
              minute: result.minute,
              weekday: result.weekday
            });
          }
        } catch {
        }
      }
      if (timeAPI.isSupported() && timeAPI.supportsCommand(import_cc.TimeCommand.TimeGet)) {
        try {
          const result = await timeAPI.getTime();
          if (result) {
            Object.assign(response, {
              hour: result.hour,
              minute: result.minute,
              second: result.second
            });
          }
        } catch {
        }
      }
      if (timeAPI.isSupported() && timeAPI.supportsCommand(import_cc.TimeCommand.DateGet)) {
        try {
          const result = await timeAPI.getDate();
          if (result) {
            Object.assign(response, {
              day: result.day,
              month: result.month,
              year: result.year
            });
          }
        } catch {
        }
      }
      if (timeAPI.isSupported() && timeAPI.supportsCommand(import_cc.TimeCommand.TimeOffsetGet)) {
        try {
          const result = await timeAPI.getTimezone();
          if (result) {
            Object.assign(response, {
              standardOffset: result.standardOffset,
              dstOffset: result.dstOffset
            });
          }
        } catch {
        }
      }
      if (scheduleEntryLockAPI.isSupported() && scheduleEntryLockAPI.supportsCommand(import_cc.ScheduleEntryLockCommand.TimeOffsetGet)) {
        try {
          const result = await scheduleEntryLockAPI.getTimezone();
          if (result) {
            Object.assign(response, {
              standardOffset: result.standardOffset,
              dstOffset: result.dstOffset
            });
          }
        } catch {
        }
      }
      return response;
    }
    async sendResetLocallyNotification() {
      const api = this.createAPI(import_core.CommandClasses["Device Reset Locally"], false);
      await api.sendNotification();
    }
    /** Returns a dump of this node's information for debugging purposes */
    createDump() {
      const { index, ...endpointDump } = this.createEndpointDump();
      const ret = {
        id: this.id,
        manufacturer: this.deviceConfig?.manufacturer,
        label: this.label,
        description: this.deviceConfig?.description,
        fingerprint: {
          manufacturerId: this.manufacturerId != void 0 ? (0, import_shared.formatId)(this.manufacturerId) : "unknown",
          productType: this.productType != void 0 ? (0, import_shared.formatId)(this.productType) : "unknown",
          productId: this.productId != void 0 ? (0, import_shared.formatId)(this.productId) : "unknown",
          firmwareVersion: this.firmwareVersion ?? "unknown"
        },
        interviewStage: (0, import_shared.getEnumMemberName)(import_Types.InterviewStage, this.interviewStage),
        ready: this.ready,
        dsk: this.dsk ? (0, import_core.dskToString)(this.dsk) : void 0,
        securityClasses: {},
        isListening: this.isListening ?? "unknown",
        isFrequentListening: this.isFrequentListening ?? "unknown",
        isRouting: this.isRouting ?? "unknown",
        supportsBeaming: this.supportsBeaming ?? "unknown",
        supportsSecurity: this.supportsSecurity ?? "unknown",
        protocol: (0, import_shared.getEnumMemberName)(import_core.Protocols, this.protocol),
        supportedProtocols: this.driver.controller.getProvisioningEntry(this.id)?.supportedProtocols?.map((p) => (0, import_shared.getEnumMemberName)(import_core.Protocols, p)),
        protocolVersion: this.protocolVersion != void 0 ? (0, import_shared.getEnumMemberName)(import_core.ProtocolVersion, this.protocolVersion) : "unknown",
        sdkVersion: this.sdkVersion ?? "unknown",
        supportedDataRates: this.supportedDataRates ? [...this.supportedDataRates] : "unknown",
        ...endpointDump
      };
      if (this.hardwareVersion != void 0) {
        ret.fingerprint.hardwareVersion = this.hardwareVersion;
      }
      for (const secClass of import_core.securityClassOrder) {
        if (this.protocol === import_core.Protocols.ZWaveLongRange && !(0, import_core.securityClassIsLongRange)(secClass)) {
          continue;
        }
        ret.securityClasses[(0, import_shared.getEnumMemberName)(import_core.SecurityClass, secClass)] = this.hasSecurityClass(secClass) ?? "unknown";
      }
      const allValueIds = nodeUtils.getDefinedValueIDsInternal(this.driver, this, true);
      const collectValues = /* @__PURE__ */ __name((endpointIndex, getCollection) => {
        for (const valueId of allValueIds) {
          if ((valueId.endpoint ?? 0) !== endpointIndex)
            continue;
          const value = this._valueDB.getValue(valueId);
          const metadata = this._valueDB.getMetadata(valueId);
          const timestamp = this._valueDB.getTimestamp(valueId);
          const timestampAsDate = timestamp ? new Date(timestamp).toISOString() : void 0;
          const ccInstance = import_cc.CommandClass.createInstanceUnchecked(this, valueId.commandClass);
          const isInternalValue = ccInstance?.isInternalValue(valueId);
          const valueDump = {
            ...(0, import_shared.pick)(valueId, [
              "property",
              "propertyKey"
            ]),
            metadata,
            value: metadata?.secret ? "(redacted)" : (0, import_core.serializeCacheValue)(value),
            timestamp: timestampAsDate
          };
          if (isInternalValue)
            valueDump.internal = true;
          for (const [prop, value2] of Object.entries(valueDump)) {
            if (value2 === void 0)
              delete valueDump[prop];
          }
          getCollection(valueId.commandClass)?.push(valueDump);
        }
      }, "collectValues");
      collectValues(0, (ccId) => ret.commandClasses[(0, import_core.getCCName)(ccId)]?.values);
      for (const endpoint of this.getAllEndpoints()) {
        if (endpoint.index === 0)
          continue;
        ret.endpoints ??= {};
        const endpointDump2 = endpoint.createEndpointDump();
        collectValues(endpoint.index, (ccId) => endpointDump2.commandClasses[(0, import_core.getCCName)(ccId)]?.values);
        ret.endpoints[endpoint.index] = endpointDump2;
      }
      if (this.deviceConfig) {
        const relativePath = import_pathe.default.relative(import_config.embeddedDevicesDir, this.deviceConfig.filename);
        if (relativePath.startsWith("..")) {
          ret.configFileName = this.deviceConfig.filename;
        } else {
          ret.configFileName = relativePath;
        }
        if (this.deviceConfig.compat) {
          ret.compatFlags = this.deviceConfig.compat;
        }
      }
      for (const [prop, value] of Object.entries(ret)) {
        if (value === void 0)
          delete ret[prop];
      }
      return ret;
    }
    _emit(event, ...args) {
      return this.emit(event, ...args);
    }
    _on(event, callback) {
      return this.on(event, callback);
    }
    _once(event, callback) {
      return this.once(event, callback);
    }
  };
  return ZWaveNode2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZWaveNode
});
//# sourceMappingURL=Node.js.map
