"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Endpoints_exports = {};
__export(Endpoints_exports, {
  EndpointsMixin: () => EndpointsMixin
});
module.exports = __toCommonJS(Endpoints_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_DeviceClass = require("../DeviceClass.js");
var import_Endpoint = require("../Endpoint.js");
var nodeUtils = __toESM(require("../utils.js"), 1);
var import_CapabilityValues = require("./41_CapabilityValues.js");
class EndpointsMixin extends import_CapabilityValues.NodeCapabilityValuesMixin {
  static {
    __name(this, "EndpointsMixin");
  }
  get endpointCountIsDynamic() {
    return nodeUtils.endpointCountIsDynamic(this.driver, this.id);
  }
  get endpointsHaveIdenticalCapabilities() {
    return nodeUtils.endpointsHaveIdenticalCapabilities(this.driver, this.id);
  }
  get individualEndpointCount() {
    return nodeUtils.getIndividualEndpointCount(this.driver, this.id);
  }
  get aggregatedEndpointCount() {
    return nodeUtils.getAggregatedEndpointCount(this.driver, this.id);
  }
  /** Returns the device class of an endpoint. Falls back to the node's device class if the information is not known. */
  getEndpointDeviceClass(index) {
    const deviceClass = this.getValue(import_cc.MultiChannelCCValues.endpointDeviceClass.endpoint(this.endpointsHaveIdenticalCapabilities ? 1 : index));
    if (deviceClass && this.deviceClass) {
      return new import_DeviceClass.DeviceClass(this.deviceClass.basic, deviceClass.generic, deviceClass.specific);
    }
    return this.deviceClass;
  }
  getEndpointCCs(index) {
    const ret = this.getValue(import_cc.MultiChannelCCValues.endpointCCs.endpoint(this.endpointsHaveIdenticalCapabilities ? 1 : index));
    if ((0, import_typeguards.isArray)(ret)) {
      return ret;
    } else if ((0, import_typeguards.isObject)(ret) && "supportedCCs" in ret) {
      return ret.supportedCCs;
    }
  }
  /**
   * Returns the current endpoint count of this node.
   *
   * If you want to enumerate the existing endpoints, use `getEndpointIndizes` instead.
   * Some devices are known to contradict themselves.
   */
  getEndpointCount() {
    return nodeUtils.getEndpointCount(this.driver, this.id);
  }
  /**
   * Returns indizes of all endpoints on the node.
   */
  getEndpointIndizes() {
    return nodeUtils.getEndpointIndizes(this.driver, this.id);
  }
  /** Whether the Multi Channel CC has been interviewed and all endpoint information is known */
  get isMultiChannelInterviewComplete() {
    return nodeUtils.isMultiChannelInterviewComplete(this.driver, this.id);
  }
  /** Cache for this node's endpoint instances */
  _endpointInstances = /* @__PURE__ */ new Map();
  getEndpoint(index) {
    if (index < 0) {
      throw new import_core.ZWaveError("The endpoint index must be positive!", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    if (!index)
      return this;
    if (!this.isMultiChannelInterviewComplete) {
      this.driver.driverLog.print(`Node ${this.id}, Endpoint ${index}: Trying to access endpoint instance before Multi Channel interview`, "error");
      return void 0;
    }
    if (!this.getEndpointIndizes().includes(index))
      return void 0;
    if (!this._endpointInstances.has(index)) {
      this._endpointInstances.set(index, new import_Endpoint.Endpoint(this.id, this.driver, index, this.getEndpointDeviceClass(index), this.getEndpointCCs(index)));
    }
    return this._endpointInstances.get(index);
  }
  getEndpointOrThrow(index) {
    const ret = this.getEndpoint(index);
    if (!ret) {
      throw new import_core.ZWaveError(`Endpoint ${index} does not exist on Node ${this.id}`, import_core.ZWaveErrorCodes.Controller_EndpointNotFound);
    }
    return ret;
  }
  /** Returns a list of all endpoints of this node, including the root endpoint (index 0) */
  getAllEndpoints() {
    return nodeUtils.getAllEndpoints(this.driver, this);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EndpointsMixin
});
//# sourceMappingURL=50_Endpoints.js.map
