"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Indicator_exports = {};
__export(Indicator_exports, {
  IndicatorCCBehaviors: () => IndicatorCCBehaviors
});
module.exports = __toCommonJS(Indicator_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  indicators: {}
};
const respondToIndicatorGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.IndicatorCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Indicator, receivedCC.endpointIndex)
      };
      let cc;
      if (receivedCC.indicatorId) {
        const indicatorId = receivedCC.indicatorId ?? 0;
        const supportedProperties = capabilities.indicators[indicatorId]?.properties ?? [];
        const indicatorObjects = supportedProperties.map((propertyId) => {
          const value = capabilities.getValue?.(indicatorId, propertyId) ?? 0;
          return {
            indicatorId,
            propertyId,
            value
          };
        });
        cc = new import_cc.IndicatorCCReport({
          nodeId: controller.ownNodeId,
          values: indicatorObjects
        });
      } else {
        const value = capabilities.getValue?.(0, 0) ?? 0;
        cc = new import_cc.IndicatorCCReport({
          nodeId: controller.ownNodeId,
          value
        });
      }
      return { action: "sendCC", cc };
    }
  }
};
const respondToIndicatorSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.IndicatorCCSupportedGet) {
      let createReport2 = function(indicatorId) {
        const supportedProperties = capabilities.indicators[indicatorId]?.properties ?? [];
        const allSupportedIndicators = Object.keys(capabilities.indicators).map((id) => parseInt(id, 10)).filter((id) => !isNaN(id));
        const indicatorIndex = allSupportedIndicators.indexOf(indicatorId);
        const nextIndicatorId = allSupportedIndicators[indicatorIndex + 1];
        return new import_cc.IndicatorCCSupportedReport({
          nodeId: controller.ownNodeId,
          indicatorId,
          nextIndicatorId: nextIndicatorId ?? 0,
          supportedProperties
        });
      };
      var createReport = createReport2;
      __name(createReport2, "createReport");
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Indicator, receivedCC.endpointIndex)
      };
      let cc;
      if (receivedCC.indicatorId === 0) {
        const firstIndicatorId = Object.keys(capabilities.indicators).map((id) => parseInt(id, 10)).find((id) => !isNaN(id)) ?? 0;
        cc = createReport2(firstIndicatorId);
      } else {
        cc = createReport2(receivedCC.indicatorId);
      }
      return { action: "sendCC", cc };
    }
  }
};
const respondToIndicatorDescriptionGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.IndicatorCCDescriptionGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Indicator, receivedCC.endpointIndex)
      };
      const indicatorInfo = capabilities.indicators[receivedCC.indicatorId];
      let cc;
      if (!indicatorInfo || receivedCC.indicatorId < 128 || receivedCC.indicatorId > 159) {
        cc = new import_cc.IndicatorCCDescriptionReport({
          nodeId: controller.ownNodeId,
          indicatorId: receivedCC.indicatorId,
          description: ""
        });
      } else {
        cc = new import_cc.IndicatorCCDescriptionReport({
          nodeId: controller.ownNodeId,
          indicatorId: receivedCC.indicatorId,
          description: indicatorInfo.manufacturerSpecificDescription ?? ""
        });
      }
      return { action: "sendCC", cc };
    }
  }
};
const IndicatorCCBehaviors = [
  respondToIndicatorGet,
  // respondToIndicatorSet,
  respondToIndicatorSupportedGet,
  respondToIndicatorDescriptionGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  IndicatorCCBehaviors
});
//# sourceMappingURL=Indicator.js.map
