"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SoundSwitch_exports = {};
__export(SoundSwitch_exports, {
  SoundSwitchCCBehaviors: () => SoundSwitchCCBehaviors
});
module.exports = __toCommonJS(SoundSwitch_exports);
var import_SoundSwitchCC = require("@zwave-js/cc/SoundSwitchCC");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_testing = require("@zwave-js/testing");
const defaultCapabilities = {
  defaultToneId: 1,
  defaultVolume: 0,
  tones: []
};
const STATE_KEY_PREFIX = "SoundSwitch_";
const StateKeys = {
  defaultToneId: `${STATE_KEY_PREFIX}defaultToneId`,
  defaultVolume: `${STATE_KEY_PREFIX}defaultVolume`,
  state: `${STATE_KEY_PREFIX}state`,
  lastNonZeroVolume: `${STATE_KEY_PREFIX}lastNonZeroVolume`
};
const respondToSoundSwitchConfigurationGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_SoundSwitchCC.SoundSwitchCCConfigurationGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Sound Switch"], receivedCC.endpointIndex)
      };
      const cc = new import_SoundSwitchCC.SoundSwitchCCConfigurationReport({
        nodeId: controller.ownNodeId,
        defaultToneId: self.state.get(StateKeys.defaultToneId) ?? capabilities.defaultToneId,
        defaultVolume: self.state.get(StateKeys.defaultVolume) ?? capabilities.defaultVolume
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToSoundSwitchConfigurationSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_SoundSwitchCC.SoundSwitchCCConfigurationSet) {
      self.state.set(StateKeys.defaultToneId, receivedCC.defaultToneId);
      self.state.set(StateKeys.defaultVolume, receivedCC.defaultVolume);
      return { action: "ok" };
    }
  }
};
const respondToSoundSwitchToneNumberGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_SoundSwitchCC.SoundSwitchCCTonesNumberGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Sound Switch"], receivedCC.endpointIndex)
      };
      const cc = new import_SoundSwitchCC.SoundSwitchCCTonesNumberReport({
        nodeId: controller.ownNodeId,
        toneCount: capabilities.tones.length
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToSoundSwitchToneInfoGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_SoundSwitchCC.SoundSwitchCCToneInfoGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Sound Switch"], receivedCC.endpointIndex)
      };
      const tone = capabilities.tones[receivedCC.toneId - 1];
      if (tone) {
        const cc = new import_SoundSwitchCC.SoundSwitchCCToneInfoReport({
          nodeId: controller.ownNodeId,
          toneId: receivedCC.toneId,
          ...tone
        });
        return { action: "sendCC", cc };
      }
      return { action: "stop" };
    }
  }
};
const respondToSoundSwitchTonePlaySet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_SoundSwitchCC.SoundSwitchCCTonePlaySet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Sound Switch"], receivedCC.endpointIndex)
      };
      const currentState = self.state.get(StateKeys.state);
      if (receivedCC.toneId === 0) {
        if (currentState) {
          currentState.timeout.clear();
          self.state.delete(StateKeys.state);
        }
        return { action: "ok" };
      } else {
        const toneId = receivedCC.toneId === 255 ? capabilities.defaultToneId : receivedCC.toneId;
        const tone = capabilities.tones[toneId - 1];
        if (!tone)
          return { action: "fail" };
        const volume = (receivedCC.volume === 0 ? capabilities.defaultVolume : receivedCC.volume === 255 ? self.state.get(StateKeys.lastNonZeroVolume) : receivedCC.volume) || capabilities.defaultVolume;
        if (currentState) {
          currentState.timeout.clear();
          self.state.delete(StateKeys.state);
        }
        if (volume !== 0) {
          self.state.set(StateKeys.lastNonZeroVolume, volume);
        }
        const newState = {
          toneId,
          volume,
          timeout: (0, import_shared.setTimer)(async () => {
            self.state.delete(StateKeys.state);
            const cc = new import_SoundSwitchCC.SoundSwitchCCTonePlayReport({
              nodeId: controller.ownNodeId,
              toneId: 0,
              volume: 0
            });
            await self.sendToController((0, import_testing.createMockZWaveRequestFrame)(cc, {
              ackRequested: false
            }));
          }, tone.duration * 1e3).unref()
        };
        self.state.set(StateKeys.state, newState);
        return { action: "ok" };
      }
    }
  }
};
const respondToSoundSwitchTonePlayGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_SoundSwitchCC.SoundSwitchCCTonePlayGet) {
      const currentState = self.state.get(StateKeys.state);
      const cc = new import_SoundSwitchCC.SoundSwitchCCTonePlayReport({
        nodeId: controller.ownNodeId,
        toneId: currentState?.toneId ?? 0,
        volume: currentState?.volume ?? 0
      });
      return { action: "sendCC", cc };
    }
  }
};
const SoundSwitchCCBehaviors = [
  respondToSoundSwitchConfigurationGet,
  respondToSoundSwitchConfigurationSet,
  respondToSoundSwitchToneNumberGet,
  respondToSoundSwitchToneInfoGet,
  respondToSoundSwitchTonePlaySet,
  respondToSoundSwitchTonePlayGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SoundSwitchCCBehaviors
});
//# sourceMappingURL=SoundSwitch.js.map
