"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatMode_exports = {};
__export(ThermostatMode_exports, {
  ThermostatModeCCBehaviors: () => ThermostatModeCCBehaviors
});
module.exports = __toCommonJS(ThermostatMode_exports);
var import_cc = require("@zwave-js/cc");
var import_ThermostatModeCC = require("@zwave-js/cc/ThermostatModeCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  supportedModes: [import_cc.ThermostatMode.Off]
};
const STATE_KEY_PREFIX = "ThermostatMode_";
const StateKeys = {
  mode: `${STATE_KEY_PREFIX}mode`,
  manufacturerData: `${STATE_KEY_PREFIX}manufacturerData`
};
const respondToThermostatModeSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatModeCC.ThermostatModeCCSet) {
      self.state.set(StateKeys.mode, receivedCC.mode);
      self.state.set(StateKeys.manufacturerData, receivedCC.manufacturerData);
      return { action: "ok" };
    }
  }
};
const respondToThermostatModeGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatModeCC.ThermostatModeCCGet) {
      const mode = self.state.get(StateKeys.mode) ?? import_cc.ThermostatMode.Off;
      const manufacturerData = mode === import_cc.ThermostatMode["Manufacturer specific"] ? self.state.get(StateKeys.manufacturerData) : void 0;
      const cc = new import_ThermostatModeCC.ThermostatModeCCReport({
        nodeId: controller.ownNodeId,
        mode,
        // @ts-expect-error I know...
        manufacturerData
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToThermostatModeSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatModeCC.ThermostatModeCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Thermostat Mode"], receivedCC.endpointIndex)
      };
      const cc = new import_ThermostatModeCC.ThermostatModeCCSupportedReport({
        nodeId: controller.ownNodeId,
        supportedModes: capabilities.supportedModes
      });
      return { action: "sendCC", cc };
    }
  }
};
const ThermostatModeCCBehaviors = [
  respondToThermostatModeGet,
  respondToThermostatModeSet,
  respondToThermostatModeSupportedGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatModeCCBehaviors
});
//# sourceMappingURL=ThermostatMode.js.map
