import { NVMAccess, type NVMIO } from "@zwave-js/nvmedit";
import type { ZWaveController } from "./Controller.js";
/** NVM IO over serial for 500 series controllers */
export declare class SerialNVMIO500 implements NVMIO {
    constructor(controller: ZWaveController);
    private _controller;
    private _size;
    private _chunkSize;
    open(_access: NVMAccess): Promise<NVMAccess>;
    get size(): number;
    get accessMode(): NVMAccess;
    determineChunkSize(): Promise<number>;
    read(offset: number, length: number): Promise<{
        buffer: Uint8Array;
        endOfFile: boolean;
    }>;
    write(offset: number, data: Uint8Array): Promise<{
        bytesWritten: number;
        endOfFile: boolean;
    }>;
    close(): Promise<void>;
}
/** NVM IO over serial for 700+ series controllers */
export declare class SerialNVMIO700 implements NVMIO {
    constructor(controller: ZWaveController);
    private _controller;
    private _open;
    private _read;
    private _write;
    private _close;
    private _size;
    private _chunkSize;
    private _accessMode;
    open(access: NVMAccess.Read | NVMAccess.Write): Promise<NVMAccess>;
    get size(): number;
    get accessMode(): NVMAccess;
    determineChunkSize(): Promise<number>;
    read(offset: number, length: number): Promise<{
        buffer: Uint8Array;
        endOfFile: boolean;
    }>;
    write(offset: number, data: Uint8Array): Promise<{
        bytesWritten: number;
        endOfFile: boolean;
    }>;
    close(): Promise<void>;
}
//# sourceMappingURL=NVMIO.d.ts.map