import type { CopyFile, MakeTempDirectory, ManageDirectory, OpenFile, ReadFileSystemInfo, WriteFile } from "@zwave-js/shared/bindings";
/**
 * Checks whether there is a compatible update for the currently installed config package.
 * Returns the new version if there is an update, `undefined` otherwise.
 * Throws if the update check failed.
 */
export declare function checkForConfigUpdates(currentVersion: string): Promise<string | undefined>;
/**
 * Downloads and installs the given configuration update.
 * This only works if an external configuation directory is used.
 */
export declare function installConfigUpdate(fs: ManageDirectory & ReadFileSystemInfo & WriteFile & CopyFile & OpenFile & MakeTempDirectory, newVersion: string, external: {
    configDir: string;
}): Promise<void>;
//# sourceMappingURL=UpdateConfig.d.ts.map