import { type DataRate, type FLiRS, type MaybeNotKnown, type NodeType, type ProtocolVersion, Protocols } from "@zwave-js/core";
import { ZWaveNodeBase } from "./00_Base.js";
export interface NodeNetworkRole {
    /** Whether this node is always listening or not */
    readonly isListening: MaybeNotKnown<boolean>;
    /** Indicates the wakeup interval if this node is a FLiRS node. `false` if it isn't. */
    readonly isFrequentListening: MaybeNotKnown<FLiRS>;
    /** Whether this node can sleep */
    readonly canSleep: MaybeNotKnown<boolean>;
    /** Whether the node supports routing/forwarding messages. */
    readonly isRouting: MaybeNotKnown<boolean>;
    /** All supported data rates of this node */
    readonly supportedDataRates: MaybeNotKnown<readonly DataRate[]>;
    /** The maximum data rate supported by this node */
    readonly maxDataRate: MaybeNotKnown<DataRate>;
    /** The Z-Wave protocol version this node implements */
    readonly protocolVersion: MaybeNotKnown<ProtocolVersion>;
    /** Whether this node is a controller (can calculate routes) or an end node (relies on route info) */
    readonly nodeType: MaybeNotKnown<NodeType>;
    /**
     * Whether this node supports security (S0 or S2).
     * **WARNING:** Nodes often report this incorrectly - do not blindly trust it.
     */
    readonly supportsSecurity: MaybeNotKnown<boolean>;
    /** Whether this node can issue wakeup beams to FLiRS nodes */
    readonly supportsBeaming: MaybeNotKnown<boolean>;
    /** Which protocol is used to communicate with this node */
    readonly protocol: Protocols;
    /** Returns whether this node is the controller */
    readonly isControllerNode: boolean;
}
export declare abstract class NetworkRoleMixin extends ZWaveNodeBase implements NodeNetworkRole {
    get isListening(): MaybeNotKnown<boolean>;
    protected set isListening(value: MaybeNotKnown<boolean>);
    get isFrequentListening(): MaybeNotKnown<FLiRS>;
    protected set isFrequentListening(value: MaybeNotKnown<FLiRS>);
    get canSleep(): MaybeNotKnown<boolean>;
    get isRouting(): MaybeNotKnown<boolean>;
    protected set isRouting(value: MaybeNotKnown<boolean>);
    get supportedDataRates(): MaybeNotKnown<readonly DataRate[]>;
    protected set supportedDataRates(value: MaybeNotKnown<readonly DataRate[]>);
    get maxDataRate(): MaybeNotKnown<DataRate>;
    get protocolVersion(): MaybeNotKnown<ProtocolVersion>;
    protected set protocolVersion(value: MaybeNotKnown<ProtocolVersion>);
    get nodeType(): MaybeNotKnown<NodeType>;
    protected set nodeType(value: MaybeNotKnown<NodeType>);
    get supportsSecurity(): MaybeNotKnown<boolean>;
    protected set supportsSecurity(value: MaybeNotKnown<boolean>);
    get supportsBeaming(): MaybeNotKnown<boolean>;
    protected set supportsBeaming(value: MaybeNotKnown<boolean>);
    get protocol(): Protocols;
    get isControllerNode(): boolean;
}
//# sourceMappingURL=01_NetworkRole.d.ts.map