"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var signal_exports = {};
__export(signal_exports, {
  Signal: () => Signal
});
module.exports = __toCommonJS(signal_exports);
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
class Signal {
  static {
    __name(this, "Signal");
  }
  _listener;
  _status = false;
  get isSet() {
    return this._status;
  }
  set() {
    if (this._status)
      return;
    this._status = true;
    if (this._listener) {
      this._listener.resolve(void 0);
    }
  }
  reset() {
    this._status = false;
    this._listener = void 0;
  }
  then(onfulfilled) {
    if (this._status) {
      return Promise.resolve(onfulfilled());
    } else {
      const p = (0, import_deferred_promise.createDeferredPromise)();
      this._listener = p;
      return p.then(onfulfilled);
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Signal
});
//# sourceMappingURL=signal.js.map
