import type { CCEncodingContext, CCParsingContext } from "@zwave-js/cc";
import { type MaybeNotKnown, type MessageOrCCLogEntry, type SinglecastCC, type WithAddress } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import { CCAPI } from "../lib/API.js";
import { type CCRaw, CommandClass } from "../lib/CommandClass.js";
import { ApplicationStatus, ApplicationStatusCommand } from "../lib/_Types.js";
export declare class ApplicationStatusCCAPI extends CCAPI {
    supportsCommand(cmd: ApplicationStatusCommand): MaybeNotKnown<boolean>;
}
export declare class ApplicationStatusCC extends CommandClass implements SinglecastCC<ApplicationStatusCC> {
    ccCommand: ApplicationStatusCommand;
    nodeId: number;
}
export interface ApplicationStatusCCBusyOptions {
    status: ApplicationStatus;
    waitTime?: number;
}
export declare class ApplicationStatusCCBusy extends ApplicationStatusCC {
    constructor(options: WithAddress<ApplicationStatusCCBusyOptions>);
    static from(raw: CCRaw, ctx: CCParsingContext): ApplicationStatusCCBusy;
    readonly status: ApplicationStatus;
    readonly waitTime: number | undefined;
    serialize(ctx: CCEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ApplicationStatusCCRejectedRequestOptions {
    status: number;
}
export declare class ApplicationStatusCCRejectedRequest extends ApplicationStatusCC {
    static from(raw: CCRaw, ctx: CCParsingContext): ApplicationStatusCCRejectedRequest;
    serialize(ctx: CCEncodingContext): Promise<Bytes>;
}
//# sourceMappingURL=ApplicationStatusCC.d.ts.map