"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ApplicationStatusCC_exports = {};
__export(ApplicationStatusCC_exports, {
  ApplicationStatusCC: () => ApplicationStatusCC,
  ApplicationStatusCCAPI: () => ApplicationStatusCCAPI,
  ApplicationStatusCCBusy: () => ApplicationStatusCCBusy,
  ApplicationStatusCCRejectedRequest: () => ApplicationStatusCCRejectedRequest
});
module.exports = __toCommonJS(ApplicationStatusCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let ApplicationStatusCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Application Status"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  var ApplicationStatusCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ApplicationStatusCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationStatusCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ApplicationStatusCommand.Busy:
        case import_Types.ApplicationStatusCommand.RejectedRequest:
          return true;
      }
      return super.supportsCommand(cmd);
    }
  };
  return ApplicationStatusCCAPI2 = _classThis;
})();
let ApplicationStatusCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Application Status"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ApplicationStatusCC2 = class extends _classSuper {
    static {
      __name(this, "ApplicationStatusCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationStatusCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ApplicationStatusCC2 = _classThis;
})();
let ApplicationStatusCCBusy = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ApplicationStatusCommand.Busy)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationStatusCC;
  var ApplicationStatusCCBusy2 = class extends _classSuper {
    static {
      __name(this, "ApplicationStatusCCBusy");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationStatusCCBusy2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.status = options.status;
      this.waitTime = options.waitTime;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const status = raw.payload[0];
      let waitTime;
      if (status === import_Types.ApplicationStatus.TryAgainInWaitTimeSeconds && raw.payload.length >= 2) {
        waitTime = raw.payload[1];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        status,
        waitTime
      });
    }
    status;
    waitTime;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.status, this.waitTime ?? 0]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const message = {
        status: (0, import_shared.getEnumMemberName)(import_Types.ApplicationStatus, this.status)
      };
      if (this.status === import_Types.ApplicationStatus.TryAgainInWaitTimeSeconds) {
        message["wait time"] = `${this.waitTime} seconds`;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return ApplicationStatusCCBusy2 = _classThis;
})();
let ApplicationStatusCCRejectedRequest = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ApplicationStatusCommand.RejectedRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationStatusCC;
  var ApplicationStatusCCRejectedRequest2 = class extends _classSuper {
    static {
      __name(this, "ApplicationStatusCCRejectedRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationStatusCCRejectedRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const status = raw.payload[0];
      (0, import_core.validatePayload)(status === 0);
      return new this({
        nodeId: ctx.sourceNodeId
      });
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([0]);
      return super.serialize(ctx);
    }
  };
  return ApplicationStatusCCRejectedRequest2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ApplicationStatusCC,
  ApplicationStatusCCAPI,
  ApplicationStatusCCBusy,
  ApplicationStatusCCRejectedRequest
});
//# sourceMappingURL=ApplicationStatusCC.js.map
