"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EnergyProductionCC_exports = {};
__export(EnergyProductionCC_exports, {
  EnergyProductionCC: () => EnergyProductionCC,
  EnergyProductionCCAPI: () => EnergyProductionCCAPI,
  EnergyProductionCCGet: () => EnergyProductionCCGet,
  EnergyProductionCCReport: () => EnergyProductionCCReport,
  EnergyProductionCCValues: () => import_CCValues_generated.EnergyProductionCCValues
});
module.exports = __toCommonJS(EnergyProductionCC_exports);
var __validateArgs = __toESM(require("./EnergyProductionCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_EnergyProductionCCAPI_get } = __validateArgs;
let EnergyProductionCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Energy Production"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  var EnergyProductionCCAPI2 = class extends _classSuper {
    static {
      __name(this, "EnergyProductionCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_EnergyProductionCCAPI_get({ strictEnums: true })];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EnergyProductionCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.EnergyProductionCommand.Get:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        if (import_CCValues_generated.EnergyProductionCCValues.value.is({
          commandClass: this.ccId,
          property,
          propertyKey
        })) {
          return (await this.get(property))?.value;
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async get(parameter) {
      this.assertSupportsCommand(import_Types.EnergyProductionCommand, import_Types.EnergyProductionCommand.Get);
      const cc = new EnergyProductionCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["value", "scale"]);
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return EnergyProductionCCAPI2 = _classThis;
})();
let EnergyProductionCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Energy Production"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.EnergyProductionCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var EnergyProductionCC2 = class extends _classSuper {
    static {
      __name(this, "EnergyProductionCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EnergyProductionCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Energy Production"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      for (const parameter of [
        import_Types.EnergyProductionParameter.Power,
        import_Types.EnergyProductionParameter["Production Total"],
        import_Types.EnergyProductionParameter["Production Today"],
        import_Types.EnergyProductionParameter["Total Time"]
      ]) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying energy production (${(0, import_shared.getEnumMemberName)(import_Types.EnergyProductionParameter, parameter)})...`,
          direction: "outbound"
        });
        await api.get(parameter);
      }
    }
  };
  return EnergyProductionCC2 = _classThis;
})();
let EnergyProductionCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EnergyProductionCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EnergyProductionCC;
  var EnergyProductionCCReport2 = class extends _classSuper {
    static {
      __name(this, "EnergyProductionCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EnergyProductionCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.value = options.value;
      this.scale = options.scale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const parameter = raw.payload[0];
      const { value, scale: rawScale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      const scale = (0, import_Types.getEnergyProductionScale)(parameter, rawScale);
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        value,
        scale
      });
    }
    parameter;
    scale;
    value;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const valueValue = import_CCValues_generated.EnergyProductionCCValues.value(this.parameter);
      this.setMetadata(ctx, valueValue, {
        ...valueValue.meta,
        unit: this.scale.unit,
        ccSpecific: {
          parameter: this.parameter,
          scale: this.scale.key
        }
      });
      this.setValue(ctx, valueValue, this.value);
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.parameter]),
        (0, import_core.encodeFloatWithScale)(this.value, this.scale.key)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          [(0, import_shared.getEnumMemberName)(import_Types.EnergyProductionParameter, this.parameter).toLowerCase()]: `${this.value} ${this.scale.unit}`
        }
      };
    }
  };
  return EnergyProductionCCReport2 = _classThis;
})();
function testResponseForEnergyProductionGet(sent, received) {
  return received.parameter === sent.parameter;
}
__name(testResponseForEnergyProductionGet, "testResponseForEnergyProductionGet");
let EnergyProductionCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.EnergyProductionCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(EnergyProductionCCReport, testResponseForEnergyProductionGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = EnergyProductionCC;
  var EnergyProductionCCGet2 = class extends _classSuper {
    static {
      __name(this, "EnergyProductionCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      EnergyProductionCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const parameter = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.parameter]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          parameter: (0, import_shared.getEnumMemberName)(import_Types.EnergyProductionParameter, this.parameter)
        }
      };
    }
  };
  return EnergyProductionCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EnergyProductionCC,
  EnergyProductionCCAPI,
  EnergyProductionCCGet,
  EnergyProductionCCReport,
  EnergyProductionCCValues
});
//# sourceMappingURL=EnergyProductionCC.js.map
