"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultilevelSwitchCC_exports = {};
__export(MultilevelSwitchCC_exports, {
  MultilevelSwitchCC: () => MultilevelSwitchCC,
  MultilevelSwitchCCAPI: () => MultilevelSwitchCCAPI,
  MultilevelSwitchCCGet: () => MultilevelSwitchCCGet,
  MultilevelSwitchCCReport: () => MultilevelSwitchCCReport,
  MultilevelSwitchCCSet: () => MultilevelSwitchCCSet,
  MultilevelSwitchCCStartLevelChange: () => MultilevelSwitchCCStartLevelChange,
  MultilevelSwitchCCStopLevelChange: () => MultilevelSwitchCCStopLevelChange,
  MultilevelSwitchCCSupportedGet: () => MultilevelSwitchCCSupportedGet,
  MultilevelSwitchCCSupportedReport: () => MultilevelSwitchCCSupportedReport,
  MultilevelSwitchCCValues: () => import_CCValues_generated.MultilevelSwitchCCValues
});
module.exports = __toCommonJS(MultilevelSwitchCC_exports);
var __validateArgs = __toESM(require("./MultilevelSwitchCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CCValueUtils = require("../lib/CCValueUtils.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_MultilevelSwitchCCAPI_set, validateArgs_MultilevelSwitchCCAPI_startLevelChange } = __validateArgs;
let MultilevelSwitchCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Multilevel Switch"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  let _startLevelChange_decorators;
  var MultilevelSwitchCCAPI2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _startLevelChange_decorators, { kind: "method", name: "startLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "startLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.startLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.MultilevelSwitchCommand.Get:
          return this.isSinglecast();
        case import_Types.MultilevelSwitchCommand.Set:
        case import_Types.MultilevelSwitchCommand.StartLevelChange:
        case import_Types.MultilevelSwitchCommand.StopLevelChange:
          return true;
        // This is mandatory
        case import_Types.MultilevelSwitchCommand.SupportedGet:
          return this.version >= 3 && this.isSinglecast();
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.MultilevelSwitchCommand, import_Types.MultilevelSwitchCommand.Get);
      const cc = new MultilevelSwitchCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["currentValue", "targetValue", "duration"]);
      }
    }
    /**
     * Sets the switch to a new value
     * @param targetValue The new target value for the switch
     * @param duration The duration after which the target value should be reached. Can be a Duration instance or a user-friendly duration string like `"1m17s"`. Only supported in V2 and above.
     * @returns A promise indicating whether the command was completed
     */
    async set(targetValue, duration) {
      this.assertSupportsCommand(import_Types.MultilevelSwitchCommand, import_Types.MultilevelSwitchCommand.Set);
      const cc = new MultilevelSwitchCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        targetValue,
        duration
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async startLevelChange(options) {
      this.assertSupportsCommand(import_Types.MultilevelSwitchCommand, import_Types.MultilevelSwitchCommand.StartLevelChange);
      const cc = new MultilevelSwitchCCStartLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...options
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async stopLevelChange() {
      this.assertSupportsCommand(import_Types.MultilevelSwitchCommand, import_Types.MultilevelSwitchCommand.StopLevelChange);
      const cc = new MultilevelSwitchCCStopLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getSupported() {
      this.assertSupportsCommand(import_Types.MultilevelSwitchCommand, import_Types.MultilevelSwitchCommand.SupportedGet);
      const cc = new MultilevelSwitchCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.switchType;
    }
    get [(_set_decorators = [validateArgs_MultilevelSwitchCCAPI_set()], _startLevelChange_decorators = [validateArgs_MultilevelSwitchCCAPI_startLevelChange()], import_API.SET_VALUE)]() {
      return async function({ property }, value, options) {
        if (property === "restorePrevious") {
          property = "targetValue";
          value = 255;
        }
        if (property === "targetValue") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const duration = import_core.Duration.from(options?.transitionDuration);
          return this.set(value, duration);
        } else if (import_CCValueUtils.multilevelSwitchTypeProperties.includes(property)) {
          if (typeof value !== "boolean") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          if (value) {
            const direction = import_CCValueUtils.multilevelSwitchTypeProperties.indexOf(property) % 2 === 0 ? "down" : "up";
            const startLevel = this.tryGetValueDB()?.getValue(import_CCValues_generated.MultilevelSwitchCCValues.currentValue.endpoint(this.endpoint.index));
            const duration = import_core.Duration.from(options?.transitionDuration);
            return this.startLevelChange({
              direction,
              ignoreStartLevel: true,
              startLevel: typeof startLevel === "number" ? startLevel : void 0,
              duration
            });
          } else {
            return this.stopLevelChange();
          }
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    [import_API.SET_VALUE_HOOKS] = (__runInitializers(this, _instanceExtraInitializers), ({ property }, value, options) => {
      if (property === "restorePrevious") {
        property = "targetValue";
        value = 255;
      }
      if (property === "targetValue") {
        const duration = import_core.Duration.from(options?.transitionDuration);
        const currentValueValueId = import_CCValues_generated.MultilevelSwitchCCValues.currentValue.endpoint(this.endpoint.index);
        return {
          // Multilevel Switch commands may take some time to be executed.
          // Therefore we try to supervise the command execution and delay the
          // optimistic update until the final result is received.
          supervisionDelayedUpdates: true,
          supervisionOnSuccess: /* @__PURE__ */ __name(async () => {
            if (typeof value === "number" && value >= 0 && value <= 99) {
              this.tryGetValueDB()?.setValue(currentValueValueId, value);
            } else if (value === 255) {
              try {
                await this.get();
              } catch {
              }
            }
          }, "supervisionOnSuccess"),
          supervisionOnFailure: /* @__PURE__ */ __name(async () => {
            try {
              await this.get();
            } catch {
            }
          }, "supervisionOnFailure"),
          optimisticallyUpdateRelatedValues: /* @__PURE__ */ __name((_supervisedAndSuccessful) => {
            if (typeof value === "number" && value >= 0 && value <= 99) {
              if (this.isSinglecast()) {
                this.tryGetValueDB()?.setValue(currentValueValueId, value);
              } else if (this.isMulticast()) {
                const affectedNodes = this.endpoint.node.physicalNodes.filter((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(this.ccId));
                for (const node of affectedNodes) {
                  this.host.tryGetValueDB(node.id)?.setValue(currentValueValueId, value);
                }
              }
            }
          }, "optimisticallyUpdateRelatedValues"),
          forceVerifyChanges: /* @__PURE__ */ __name(() => {
            return value === 255;
          }, "forceVerifyChanges"),
          verifyChanges: /* @__PURE__ */ __name(async (result) => {
            if (
              // We generally don't want to poll for multicasts because of how much traffic it can cause
              // However, when setting the value 255 (ON), we don't know the actual state
              !(this.isSinglecast() || this.isMulticast() && value === 255)
            ) {
              return;
            }
            switch (result?.status) {
              case import_core.SupervisionStatus.Success:
              case import_core.SupervisionStatus.Fail:
                await this.pollValue(currentValueValueId);
                break;
              case import_core.SupervisionStatus.Working:
              default:
                this.schedulePoll(currentValueValueId, value === 255 ? void 0 : value, {
                  duration: result?.remainingDuration ?? duration
                });
                break;
            }
          }, "verifyChanges")
        };
      }
    });
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "currentValue":
          case "targetValue":
          case "duration":
            return (await this.get())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
  };
  return MultilevelSwitchCCAPI2 = _classThis;
})();
let MultilevelSwitchCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Multilevel Switch"]), (0, import_CommandClassDecorators.implementedVersion)(4), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.MultilevelSwitchCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var MultilevelSwitchCC2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Multilevel Switch"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (api.version >= 3) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "requesting switch type...",
          direction: "outbound"
        });
        const switchType = await api.getSupported();
        if (switchType != void 0) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `has switch type ${(0, import_shared.getEnumMemberName)(import_Types.SwitchType, switchType)}`,
            direction: "inbound"
          });
        }
      } else {
        this.createMetadataForLevelChangeActions(ctx);
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Multilevel Switch"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "requesting current switch state...",
        direction: "outbound"
      });
      await api.get();
    }
    setMappedBasicValue(ctx, value) {
      this.setValue(ctx, import_CCValues_generated.MultilevelSwitchCCValues.currentValue, value);
      return true;
    }
    createMetadataForLevelChangeActions(ctx, switchType = import_Types.SwitchType["Down/Up"]) {
      this.ensureMetadata(ctx, import_CCValues_generated.MultilevelSwitchCCValues.levelChangeUp(switchType));
      this.ensureMetadata(ctx, import_CCValues_generated.MultilevelSwitchCCValues.levelChangeDown(switchType));
    }
  };
  return MultilevelSwitchCC2 = _classThis;
})();
let MultilevelSwitchCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCSet2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.targetValue = options.targetValue;
      this.duration = import_core.Duration.from(options.duration);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const targetValue = raw.payload[0];
      let duration;
      if (raw.payload.length >= 2) {
        duration = import_core.Duration.parseReport(raw.payload[1]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        targetValue,
        duration
      });
    }
    targetValue;
    duration;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.targetValue,
        (this.duration ?? import_core.Duration.default()).serializeSet()
      ]);
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion < 2 && ctx.getDeviceConfig?.(this.nodeId)?.compat?.encodeCCsUsingTargetVersion) {
        this.payload = this.payload.subarray(0, 1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "target value": this.targetValue
      };
      if (this.duration) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return MultilevelSwitchCCSet2 = _classThis;
})();
let MultilevelSwitchCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("targetValue", import_CCValues_generated.MultilevelSwitchCCValues.targetValue), (0, import_CommandClassDecorators.ccValueProperty)("duration", import_CCValues_generated.MultilevelSwitchCCValues.duration), (0, import_CommandClassDecorators.ccValueProperty)("currentValue", import_CCValues_generated.MultilevelSwitchCCValues.currentValue)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCReport2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.currentValue = options.currentValue;
      this.targetValue = options.targetValue;
      this.duration = import_core.Duration.from(options.duration);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const currentValue = (
        // 0xff is a legacy value for 100% (99)
        raw.payload[0] === 255 ? 99 : (0, import_core.parseMaybeNumber)(raw.payload[0])
      );
      let targetValue;
      let duration;
      if (raw.payload.length >= 3) {
        targetValue = (0, import_core.parseMaybeNumber)(raw.payload[1]);
        duration = import_core.Duration.parseReport(raw.payload[2]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        currentValue,
        targetValue,
        duration
      });
    }
    targetValue;
    duration;
    currentValue;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.currentValue ?? 254,
        this.targetValue ?? 254,
        (this.duration ?? import_core.Duration.default()).serializeReport()
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "current value": (0, import_core.maybeUnknownToString)(this.currentValue)
      };
      if (this.targetValue !== import_core.NOT_KNOWN && this.duration) {
        message["target value"] = (0, import_core.maybeUnknownToString)(this.targetValue);
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return MultilevelSwitchCCReport2 = _classThis;
})();
let MultilevelSwitchCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(MultilevelSwitchCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCGet2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return MultilevelSwitchCCGet2 = _classThis;
})();
let MultilevelSwitchCCStartLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.StartLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCStartLevelChange2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCStartLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCStartLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.duration = import_core.Duration.from(options.duration);
      this.ignoreStartLevel = options.ignoreStartLevel;
      this.startLevel = options.startLevel ?? 0;
      this.direction = options.direction;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const ignoreStartLevel = !!((raw.payload[0] & 32) >>> 5);
      const direction = (raw.payload[0] & 64) >>> 6 ? "down" : "up";
      const startLevel = raw.payload[1];
      let duration;
      if (raw.payload.length >= 3) {
        duration = import_core.Duration.parseSet(raw.payload[2]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        ignoreStartLevel,
        direction,
        startLevel,
        duration
      });
    }
    duration;
    startLevel;
    ignoreStartLevel;
    direction;
    serialize(ctx) {
      const controlByte = import_Types.LevelChangeDirection[this.direction] << 6 | (this.ignoreStartLevel ? 32 : 0);
      this.payload = import_shared.Bytes.from([
        controlByte,
        this.startLevel,
        (this.duration ?? import_core.Duration.default()).serializeSet()
      ]);
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion < 2 && ctx.getDeviceConfig?.(this.nodeId)?.compat?.encodeCCsUsingTargetVersion) {
        this.payload = this.payload.subarray(0, -1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        startLevel: `${this.startLevel}${this.ignoreStartLevel ? " (ignored)" : ""}`,
        direction: this.direction
      };
      if (this.duration) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return MultilevelSwitchCCStartLevelChange2 = _classThis;
})();
let MultilevelSwitchCCStopLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.StopLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCStopLevelChange2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCStopLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCStopLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return MultilevelSwitchCCStopLevelChange2 = _classThis;
})();
let MultilevelSwitchCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("switchType", import_CCValues_generated.MultilevelSwitchCCValues.switchType)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.switchType = options.switchType;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const switchType = raw.payload[0] & 31;
      return new this({
        nodeId: ctx.sourceNodeId,
        switchType
      });
    }
    // This is the primary switch type. We're not supporting secondary switch types
    switchType;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      this.createMetadataForLevelChangeActions(ctx, this.switchType);
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.switchType & 31]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "switch type": (0, import_shared.getEnumMemberName)(import_Types.SwitchType, this.switchType)
        }
      };
    }
  };
  return MultilevelSwitchCCSupportedReport2 = _classThis;
})();
let MultilevelSwitchCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.MultilevelSwitchCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(MultilevelSwitchCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = MultilevelSwitchCC;
  var MultilevelSwitchCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "MultilevelSwitchCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      MultilevelSwitchCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return MultilevelSwitchCCSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultilevelSwitchCC,
  MultilevelSwitchCCAPI,
  MultilevelSwitchCCGet,
  MultilevelSwitchCCReport,
  MultilevelSwitchCCSet,
  MultilevelSwitchCCStartLevelChange,
  MultilevelSwitchCCStopLevelChange,
  MultilevelSwitchCCSupportedGet,
  MultilevelSwitchCCSupportedReport,
  MultilevelSwitchCCValues
});
//# sourceMappingURL=MultilevelSwitchCC.js.map
