"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeNamingCC_exports = {};
__export(NodeNamingCC_exports, {
  NodeNamingAndLocationCC: () => NodeNamingAndLocationCC,
  NodeNamingAndLocationCCAPI: () => NodeNamingAndLocationCCAPI,
  NodeNamingAndLocationCCLocationGet: () => NodeNamingAndLocationCCLocationGet,
  NodeNamingAndLocationCCLocationReport: () => NodeNamingAndLocationCCLocationReport,
  NodeNamingAndLocationCCLocationSet: () => NodeNamingAndLocationCCLocationSet,
  NodeNamingAndLocationCCNameGet: () => NodeNamingAndLocationCCNameGet,
  NodeNamingAndLocationCCNameReport: () => NodeNamingAndLocationCCNameReport,
  NodeNamingAndLocationCCNameSet: () => NodeNamingAndLocationCCNameSet,
  NodeNamingAndLocationCCValues: () => import_CCValues_generated.NodeNamingAndLocationCCValues
});
module.exports = __toCommonJS(NodeNamingCC_exports);
var __validateArgs = __toESM(require("./NodeNamingCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_NodeNamingAndLocationCCAPI_setName, validateArgs_NodeNamingAndLocationCCAPI_setLocation } = __validateArgs;
function isASCII(str) {
  return /^[\x00-\x7F]*$/.test(str);
}
__name(isASCII, "isASCII");
let NodeNamingAndLocationCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Node Naming and Location"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _setName_decorators;
  let _setLocation_decorators;
  var NodeNamingAndLocationCCAPI2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _setName_decorators = [validateArgs_NodeNamingAndLocationCCAPI_setName()];
      _setLocation_decorators = [validateArgs_NodeNamingAndLocationCCAPI_setLocation()];
      __esDecorate(this, null, _setName_decorators, { kind: "method", name: "setName", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setName" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setName, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setLocation_decorators, { kind: "method", name: "setLocation", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setLocation" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setLocation, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.NodeNamingAndLocationCommand.NameGet:
        case import_Types.NodeNamingAndLocationCommand.NameSet:
        case import_Types.NodeNamingAndLocationCommand.LocationGet:
        case import_Types.NodeNamingAndLocationCommand.LocationSet:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        if (property !== "name" && property !== "location") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof value !== "string") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "string", typeof value);
        }
        switch (property) {
          case "name":
            return this.setName(value);
          case "location":
            return this.setLocation(value);
        }
        return void 0;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "name":
            return this.getName();
          case "location":
            return this.getLocation();
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async getName() {
      this.assertSupportsCommand(import_Types.NodeNamingAndLocationCommand, import_Types.NodeNamingAndLocationCommand.NameGet);
      const cc = new NodeNamingAndLocationCCNameGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.name;
    }
    async setName(name) {
      this.assertSupportsCommand(import_Types.NodeNamingAndLocationCommand, import_Types.NodeNamingAndLocationCommand.NameSet);
      const cc = new NodeNamingAndLocationCCNameSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        name
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getLocation() {
      this.assertSupportsCommand(import_Types.NodeNamingAndLocationCommand, import_Types.NodeNamingAndLocationCommand.LocationGet);
      const cc = new NodeNamingAndLocationCCLocationGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.location;
    }
    async setLocation(location) {
      this.assertSupportsCommand(import_Types.NodeNamingAndLocationCommand, import_Types.NodeNamingAndLocationCommand.LocationSet);
      const cc = new NodeNamingAndLocationCCLocationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        location
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return NodeNamingAndLocationCCAPI2 = _classThis;
})();
let NodeNamingAndLocationCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Node Naming and Location"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.NodeNamingAndLocationCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var NodeNamingAndLocationCC2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    skipEndpointInterview() {
      return true;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Node Naming and Location"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        message: "retrieving node name...",
        direction: "outbound"
      });
      const name = await api.getName();
      if (name != void 0) {
        ctx.logNode(node.id, {
          message: `is named "${name}"`,
          direction: "inbound"
        });
      }
      ctx.logNode(node.id, {
        message: "retrieving node location...",
        direction: "outbound"
      });
      const location = await api.getLocation();
      if (location != void 0) {
        ctx.logNode(node.id, {
          message: `received location: ${location}`,
          direction: "inbound"
        });
      }
    }
  };
  return NodeNamingAndLocationCC2 = _classThis;
})();
let NodeNamingAndLocationCCNameSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.NodeNamingAndLocationCommand.NameSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = NodeNamingAndLocationCC;
  var NodeNamingAndLocationCCNameSet2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCNameSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCNameSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.name = options.name;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    name;
    serialize(ctx) {
      const encoding = isASCII(this.name) ? "ascii" : "utf16le";
      this.payload = new import_shared.Bytes(1 + this.name.length * (encoding === "ascii" ? 1 : 2));
      this.payload[0] = encoding === "ascii" ? 0 : 2;
      let nameBuffer;
      if (encoding === "utf16le") {
        nameBuffer = (0, import_shared.stringToUint8ArrayUTF16BE)(this.name);
      } else {
        nameBuffer = import_shared.Bytes.from(this.name, "ascii");
      }
      this.payload.set(nameBuffer.subarray(0, Math.min(16, nameBuffer.length)), 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { name: this.name }
      };
    }
  };
  return NodeNamingAndLocationCCNameSet2 = _classThis;
})();
let NodeNamingAndLocationCCNameReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.NodeNamingAndLocationCommand.NameReport), (0, import_CommandClassDecorators.ccValueProperty)("name", import_CCValues_generated.NodeNamingAndLocationCCValues.name)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = NodeNamingAndLocationCC;
  var NodeNamingAndLocationCCNameReport2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCNameReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCNameReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.name = options.name;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const encoding = raw.payload[0] === 2 ? "utf16le" : "ascii";
      const nameBuffer = raw.payload.subarray(1);
      let name;
      if (encoding === "utf16le") {
        (0, import_core.validatePayload)(nameBuffer.length % 2 === 0);
        name = (0, import_shared.uint8ArrayToStringUTF16BE)(nameBuffer);
      } else {
        name = nameBuffer.toString("ascii");
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        name
      });
    }
    name;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { name: this.name }
      };
    }
  };
  return NodeNamingAndLocationCCNameReport2 = _classThis;
})();
let NodeNamingAndLocationCCNameGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.NodeNamingAndLocationCommand.NameGet), (0, import_CommandClassDecorators.expectedCCResponse)(NodeNamingAndLocationCCNameReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = NodeNamingAndLocationCC;
  var NodeNamingAndLocationCCNameGet2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCNameGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCNameGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return NodeNamingAndLocationCCNameGet2 = _classThis;
})();
let NodeNamingAndLocationCCLocationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.NodeNamingAndLocationCommand.LocationSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = NodeNamingAndLocationCC;
  var NodeNamingAndLocationCCLocationSet2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCLocationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCLocationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.location = options.location;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    location;
    serialize(ctx) {
      const encoding = isASCII(this.location) ? "ascii" : "utf16le";
      this.payload = new import_shared.Bytes(1 + this.location.length * (encoding === "ascii" ? 1 : 2));
      this.payload[0] = encoding === "ascii" ? 0 : 2;
      let locationBuffer;
      if (encoding === "utf16le") {
        locationBuffer = (0, import_shared.stringToUint8ArrayUTF16BE)(this.location);
      } else {
        locationBuffer = import_shared.Bytes.from(this.location, "ascii");
      }
      this.payload.set(locationBuffer.subarray(0, Math.min(16, locationBuffer.length)), 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { location: this.location }
      };
    }
  };
  return NodeNamingAndLocationCCLocationSet2 = _classThis;
})();
let NodeNamingAndLocationCCLocationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.NodeNamingAndLocationCommand.LocationReport), (0, import_CommandClassDecorators.ccValueProperty)("location", import_CCValues_generated.NodeNamingAndLocationCCValues.location)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = NodeNamingAndLocationCC;
  var NodeNamingAndLocationCCLocationReport2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCLocationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCLocationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.location = options.location;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const encoding = raw.payload[0] === 2 ? "utf16le" : "ascii";
      const locationBuffer = raw.payload.subarray(1);
      let location;
      if (encoding === "utf16le") {
        (0, import_core.validatePayload)(locationBuffer.length % 2 === 0);
        location = (0, import_shared.uint8ArrayToStringUTF16BE)(locationBuffer);
      } else {
        location = locationBuffer.toString("ascii");
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        location
      });
    }
    location;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { location: this.location }
      };
    }
  };
  return NodeNamingAndLocationCCLocationReport2 = _classThis;
})();
let NodeNamingAndLocationCCLocationGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.NodeNamingAndLocationCommand.LocationGet), (0, import_CommandClassDecorators.expectedCCResponse)(NodeNamingAndLocationCCLocationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = NodeNamingAndLocationCC;
  var NodeNamingAndLocationCCLocationGet2 = class extends _classSuper {
    static {
      __name(this, "NodeNamingAndLocationCCLocationGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      NodeNamingAndLocationCCLocationGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return NodeNamingAndLocationCCLocationGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeNamingAndLocationCC,
  NodeNamingAndLocationCCAPI,
  NodeNamingAndLocationCCLocationGet,
  NodeNamingAndLocationCCLocationReport,
  NodeNamingAndLocationCCLocationSet,
  NodeNamingAndLocationCCNameGet,
  NodeNamingAndLocationCCNameReport,
  NodeNamingAndLocationCCNameSet,
  NodeNamingAndLocationCCValues
});
//# sourceMappingURL=NodeNamingCC.js.map
