"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ProtectionCC_exports = {};
__export(ProtectionCC_exports, {
  ProtectionCC: () => ProtectionCC,
  ProtectionCCAPI: () => ProtectionCCAPI,
  ProtectionCCExclusiveControlGet: () => ProtectionCCExclusiveControlGet,
  ProtectionCCExclusiveControlReport: () => ProtectionCCExclusiveControlReport,
  ProtectionCCExclusiveControlSet: () => ProtectionCCExclusiveControlSet,
  ProtectionCCGet: () => ProtectionCCGet,
  ProtectionCCReport: () => ProtectionCCReport,
  ProtectionCCSet: () => ProtectionCCSet,
  ProtectionCCSupportedGet: () => ProtectionCCSupportedGet,
  ProtectionCCSupportedReport: () => ProtectionCCSupportedReport,
  ProtectionCCTimeoutGet: () => ProtectionCCTimeoutGet,
  ProtectionCCTimeoutReport: () => ProtectionCCTimeoutReport,
  ProtectionCCTimeoutSet: () => ProtectionCCTimeoutSet,
  ProtectionCCValues: () => import_CCValues_generated.ProtectionCCValues
});
module.exports = __toCommonJS(ProtectionCC_exports);
var __validateArgs = __toESM(require("./ProtectionCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_ApplicationStatusCC = require("./ApplicationStatusCC.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ProtectionCCAPI_set, validateArgs_ProtectionCCAPI_setExclusiveControl, validateArgs_ProtectionCCAPI_setTimeout } = __validateArgs;
let ProtectionCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Protection)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  let _setExclusiveControl_decorators;
  let _setTimeout_decorators;
  var ProtectionCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_ProtectionCCAPI_set({ strictEnums: true })];
      _setExclusiveControl_decorators = [validateArgs_ProtectionCCAPI_setExclusiveControl()];
      _setTimeout_decorators = [validateArgs_ProtectionCCAPI_setTimeout()];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setExclusiveControl_decorators, { kind: "method", name: "setExclusiveControl", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setExclusiveControl" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setExclusiveControl, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setTimeout_decorators, { kind: "method", name: "setTimeout", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setTimeout" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setTimeout, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ProtectionCommand.Get:
          return this.isSinglecast();
        case import_Types.ProtectionCommand.Set:
          return true;
        // This is mandatory
        case import_Types.ProtectionCommand.SupportedGet:
          return this.version >= 2 && this.isSinglecast();
        case import_Types.ProtectionCommand.TimeoutGet:
        case import_Types.ProtectionCommand.TimeoutSet: {
          return this.isSinglecast() && this.tryGetValueDB()?.getValue(import_CCValues_generated.ProtectionCCValues.supportsTimeout.endpoint(this.endpoint.index));
        }
        case import_Types.ProtectionCommand.ExclusiveControlGet:
        case import_Types.ProtectionCommand.ExclusiveControlSet: {
          return this.isSinglecast() && this.tryGetValueDB()?.getValue(import_CCValues_generated.ProtectionCCValues.supportsExclusiveControl.endpoint(this.endpoint.index));
        }
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        const valueDB = this.tryGetValueDB();
        if (property === "local") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const rf = valueDB?.getValue(import_CCValues_generated.ProtectionCCValues.rfProtectionState.endpoint(this.endpoint.index));
          return this.set(value, rf);
        } else if (property === "rf") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const local = valueDB?.getValue(import_CCValues_generated.ProtectionCCValues.localProtectionState.endpoint(this.endpoint.index));
          return this.set(local ?? import_Types.LocalProtectionState.Unprotected, value);
        } else if (property === "exclusiveControlNodeId") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          return this.setExclusiveControl(value);
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "local":
          case "rf":
            return (await this.get())?.[property];
          case "exclusiveControlNodeId":
            return this.getExclusiveControl();
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.Get);
      const cc = new ProtectionCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["local", "rf"]);
      }
    }
    async set(local, rf) {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.Set);
      const cc = new ProtectionCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        local,
        rf
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getSupported() {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.SupportedGet);
      const cc = new ProtectionCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "supportsExclusiveControl",
          "supportsTimeout",
          "supportedLocalStates",
          "supportedRFStates"
        ]);
      }
    }
    async getExclusiveControl() {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.ExclusiveControlGet);
      const cc = new ProtectionCCExclusiveControlGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.exclusiveControlNodeId;
    }
    async setExclusiveControl(nodeId) {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.ExclusiveControlSet);
      const cc = new ProtectionCCExclusiveControlSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        exclusiveControlNodeId: nodeId
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getTimeout() {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.TimeoutGet);
      const cc = new ProtectionCCTimeoutGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.timeout;
    }
    async setTimeout(timeout) {
      this.assertSupportsCommand(import_Types.ProtectionCommand, import_Types.ProtectionCommand.TimeoutSet);
      const cc = new ProtectionCCTimeoutSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        timeout
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ProtectionCCAPI2 = _classThis;
})();
let ProtectionCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Protection), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ProtectionCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ProtectionCC2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Protection, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      let hadCriticalTimeout = false;
      if (api.version >= 2) {
        ctx.logNode(node.id, {
          message: "querying protection capabilities...",
          direction: "outbound"
        });
        const resp = await api.getSupported();
        if (resp) {
          const logMessage = `received protection capabilities:
exclusive control:       ${resp.supportsExclusiveControl}
timeout:                 ${resp.supportsTimeout}
local protection states: ${resp.supportedLocalStates.map((local) => (0, import_shared.getEnumMemberName)(import_Types.LocalProtectionState, local)).map((str) => `
\xB7 ${str}`).join("")}
RF protection states:    ${resp.supportedRFStates.map((local) => (0, import_shared.getEnumMemberName)(import_Types.RFProtectionState, local)).map((str) => `
\xB7 ${str}`).join("")}`;
          ctx.logNode(node.id, {
            message: logMessage,
            direction: "inbound"
          });
        } else {
          hadCriticalTimeout = true;
        }
      }
      await this.refreshValues(ctx);
      if (!hadCriticalTimeout)
        this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Protection, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const supportsExclusiveControl = !!this.getValue(ctx, import_CCValues_generated.ProtectionCCValues.supportsExclusiveControl);
      const supportsTimeout = !!this.getValue(ctx, import_CCValues_generated.ProtectionCCValues.supportsTimeout);
      ctx.logNode(node.id, {
        message: "querying protection status...",
        direction: "outbound"
      });
      const protectionResp = await api.get();
      if (protectionResp) {
        let logMessage = `received protection status:
local: ${(0, import_shared.getEnumMemberName)(import_Types.LocalProtectionState, protectionResp.local)}`;
        if (protectionResp.rf != void 0) {
          logMessage += `
rf     ${(0, import_shared.getEnumMemberName)(import_Types.RFProtectionState, protectionResp.rf)}`;
        }
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
      }
      if (supportsTimeout) {
        ctx.logNode(node.id, {
          message: "querying protection timeout...",
          direction: "outbound"
        });
        const timeout = await api.getTimeout();
        if (timeout) {
          ctx.logNode(node.id, {
            message: `received timeout: ${timeout.toString()}`,
            direction: "inbound"
          });
        }
      }
      if (supportsExclusiveControl) {
        ctx.logNode(node.id, {
          message: "querying exclusive control node...",
          direction: "outbound"
        });
        const nodeId = await api.getExclusiveControl();
        if (nodeId != void 0) {
          ctx.logNode(node.id, {
            message: (nodeId !== 0 ? `Node ${nodeId.toString().padStart(3, "0")}` : `no node`) + ` has exclusive control`,
            direction: "inbound"
          });
        }
      }
    }
  };
  return ProtectionCC2 = _classThis;
})();
function getCCResponseForProtectionCCSet(ctx, sent) {
  if (sent.isSinglecast() && !sent.isEncapsulatedWith(import_core.CommandClasses.Supervision) && ctx.getNode(sent.nodeId)?.supportsCC(import_core.CommandClasses["Application Status"])) {
    return import_ApplicationStatusCC.ApplicationStatusCCRejectedRequest;
  }
}
__name(getCCResponseForProtectionCCSet, "getCCResponseForProtectionCCSet");
let ProtectionCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.Set), (0, import_CommandClassDecorators.expectedCCResponse)(getCCResponseForProtectionCCSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCSet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.local = options.local;
      this.rf = options.rf;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    local;
    rf;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.local & 15,
        (this.rf ?? import_Types.RFProtectionState.Unprotected) & 15
      ]);
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      if (ccVersion < 2 && ctx.getDeviceConfig?.(this.nodeId)?.compat?.encodeCCsUsingTargetVersion) {
        this.payload = this.payload.subarray(0, 1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        local: (0, import_shared.getEnumMemberName)(import_Types.LocalProtectionState, this.local)
      };
      if (this.rf != void 0) {
        message.rf = (0, import_shared.getEnumMemberName)(import_Types.RFProtectionState, this.rf);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ProtectionCCSet2 = _classThis;
})();
let ProtectionCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("local", import_CCValues_generated.ProtectionCCValues.localProtectionState), (0, import_CommandClassDecorators.ccValueProperty)("rf", import_CCValues_generated.ProtectionCCValues.rfProtectionState)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCReport2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.local = options.local;
      this.rf = options.rf;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const local = raw.payload[0] & 15;
      let rf;
      if (raw.payload.length >= 2) {
        rf = raw.payload[1] & 15;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        local,
        rf
      });
    }
    local;
    rf;
    toLogEntry(ctx) {
      const message = {
        local: (0, import_shared.getEnumMemberName)(import_Types.LocalProtectionState, this.local)
      };
      if (this.rf != void 0) {
        message.rf = (0, import_shared.getEnumMemberName)(import_Types.RFProtectionState, this.rf);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ProtectionCCReport2 = _classThis;
})();
let ProtectionCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ProtectionCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCGet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ProtectionCCGet2 = _classThis;
})();
let ProtectionCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportsExclusiveControl", import_CCValues_generated.ProtectionCCValues.supportsExclusiveControl), (0, import_CommandClassDecorators.ccValueProperty)("supportsTimeout", import_CCValues_generated.ProtectionCCValues.supportsTimeout), (0, import_CommandClassDecorators.ccValueProperty)("supportedLocalStates", import_CCValues_generated.ProtectionCCValues.supportedLocalStates), (0, import_CommandClassDecorators.ccValueProperty)("supportedRFStates", import_CCValues_generated.ProtectionCCValues.supportedRFStates)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportsTimeout = options.supportsTimeout;
      this.supportsExclusiveControl = options.supportsExclusiveControl;
      this.supportedLocalStates = options.supportedLocalStates;
      this.supportedRFStates = options.supportedRFStates;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5);
      const supportsTimeout = !!(raw.payload[0] & 1);
      const supportsExclusiveControl = !!(raw.payload[0] & 2);
      const supportedLocalStates = (0, import_core.parseBitMask)(raw.payload.subarray(1, 3), import_Types.LocalProtectionState.Unprotected);
      const supportedRFStates = (0, import_core.parseBitMask)(raw.payload.subarray(3, 5), import_Types.RFProtectionState.Unprotected);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportsTimeout,
        supportsExclusiveControl,
        supportedLocalStates,
        supportedRFStates
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const localStateValue = import_CCValues_generated.ProtectionCCValues.localProtectionState;
      this.setMetadata(ctx, localStateValue, {
        ...localStateValue.meta,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.LocalProtectionState, this.supportedLocalStates)
      });
      const rfStateValue = import_CCValues_generated.ProtectionCCValues.rfProtectionState;
      this.setMetadata(ctx, rfStateValue, {
        ...rfStateValue.meta,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.RFProtectionState, this.supportedRFStates)
      });
      return true;
    }
    supportsExclusiveControl;
    supportsTimeout;
    supportedLocalStates;
    supportedRFStates;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supports exclusive control": this.supportsExclusiveControl,
          "supports timeout": this.supportsTimeout,
          "local protection states": this.supportedLocalStates.map((local) => (0, import_shared.getEnumMemberName)(import_Types.LocalProtectionState, local)).map((str) => `
\xB7 ${str}`).join(""),
          "RF protection states": this.supportedRFStates.map((rf) => (0, import_shared.getEnumMemberName)(import_Types.RFProtectionState, rf)).map((str) => `
\xB7 ${str}`).join("")
        }
      };
    }
  };
  return ProtectionCCSupportedReport2 = _classThis;
})();
let ProtectionCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ProtectionCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ProtectionCCSupportedGet2 = _classThis;
})();
let ProtectionCCExclusiveControlReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.ExclusiveControlReport), (0, import_CommandClassDecorators.ccValueProperty)("exclusiveControlNodeId", import_CCValues_generated.ProtectionCCValues.exclusiveControlNodeId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCExclusiveControlReport2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCExclusiveControlReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCExclusiveControlReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.exclusiveControlNodeId = options.exclusiveControlNodeId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const exclusiveControlNodeId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        exclusiveControlNodeId
      });
    }
    exclusiveControlNodeId;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "exclusive control node id": this.exclusiveControlNodeId
        }
      };
    }
  };
  return ProtectionCCExclusiveControlReport2 = _classThis;
})();
let ProtectionCCExclusiveControlGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.ExclusiveControlGet), (0, import_CommandClassDecorators.expectedCCResponse)(ProtectionCCExclusiveControlReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCExclusiveControlGet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCExclusiveControlGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCExclusiveControlGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ProtectionCCExclusiveControlGet2 = _classThis;
})();
let ProtectionCCExclusiveControlSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.ExclusiveControlSet), (0, import_CommandClassDecorators.expectedCCResponse)(ProtectionCCReport), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCExclusiveControlSet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCExclusiveControlSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCExclusiveControlSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.exclusiveControlNodeId = options.exclusiveControlNodeId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    exclusiveControlNodeId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.exclusiveControlNodeId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "exclusive control node id": this.exclusiveControlNodeId
        }
      };
    }
  };
  return ProtectionCCExclusiveControlSet2 = _classThis;
})();
let ProtectionCCTimeoutReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.TimeoutReport), (0, import_CommandClassDecorators.ccValueProperty)("timeout", import_CCValues_generated.ProtectionCCValues.timeout)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCTimeoutReport2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCTimeoutReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCTimeoutReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.timeout = options.timeout;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const timeout = import_core.Timeout.parse(raw.payload[0]);
      return new this({
        nodeId: ctx.sourceNodeId,
        timeout
      });
    }
    timeout;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { timeout: this.timeout.toString() }
      };
    }
  };
  return ProtectionCCTimeoutReport2 = _classThis;
})();
let ProtectionCCTimeoutGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.TimeoutGet), (0, import_CommandClassDecorators.expectedCCResponse)(ProtectionCCTimeoutReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCTimeoutGet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCTimeoutGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCTimeoutGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ProtectionCCTimeoutGet2 = _classThis;
})();
let ProtectionCCTimeoutSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ProtectionCommand.TimeoutSet), (0, import_CommandClassDecorators.expectedCCResponse)(ProtectionCCReport), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ProtectionCC;
  var ProtectionCCTimeoutSet2 = class extends _classSuper {
    static {
      __name(this, "ProtectionCCTimeoutSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ProtectionCCTimeoutSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.timeout = options.timeout;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    timeout;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.timeout.serialize()]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { timeout: this.timeout.toString() }
      };
    }
  };
  return ProtectionCCTimeoutSet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ProtectionCC,
  ProtectionCCAPI,
  ProtectionCCExclusiveControlGet,
  ProtectionCCExclusiveControlReport,
  ProtectionCCExclusiveControlSet,
  ProtectionCCGet,
  ProtectionCCReport,
  ProtectionCCSet,
  ProtectionCCSupportedGet,
  ProtectionCCSupportedReport,
  ProtectionCCTimeoutGet,
  ProtectionCCTimeoutReport,
  ProtectionCCTimeoutSet,
  ProtectionCCValues
});
//# sourceMappingURL=ProtectionCC.js.map
