"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatSetbackCC_exports = {};
__export(ThermostatSetbackCC_exports, {
  ThermostatSetbackCC: () => ThermostatSetbackCC,
  ThermostatSetbackCCAPI: () => ThermostatSetbackCCAPI,
  ThermostatSetbackCCGet: () => ThermostatSetbackCCGet,
  ThermostatSetbackCCReport: () => ThermostatSetbackCCReport,
  ThermostatSetbackCCSet: () => ThermostatSetbackCCSet
});
module.exports = __toCommonJS(ThermostatSetbackCC_exports);
var __validateArgs = __toESM(require("./ThermostatSetbackCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var import_serializers = require("../lib/serializers.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ThermostatSetbackCCAPI_set } = __validateArgs;
let ThermostatSetbackCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Thermostat Setback"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var ThermostatSetbackCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetbackCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_ThermostatSetbackCCAPI_set()];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetbackCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ThermostatSetbackCommand.Get:
          return this.isSinglecast();
        case import_Types.ThermostatSetbackCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "setbackType":
          case "setbackState":
            return (await this.get())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ThermostatSetbackCommand, import_Types.ThermostatSetbackCommand.Get);
      const cc = new ThermostatSetbackCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["setbackType", "setbackState"]);
      }
    }
    async set(setbackType, setbackState) {
      this.assertSupportsCommand(import_Types.ThermostatSetbackCommand, import_Types.ThermostatSetbackCommand.Get);
      const cc = new ThermostatSetbackCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setbackType,
        setbackState
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ThermostatSetbackCCAPI2 = _classThis;
})();
let ThermostatSetbackCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Thermostat Setback"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ThermostatSetbackCC2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetbackCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetbackCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Setback"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying the current thermostat state...",
        direction: "outbound"
      });
      const setbackResp = await api.get();
      if (setbackResp) {
        const logMessage = `received current state:
setback type:  ${(0, import_shared.getEnumMemberName)(import_Types.SetbackType, setbackResp.setbackType)}
setback state: ${setbackResp.setbackState}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
    }
  };
  return ThermostatSetbackCC2 = _classThis;
})();
let ThermostatSetbackCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetbackCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetbackCC;
  var ThermostatSetbackCCSet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetbackCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetbackCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setbackType = options.setbackType;
      this.setbackState = options.setbackState;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const setbackType = raw.payload[0] & 3;
      const setbackState = (0, import_serializers.decodeSetbackState)(raw.payload, 1) || raw.payload.readInt8(1);
      return new this({
        nodeId: ctx.sourceNodeId,
        setbackType,
        setbackState
      });
    }
    setbackType;
    /** The offset from the setpoint in 0.1 Kelvin or a special mode */
    setbackState;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        [this.setbackType & 3],
        (0, import_serializers.encodeSetbackState)(this.setbackState)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setback type": (0, import_shared.getEnumMemberName)(import_Types.SetbackType, this.setbackType),
          "setback state": typeof this.setbackState === "number" ? `${this.setbackState} K` : this.setbackState
        }
      };
    }
  };
  return ThermostatSetbackCCSet2 = _classThis;
})();
let ThermostatSetbackCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetbackCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetbackCC;
  var ThermostatSetbackCCReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetbackCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetbackCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setbackType = options.setbackType;
      this.setbackState = options.setbackState;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const setbackType = raw.payload[0] & 3;
      const setbackState = (0, import_serializers.decodeSetbackState)(raw.payload, 1) || raw.payload.readInt8(1);
      return new this({
        nodeId: ctx.sourceNodeId,
        setbackType,
        setbackState
      });
    }
    setbackType;
    /** The offset from the setpoint in 0.1 Kelvin or a special mode */
    setbackState;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        [this.setbackType & 3],
        (0, import_serializers.encodeSetbackState)(this.setbackState)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setback type": (0, import_shared.getEnumMemberName)(import_Types.SetbackType, this.setbackType),
          "setback state": typeof this.setbackState === "number" ? `${this.setbackState} K` : this.setbackState
        }
      };
    }
  };
  return ThermostatSetbackCCReport2 = _classThis;
})();
let ThermostatSetbackCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetbackCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatSetbackCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetbackCC;
  var ThermostatSetbackCCGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetbackCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetbackCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ThermostatSetbackCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatSetbackCC,
  ThermostatSetbackCCAPI,
  ThermostatSetbackCCGet,
  ThermostatSetbackCCReport,
  ThermostatSetbackCCSet
});
//# sourceMappingURL=ThermostatSetbackCC.js.map
