"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatSetpointCC_exports = {};
__export(ThermostatSetpointCC_exports, {
  ThermostatSetpointCC: () => ThermostatSetpointCC,
  ThermostatSetpointCCAPI: () => ThermostatSetpointCCAPI,
  ThermostatSetpointCCCapabilitiesGet: () => ThermostatSetpointCCCapabilitiesGet,
  ThermostatSetpointCCCapabilitiesReport: () => ThermostatSetpointCCCapabilitiesReport,
  ThermostatSetpointCCGet: () => ThermostatSetpointCCGet,
  ThermostatSetpointCCReport: () => ThermostatSetpointCCReport,
  ThermostatSetpointCCSet: () => ThermostatSetpointCCSet,
  ThermostatSetpointCCSupportedGet: () => ThermostatSetpointCCSupportedGet,
  ThermostatSetpointCCSupportedReport: () => ThermostatSetpointCCSupportedReport,
  ThermostatSetpointCCValues: () => import_CCValues_generated.ThermostatSetpointCCValues
});
module.exports = __toCommonJS(ThermostatSetpointCC_exports);
var __validateArgs = __toESM(require("./ThermostatSetpointCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ThermostatSetpointCCAPI_get, validateArgs_ThermostatSetpointCCAPI_set, validateArgs_ThermostatSetpointCCAPI_getCapabilities } = __validateArgs;
const thermostatSetpointTypeMap = [
  0,
  1,
  2,
  7,
  8,
  9,
  10,
  11,
  12,
  13,
  14,
  15
];
function getScale(scale) {
  return (0, import_core.getNamedScale)("temperature", scale) ?? (0, import_core.getUnknownScale)(scale);
}
__name(getScale, "getScale");
function getSetpointUnit(scale) {
  return getScale(scale).unit ?? "";
}
__name(getSetpointUnit, "getSetpointUnit");
let ThermostatSetpointCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Thermostat Setpoint"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _set_decorators;
  let _getCapabilities_decorators;
  var ThermostatSetpointCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_ThermostatSetpointCCAPI_get()];
      _set_decorators = [validateArgs_ThermostatSetpointCCAPI_set()];
      _getCapabilities_decorators = [validateArgs_ThermostatSetpointCCAPI_getCapabilities()];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getCapabilities_decorators, { kind: "method", name: "getCapabilities", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getCapabilities" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getCapabilities, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ThermostatSetpointCommand.Get:
        case import_Types.ThermostatSetpointCommand.SupportedGet:
          return this.isSinglecast();
        case import_Types.ThermostatSetpointCommand.Set:
          return true;
        // This is mandatory
        case import_Types.ThermostatSetpointCommand.CapabilitiesGet:
          return this.version >= 3 && this.isSinglecast();
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value) {
        if (property !== "setpoint") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof propertyKey !== "number") {
          throw new import_core.ZWaveError(`${import_core.CommandClasses[this.ccId]}: "${property}" must be further specified by a numeric property key`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        const preferredScale = this.tryGetValueDB()?.getValue(import_CCValues_generated.ThermostatSetpointCCValues.setpointScale(propertyKey).endpoint(this.endpoint.index));
        const result = await this.set(propertyKey, value, preferredScale ?? 0);
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property, propertyKey }, value);
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "setpoint":
            if (typeof propertyKey !== "number") {
              throw new import_core.ZWaveError(`${import_core.CommandClasses[this.ccId]}: "${property}" must be further specified by a numeric property key`, import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            return (await this.get(propertyKey))?.value;
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async get(setpointType) {
      this.assertSupportsCommand(import_Types.ThermostatSetpointCommand, import_Types.ThermostatSetpointCommand.Get);
      const cc = new ThermostatSetpointCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (!response)
        return;
      if (response.type !== import_Types.ThermostatSetpointType["N/A"]) {
        const scale = getScale(response.scale);
        return {
          value: response.value,
          scale
        };
      }
    }
    async set(setpointType, value, scale) {
      this.assertSupportsCommand(import_Types.ThermostatSetpointCommand, import_Types.ThermostatSetpointCommand.Set);
      const cc = new ThermostatSetpointCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType,
        value,
        scale
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getCapabilities(setpointType) {
      this.assertSupportsCommand(import_Types.ThermostatSetpointCommand, import_Types.ThermostatSetpointCommand.CapabilitiesGet);
      const cc = new ThermostatSetpointCCCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "minValue",
          "maxValue",
          "minValueScale",
          "maxValueScale"
        ]);
      }
    }
    /**
     * Requests the supported setpoint types from the node. Due to inconsistencies it is NOT recommended
     * to use this method on nodes with CC versions 1 and 2. Instead rely on the information determined
     * during node interview.
     */
    async getSupportedSetpointTypes() {
      this.assertSupportsCommand(import_Types.ThermostatSetpointCommand, import_Types.ThermostatSetpointCommand.SupportedGet);
      const cc = new ThermostatSetpointCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedSetpointTypes;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ThermostatSetpointCCAPI2 = _classThis;
})();
let ThermostatSetpointCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Thermostat Setpoint"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ThermostatSetpointCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ThermostatSetpointCC2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if (property === "setpoint") {
        return (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, propertyKey);
      } else {
        return super.translatePropertyKey(ctx, property, propertyKey);
      }
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Setpoint"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (api.version <= 2) {
        await api.getSupportedSetpointTypes();
        const supportedSetpointTypes = [];
        for (let type = import_Types.ThermostatSetpointType.Heating; type <= import_Types.ThermostatSetpointType["Full Power"]; type++) {
          const setpointName = (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, type);
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `querying current value of setpoint ${setpointName}...`,
            direction: "outbound"
          });
          const setpoint = await api.get(type);
          let logMessage;
          if (setpoint) {
            supportedSetpointTypes.push(type);
            logMessage = `received current value of setpoint ${setpointName}: ${setpoint.value} ${setpoint.scale.unit ?? ""}`;
          } else {
            logMessage = `setpoint ${setpointName} is not supported`;
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
        this.setValue(ctx, import_CCValues_generated.ThermostatSetpointCCValues.supportedSetpointTypes, supportedSetpointTypes);
      } else {
        let setpointTypes = [];
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "retrieving supported setpoint types...",
          direction: "outbound"
        });
        const resp = await api.getSupportedSetpointTypes();
        if (resp) {
          setpointTypes = [...resp];
          const logMessage = "received supported setpoint types:\n" + setpointTypes.map((type) => (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, type)).map((name) => `\xB7 ${name}`).join("\n");
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "Querying supported setpoint types timed out, skipping interview...",
            level: "warn"
          });
          return;
        }
        for (const type of setpointTypes) {
          const setpointName = (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, type);
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `retrieving capabilities for setpoint ${setpointName}...`,
            direction: "outbound"
          });
          const setpointCaps = await api.getCapabilities(type);
          if (setpointCaps) {
            const minValueUnit = getSetpointUnit(setpointCaps.minValueScale);
            const maxValueUnit = getSetpointUnit(setpointCaps.maxValueScale);
            const logMessage = `received capabilities for setpoint ${setpointName}:
minimum value: ${setpointCaps.minValue} ${minValueUnit}
maximum value: ${setpointCaps.maxValue} ${maxValueUnit}`;
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: logMessage,
              direction: "inbound"
            });
          }
        }
        await this.refreshValues(ctx);
      }
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Setpoint"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const setpointTypes = this.getValue(ctx, import_CCValues_generated.ThermostatSetpointCCValues.supportedSetpointTypes) ?? [];
      for (const type of setpointTypes) {
        const setpointName = (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, type);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying current value of setpoint ${setpointName}...`,
          direction: "outbound"
        });
        const setpoint = await api.get(type);
        if (setpoint) {
          const logMessage = `received current value of setpoint ${setpointName}: ${setpoint.value} ${setpoint.scale.unit ?? ""}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
    }
  };
  return ThermostatSetpointCC2 = _classThis;
})();
let ThermostatSetpointCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCSet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
      this.value = options.value;
      this.scale = options.scale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const setpointType = raw.payload[0] & 15;
      const { value, scale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        setpointType,
        value,
        scale
      });
    }
    setpointType;
    value;
    scale;
    serialize(ctx) {
      const override = ctx.getDeviceConfig?.(this.nodeId)?.compat?.overrideFloatEncoding;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.setpointType & 15]),
        (0, import_core.encodeFloatWithScale)(this.value, this.scale, override)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const scale = getScale(this.scale);
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, this.setpointType),
          value: `${this.value} ${scale.unit}`
        }
      };
    }
  };
  return ThermostatSetpointCCSet2 = _classThis;
})();
let ThermostatSetpointCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.type = options.type;
      this.value = options.value;
      this.scale = options.scale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const type = raw.payload[0] & 15;
      if (type === 0) {
        return new this({
          nodeId: ctx.sourceNodeId,
          type,
          value: 0,
          scale: 0
        });
      }
      const { value, scale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        type,
        value,
        scale
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const scale = getScale(this.scale);
      const setpointValue = import_CCValues_generated.ThermostatSetpointCCValues.setpoint(this.type);
      const existingMetadata = this.getMetadata(ctx, setpointValue);
      if (existingMetadata?.unit !== scale.unit) {
        this.setMetadata(ctx, setpointValue, {
          ...existingMetadata ?? setpointValue.meta,
          unit: scale.unit
        });
      }
      this.setValue(ctx, setpointValue, this.value);
      this.setValue(ctx, import_CCValues_generated.ThermostatSetpointCCValues.setpointScale(this.type), scale.key);
      return true;
    }
    type;
    scale;
    value;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.type & 15]),
        (0, import_core.encodeFloatWithScale)(this.value, this.scale)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const scale = getScale(this.scale);
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, this.type),
          value: `${this.value} ${scale.unit}`
        }
      };
    }
  };
  return ThermostatSetpointCCReport2 = _classThis;
})();
function testResponseForThermostatSetpointGet(sent, received) {
  return received.type === sent.setpointType;
}
__name(testResponseForThermostatSetpointGet, "testResponseForThermostatSetpointGet");
let ThermostatSetpointCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatSetpointCCReport, testResponseForThermostatSetpointGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const setpointType = raw.payload[0] & 15;
      return new this({
        nodeId: ctx.sourceNodeId,
        setpointType
      });
    }
    setpointType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.setpointType & 15]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, this.setpointType)
        }
      };
    }
  };
  return ThermostatSetpointCCGet2 = _classThis;
})();
let ThermostatSetpointCCCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.CapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.type = options.type;
      this.minValue = options.minValue;
      this.minValueScale = options.minValueScale;
      this.maxValue = options.maxValue;
      this.maxValueScale = options.maxValueScale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const type = raw.payload[0];
      const { value: minValue, scale: minValueScale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      const { value: maxValue, scale: maxValueScale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1 + bytesRead));
      return new this({
        nodeId: ctx.sourceNodeId,
        type,
        minValue,
        minValueScale,
        maxValue,
        maxValueScale
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const setpointValue = import_CCValues_generated.ThermostatSetpointCCValues.setpoint(this.type);
      this.setMetadata(ctx, setpointValue, {
        ...setpointValue.meta,
        min: this.minValue,
        max: this.maxValue,
        unit: getSetpointUnit(this.minValueScale) || getSetpointUnit(this.maxValueScale)
      });
      return true;
    }
    type;
    minValue;
    maxValue;
    minValueScale;
    maxValueScale;
    serialize(ctx) {
      const min = (0, import_core.encodeFloatWithScale)(this.minValue, this.minValueScale);
      const max = (0, import_core.encodeFloatWithScale)(this.maxValue, this.maxValueScale);
      this.payload = import_shared.Bytes.concat([import_shared.Bytes.from([this.type]), min, max]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const minValueScale = getScale(this.minValueScale);
      const maxValueScale = getScale(this.maxValueScale);
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, this.type),
          "min value": `${this.minValue} ${minValueScale.unit}`,
          "max value": `${this.maxValue} ${maxValueScale.unit}`
        }
      };
    }
  };
  return ThermostatSetpointCCCapabilitiesReport2 = _classThis;
})();
let ThermostatSetpointCCCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.CapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatSetpointCCCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const setpointType = raw.payload[0] & 15;
      return new this({
        nodeId: ctx.sourceNodeId,
        setpointType
      });
    }
    setpointType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.setpointType & 15]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, this.setpointType)
        }
      };
    }
  };
  return ThermostatSetpointCCCapabilitiesGet2 = _classThis;
})();
let ThermostatSetpointCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedSetpointTypes", import_CCValues_generated.ThermostatSetpointCCValues.supportedSetpointTypes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.supportedSetpointTypes.length === 0) {
        throw new import_core.ZWaveError(`At least one setpoint type must be supported`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.supportedSetpointTypes = options.supportedSetpointTypes;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const bitMask = raw.payload;
      const supported = (0, import_core.parseBitMask)(bitMask, import_Types.ThermostatSetpointType["N/A"]);
      const supportedSetpointTypes = supported.map((i) => thermostatSetpointTypeMap[i]);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedSetpointTypes
      });
    }
    supportedSetpointTypes;
    serialize(ctx) {
      this.payload = (0, import_core.encodeBitMask)(
        // Encode as interpretation A
        this.supportedSetpointTypes.map((t) => thermostatSetpointTypeMap.indexOf(t)).filter((t) => t !== -1),
        void 0,
        import_Types.ThermostatSetpointType["N/A"]
      );
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported setpoint types": this.supportedSetpointTypes.map((t) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ThermostatSetpointType, t)}`).join("")
        }
      };
    }
  };
  return ThermostatSetpointCCSupportedReport2 = _classThis;
})();
let ThermostatSetpointCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatSetpointCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatSetpointCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatSetpointCC;
  var ThermostatSetpointCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatSetpointCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatSetpointCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ThermostatSetpointCCSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatSetpointCC,
  ThermostatSetpointCCAPI,
  ThermostatSetpointCCCapabilitiesGet,
  ThermostatSetpointCCCapabilitiesReport,
  ThermostatSetpointCCGet,
  ThermostatSetpointCCReport,
  ThermostatSetpointCCSet,
  ThermostatSetpointCCSupportedGet,
  ThermostatSetpointCCSupportedReport,
  ThermostatSetpointCCValues
});
//# sourceMappingURL=ThermostatSetpointCC.js.map
