"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TimeCC_exports = {};
__export(TimeCC_exports, {
  TimeCC: () => TimeCC,
  TimeCCAPI: () => TimeCCAPI,
  TimeCCDateGet: () => TimeCCDateGet,
  TimeCCDateReport: () => TimeCCDateReport,
  TimeCCTimeGet: () => TimeCCTimeGet,
  TimeCCTimeOffsetGet: () => TimeCCTimeOffsetGet,
  TimeCCTimeOffsetReport: () => TimeCCTimeOffsetReport,
  TimeCCTimeOffsetSet: () => TimeCCTimeOffsetSet,
  TimeCCTimeReport: () => TimeCCTimeReport
});
module.exports = __toCommonJS(TimeCC_exports);
var __validateArgs = __toESM(require("./TimeCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var import_serializers = require("../lib/serializers.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_TimeCCAPI_reportTime, validateArgs_TimeCCAPI_reportDate, validateArgs_TimeCCAPI_setTimezone, validateArgs_TimeCCAPI_reportTimezone } = __validateArgs;
let TimeCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Time)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _reportTime_decorators;
  let _reportDate_decorators;
  let _setTimezone_decorators;
  let _reportTimezone_decorators;
  var TimeCCAPI2 = class extends _classSuper {
    static {
      __name(this, "TimeCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _reportTime_decorators = [validateArgs_TimeCCAPI_reportTime()];
      _reportDate_decorators = [validateArgs_TimeCCAPI_reportDate()];
      _setTimezone_decorators = [validateArgs_TimeCCAPI_setTimezone()];
      _reportTimezone_decorators = [validateArgs_TimeCCAPI_reportTimezone()];
      __esDecorate(this, null, _reportTime_decorators, { kind: "method", name: "reportTime", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportTime" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportTime, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportDate_decorators, { kind: "method", name: "reportDate", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportDate" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportDate, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setTimezone_decorators, { kind: "method", name: "setTimezone", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setTimezone" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setTimezone, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reportTimezone_decorators, { kind: "method", name: "reportTimezone", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reportTimezone" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reportTimezone, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.TimeCommand.TimeGet:
        case import_Types.TimeCommand.TimeReport:
        case import_Types.TimeCommand.DateGet:
        case import_Types.TimeCommand.DateReport:
          return this.isSinglecast();
        // "mandatory"
        case import_Types.TimeCommand.TimeOffsetGet:
        case import_Types.TimeCommand.TimeOffsetReport:
          return this.version >= 2 && this.isSinglecast();
        case import_Types.TimeCommand.TimeOffsetSet:
          return this.version >= 2;
      }
      return super.supportsCommand(cmd);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getTime() {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.TimeGet);
      const cc = new TimeCCTimeGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["hour", "minute", "second"]);
      }
    }
    async reportTime(hour, minute, second) {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.TimeReport);
      const cc = new TimeCCTimeReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        hour,
        minute,
        second
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getDate() {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.DateGet);
      const cc = new TimeCCDateGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["day", "month", "year"]);
      }
    }
    async reportDate(year, month, day) {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.DateReport);
      const cc = new TimeCCDateReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        year,
        month,
        day
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async setTimezone(timezone) {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.TimeOffsetSet);
      const cc = new TimeCCTimeOffsetSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        standardOffset: timezone.standardOffset,
        dstOffset: timezone.dstOffset,
        dstStart: timezone.startDate,
        dstEnd: timezone.endDate
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getTimezone() {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.TimeOffsetGet);
      const cc = new TimeCCTimeOffsetGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return {
          standardOffset: response.standardOffset,
          dstOffset: response.dstOffset,
          startDate: response.dstStartDate,
          endDate: response.dstEndDate
        };
      }
    }
    async reportTimezone(timezone) {
      this.assertSupportsCommand(import_Types.TimeCommand, import_Types.TimeCommand.TimeOffsetReport);
      const cc = new TimeCCTimeOffsetReport({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        standardOffset: timezone.standardOffset,
        dstOffset: timezone.dstOffset,
        dstStart: timezone.startDate,
        dstEnd: timezone.endDate
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return TimeCCAPI2 = _classThis;
})();
let TimeCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Time), (0, import_CommandClassDecorators.implementedVersion)(2)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var TimeCC2 = class extends _classSuper {
    static {
      __name(this, "TimeCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Time, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (api.version >= 2) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "setting timezone information...",
          direction: "outbound"
        });
        const timezone = (0, import_core.getDSTInfo)();
        await api.setTimezone(timezone);
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return TimeCC2 = _classThis;
})();
let TimeCCTimeReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.TimeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCTimeReport2 = class extends _classSuper {
    static {
      __name(this, "TimeCCTimeReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCTimeReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.hour = options.hour;
      this.minute = options.minute;
      this.second = options.second;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const hour = raw.payload[0] & 31;
      const minute = raw.payload[1];
      const second = raw.payload[2];
      (0, import_core.validatePayload)(hour >= 0, hour <= 23, minute >= 0, minute <= 59, second >= 0, second <= 59);
      return new this({
        nodeId: ctx.sourceNodeId,
        hour,
        minute,
        second
      });
    }
    hour;
    minute;
    second;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.hour & 31,
        this.minute,
        this.second
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          time: `${this.hour.toString().padStart(2, "0")}:${this.minute.toString().padStart(2, "0")}:${this.second.toString().padStart(2, "0")}`
        }
      };
    }
  };
  return TimeCCTimeReport2 = _classThis;
})();
let TimeCCTimeGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.TimeGet), (0, import_CommandClassDecorators.expectedCCResponse)(TimeCCTimeReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCTimeGet2 = class extends _classSuper {
    static {
      __name(this, "TimeCCTimeGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCTimeGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return TimeCCTimeGet2 = _classThis;
})();
let TimeCCDateReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.DateReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCDateReport2 = class extends _classSuper {
    static {
      __name(this, "TimeCCDateReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCDateReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.year = options.year;
      this.month = options.month;
      this.day = options.day;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const year = raw.payload.readUInt16BE(0);
      const month = raw.payload[2];
      const day = raw.payload[3];
      return new this({
        nodeId: ctx.sourceNodeId,
        year,
        month,
        day
      });
    }
    year;
    month;
    day;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        // 2 bytes placeholder for year
        0,
        0,
        this.month,
        this.day
      ]);
      this.payload.writeUInt16BE(this.year, 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          date: `${this.year.toString().padStart(4, "0")}-${this.month.toString().padStart(2, "0")}-${this.day.toString().padStart(2, "0")}`
        }
      };
    }
  };
  return TimeCCDateReport2 = _classThis;
})();
let TimeCCDateGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.DateGet), (0, import_CommandClassDecorators.expectedCCResponse)(TimeCCDateReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCDateGet2 = class extends _classSuper {
    static {
      __name(this, "TimeCCDateGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCDateGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return TimeCCDateGet2 = _classThis;
})();
let TimeCCTimeOffsetSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.TimeOffsetSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCTimeOffsetSet2 = class extends _classSuper {
    static {
      __name(this, "TimeCCTimeOffsetSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCTimeOffsetSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.standardOffset = options.standardOffset;
      this.dstOffset = options.dstOffset;
      this.dstStartDate = options.dstStart;
      this.dstEndDate = options.dstEnd;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    standardOffset;
    dstOffset;
    dstStartDate;
    dstEndDate;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        (0, import_serializers.encodeTimezone)({
          standardOffset: this.standardOffset,
          dstOffset: this.dstOffset
        }),
        import_shared.Bytes.from([
          this.dstStartDate.getUTCMonth() + 1,
          this.dstStartDate.getUTCDate(),
          this.dstStartDate.getUTCHours(),
          this.dstEndDate.getUTCMonth() + 1,
          this.dstEndDate.getUTCDate(),
          this.dstEndDate.getUTCHours()
        ])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "standard time offset": `${this.standardOffset} minutes`,
          "DST offset": `${this.dstOffset} minutes`,
          "DST start date": (0, import_core.formatDate)(this.dstStartDate, "YYYY-MM-DD"),
          "DST end date": (0, import_core.formatDate)(this.dstEndDate, "YYYY-MM-DD")
        }
      };
    }
  };
  return TimeCCTimeOffsetSet2 = _classThis;
})();
let TimeCCTimeOffsetReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.TimeOffsetReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCTimeOffsetReport2 = class extends _classSuper {
    static {
      __name(this, "TimeCCTimeOffsetReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCTimeOffsetReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.standardOffset = options.standardOffset;
      this.dstOffset = options.dstOffset;
      this.dstStartDate = options.dstStart;
      this.dstEndDate = options.dstEnd;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 9);
      const { standardOffset, dstOffset } = (0, import_serializers.parseTimezone)(raw.payload);
      const currentYear = (/* @__PURE__ */ new Date()).getUTCFullYear();
      const dstStartDate = new Date(Date.UTC(currentYear, raw.payload[3] - 1, raw.payload[4], raw.payload[5]));
      const dstEndDate = new Date(Date.UTC(currentYear, raw.payload[6] - 1, raw.payload[7], raw.payload[8]));
      return new this({
        nodeId: ctx.sourceNodeId,
        standardOffset,
        dstOffset,
        dstStart: dstStartDate,
        dstEnd: dstEndDate
      });
    }
    standardOffset;
    dstOffset;
    dstStartDate;
    dstEndDate;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        (0, import_serializers.encodeTimezone)({
          standardOffset: this.standardOffset,
          dstOffset: this.dstOffset
        }),
        import_shared.Bytes.from([
          this.dstStartDate.getUTCMonth() + 1,
          this.dstStartDate.getUTCDate(),
          this.dstStartDate.getUTCHours(),
          this.dstEndDate.getUTCMonth() + 1,
          this.dstEndDate.getUTCDate(),
          this.dstEndDate.getUTCHours()
        ])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "standard time offset": `${this.standardOffset} minutes`,
          "DST offset": `${this.dstOffset} minutes`,
          "DST start date": (0, import_core.formatDate)(this.dstStartDate, "YYYY-MM-DD"),
          "DST end date": (0, import_core.formatDate)(this.dstEndDate, "YYYY-MM-DD")
        }
      };
    }
  };
  return TimeCCTimeOffsetReport2 = _classThis;
})();
let TimeCCTimeOffsetGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.TimeCommand.TimeOffsetGet), (0, import_CommandClassDecorators.expectedCCResponse)(TimeCCTimeOffsetReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = TimeCC;
  var TimeCCTimeOffsetGet2 = class extends _classSuper {
    static {
      __name(this, "TimeCCTimeOffsetGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      TimeCCTimeOffsetGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return TimeCCTimeOffsetGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TimeCC,
  TimeCCAPI,
  TimeCCDateGet,
  TimeCCDateReport,
  TimeCCTimeGet,
  TimeCCTimeOffsetGet,
  TimeCCTimeOffsetReport,
  TimeCCTimeOffsetSet,
  TimeCCTimeReport
});
//# sourceMappingURL=TimeCC.js.map
