"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWaveProtocolCC_exports = {};
__export(ZWaveProtocolCC_exports, {
  ZWaveProtocolCC: () => ZWaveProtocolCC,
  ZWaveProtocolCCAcceptLost: () => ZWaveProtocolCCAcceptLost,
  ZWaveProtocolCCAssignIDs: () => ZWaveProtocolCCAssignIDs,
  ZWaveProtocolCCAssignReturnRoute: () => ZWaveProtocolCCAssignReturnRoute,
  ZWaveProtocolCCAssignReturnRoutePriority: () => ZWaveProtocolCCAssignReturnRoutePriority,
  ZWaveProtocolCCAssignSUCReturnRoute: () => ZWaveProtocolCCAssignSUCReturnRoute,
  ZWaveProtocolCCAssignSUCReturnRoutePriority: () => ZWaveProtocolCCAssignSUCReturnRoutePriority,
  ZWaveProtocolCCAutomaticControllerUpdateStart: () => ZWaveProtocolCCAutomaticControllerUpdateStart,
  ZWaveProtocolCCCommandComplete: () => ZWaveProtocolCCCommandComplete,
  ZWaveProtocolCCExcludeRequest: () => ZWaveProtocolCCExcludeRequest,
  ZWaveProtocolCCFindNodesInRange: () => ZWaveProtocolCCFindNodesInRange,
  ZWaveProtocolCCGetNodesInRange: () => ZWaveProtocolCCGetNodesInRange,
  ZWaveProtocolCCLost: () => ZWaveProtocolCCLost,
  ZWaveProtocolCCNOPPower: () => ZWaveProtocolCCNOPPower,
  ZWaveProtocolCCNewNodeRegistered: () => ZWaveProtocolCCNewNodeRegistered,
  ZWaveProtocolCCNewRangeRegistered: () => ZWaveProtocolCCNewRangeRegistered,
  ZWaveProtocolCCNodeInformationFrame: () => ZWaveProtocolCCNodeInformationFrame,
  ZWaveProtocolCCNodesExist: () => ZWaveProtocolCCNodesExist,
  ZWaveProtocolCCNodesExistReply: () => ZWaveProtocolCCNodesExistReply,
  ZWaveProtocolCCRangeInfo: () => ZWaveProtocolCCRangeInfo,
  ZWaveProtocolCCRequestNodeInformationFrame: () => ZWaveProtocolCCRequestNodeInformationFrame,
  ZWaveProtocolCCReserveNodeIDs: () => ZWaveProtocolCCReserveNodeIDs,
  ZWaveProtocolCCReservedIDs: () => ZWaveProtocolCCReservedIDs,
  ZWaveProtocolCCSUCNodeID: () => ZWaveProtocolCCSUCNodeID,
  ZWaveProtocolCCSetNWIMode: () => ZWaveProtocolCCSetNWIMode,
  ZWaveProtocolCCSetSUC: () => ZWaveProtocolCCSetSUC,
  ZWaveProtocolCCSetSUCAck: () => ZWaveProtocolCCSetSUCAck,
  ZWaveProtocolCCSmartStartIncludedNodeInformation: () => ZWaveProtocolCCSmartStartIncludedNodeInformation,
  ZWaveProtocolCCSmartStartInclusionRequest: () => ZWaveProtocolCCSmartStartInclusionRequest,
  ZWaveProtocolCCSmartStartPrime: () => ZWaveProtocolCCSmartStartPrime,
  ZWaveProtocolCCStaticRouteRequest: () => ZWaveProtocolCCStaticRouteRequest,
  ZWaveProtocolCCTransferEnd: () => ZWaveProtocolCCTransferEnd,
  ZWaveProtocolCCTransferNewPrimaryControllerComplete: () => ZWaveProtocolCCTransferNewPrimaryControllerComplete,
  ZWaveProtocolCCTransferNodeInformation: () => ZWaveProtocolCCTransferNodeInformation,
  ZWaveProtocolCCTransferPresentation: () => ZWaveProtocolCCTransferPresentation,
  ZWaveProtocolCCTransferRangeInformation: () => ZWaveProtocolCCTransferRangeInformation
});
module.exports = __toCommonJS(ZWaveProtocolCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Types = require("../lib/_Types.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var DataRateBitmask;
(function(DataRateBitmask2) {
  DataRateBitmask2[DataRateBitmask2["9k6"] = 1] = "9k6";
  DataRateBitmask2[DataRateBitmask2["40k"] = 2] = "40k";
  DataRateBitmask2[DataRateBitmask2["100k"] = 4] = "100k";
})(DataRateBitmask || (DataRateBitmask = {}));
function dataRate2Bitmask(dataRate) {
  return dataRate === import_core.ZWaveDataRate["100k"] ? DataRateBitmask["100k"] : dataRate === import_core.ZWaveDataRate["40k"] ? DataRateBitmask["40k"] : DataRateBitmask["9k6"];
}
__name(dataRate2Bitmask, "dataRate2Bitmask");
function bitmask2DataRate(mask) {
  return mask === DataRateBitmask["100k"] ? import_core.ZWaveDataRate["100k"] : mask === DataRateBitmask["40k"] ? import_core.ZWaveDataRate["40k"] : import_core.ZWaveDataRate["9k6"];
}
__name(bitmask2DataRate, "bitmask2DataRate");
let ZWaveProtocolCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Z-Wave Protocol"]), (0, import_CommandClassDecorators.implementedVersion)(1)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ZWaveProtocolCC2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCC2 = _classThis;
})();
let ZWaveProtocolCCNodeInformationFrame = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.NodeInformationFrame)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCNodeInformationFrame2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCNodeInformationFrame");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCNodeInformationFrame2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.basicDeviceClass = options.basicDeviceClass;
      this.genericDeviceClass = options.genericDeviceClass;
      this.specificDeviceClass = options.specificDeviceClass;
      this.isListening = options.isListening;
      this.isFrequentListening = options.isFrequentListening;
      this.isRouting = options.isRouting;
      this.supportedDataRates = options.supportedDataRates;
      this.protocolVersion = options.protocolVersion;
      this.optionalFunctionality = options.optionalFunctionality;
      this.nodeType = options.nodeType;
      this.supportsSecurity = options.supportsSecurity;
      this.supportsBeaming = options.supportsBeaming;
      this.supportedCCs = options.supportedCCs;
    }
    static from(raw, ctx) {
      const nif = (0, import_core.parseNodeInformationFrame)(raw.payload);
      return new this({
        nodeId: ctx.sourceNodeId,
        ...nif
      });
    }
    basicDeviceClass;
    genericDeviceClass;
    specificDeviceClass;
    isListening;
    isFrequentListening;
    isRouting;
    supportedDataRates;
    protocolVersion;
    optionalFunctionality;
    nodeType;
    supportsSecurity;
    supportsBeaming;
    supportedCCs;
    serialize(ctx) {
      this.payload = (0, import_core.encodeNodeInformationFrame)(this);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCNodeInformationFrame2 = _classThis;
})();
let ZWaveProtocolCCRequestNodeInformationFrame = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.RequestNodeInformationFrame), (0, import_CommandClassDecorators.expectedCCResponse)(ZWaveProtocolCCNodeInformationFrame)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCRequestNodeInformationFrame2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCRequestNodeInformationFrame");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCRequestNodeInformationFrame2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCRequestNodeInformationFrame2 = _classThis;
})();
let ZWaveProtocolCCAssignIDs = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AssignIDs)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCAssignIDs2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAssignIDs");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAssignIDs2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.assignedNodeId = options.assignedNodeId;
      this.homeId = options.homeId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5);
      const assignedNodeId = raw.payload[0];
      const homeId = raw.payload.readUInt32BE(1);
      return new this({
        nodeId: ctx.sourceNodeId,
        assignedNodeId,
        homeId
      });
    }
    assignedNodeId;
    homeId;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(5);
      this.payload[0] = this.assignedNodeId;
      this.payload.writeUInt32BE(this.homeId, 1);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCAssignIDs2 = _classThis;
})();
let ZWaveProtocolCCFindNodesInRange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.FindNodesInRange)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCFindNodesInRange2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCFindNodesInRange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCFindNodesInRange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.candidateNodeIds = options.candidateNodeIds;
      this.wakeUpTime = options.wakeUpTime;
      this.dataRate = options.dataRate ?? import_core.ZWaveDataRate["9k6"];
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const speedPresent = raw.payload[0] & 128;
      const bitmaskLength = raw.payload[0] & 31;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + bitmaskLength);
      const candidateNodeIds = (0, import_core.parseBitMask)(raw.payload.subarray(1, 1 + bitmaskLength));
      const rest = raw.payload.subarray(1 + bitmaskLength);
      let dataRate;
      let wakeUpTime;
      if (speedPresent) {
        (0, import_core.validatePayload)(rest.length >= 1);
        if (rest.length === 1) {
          dataRate = rest[0] & 7;
          wakeUpTime = import_Types.WakeUpTime.None;
        } else if (rest.length === 2) {
          wakeUpTime = (0, import_Types.parseWakeUpTime)(rest[0]);
          dataRate = rest[1] & 7;
        } else {
          import_core.validatePayload.fail("Invalid payload length");
        }
      } else if (rest.length >= 1) {
        wakeUpTime = (0, import_Types.parseWakeUpTime)(rest[0]);
        dataRate = import_core.ZWaveDataRate["9k6"];
      } else {
        wakeUpTime = import_Types.WakeUpTime.None;
        dataRate = import_core.ZWaveDataRate["9k6"];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        candidateNodeIds,
        dataRate,
        wakeUpTime
      });
    }
    candidateNodeIds;
    wakeUpTime;
    dataRate;
    serialize(ctx) {
      const nodesBitmask = (0, import_core.encodeBitMask)(this.candidateNodeIds, import_core.MAX_NODES);
      const speedAndLength = 128 | nodesBitmask.length;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([speedAndLength]),
        nodesBitmask,
        import_shared.Bytes.from([this.wakeUpTime, this.dataRate])
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCFindNodesInRange2 = _classThis;
})();
let ZWaveProtocolCCRangeInfo = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.RangeInfo)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCRangeInfo2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCRangeInfo");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCRangeInfo2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.neighborNodeIds = options.neighborNodeIds;
      this.wakeUpTime = options.wakeUpTime;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const bitmaskLength = raw.payload[0] & 31;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + bitmaskLength);
      const neighborNodeIds = (0, import_core.parseBitMask)(raw.payload.subarray(1, 1 + bitmaskLength));
      let wakeUpTime;
      if (raw.payload.length >= 2 + bitmaskLength) {
        wakeUpTime = (0, import_Types.parseWakeUpTime)(raw.payload[1 + bitmaskLength]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        neighborNodeIds,
        wakeUpTime
      });
    }
    neighborNodeIds;
    wakeUpTime;
    serialize(ctx) {
      const nodesBitmask = (0, import_core.encodeBitMask)(this.neighborNodeIds, import_core.MAX_NODES);
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([nodesBitmask.length]),
        nodesBitmask,
        this.wakeUpTime != void 0 ? import_shared.Bytes.from([this.wakeUpTime]) : new import_shared.Bytes()
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCRangeInfo2 = _classThis;
})();
let ZWaveProtocolCCGetNodesInRange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.GetNodesInRange), (0, import_CommandClassDecorators.expectedCCResponse)(ZWaveProtocolCCRangeInfo)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCGetNodesInRange2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCGetNodesInRange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCGetNodesInRange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCGetNodesInRange2 = _classThis;
})();
let ZWaveProtocolCCCommandComplete = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.CommandComplete)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCCommandComplete2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCCommandComplete");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCCommandComplete2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sequenceNumber = options.sequenceNumber;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const sequenceNumber = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        sequenceNumber
      });
    }
    sequenceNumber;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.sequenceNumber]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCCommandComplete2 = _classThis;
})();
let ZWaveProtocolCCTransferPresentation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.TransferPresentation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCTransferPresentation2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCTransferPresentation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCTransferPresentation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.includeNode && options.excludeNode) {
        throw new import_core.ZWaveError(`${this.constructor.name}: the includeNode and excludeNode options cannot both be true`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.supportsNWI = options.supportsNWI;
      this.includeNode = options.includeNode;
      this.excludeNode = options.excludeNode;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const option = raw.payload[0];
      const supportsNWI = !!(option & 1);
      const excludeNode = !!(option & 2);
      const includeNode = !!(option & 4);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportsNWI,
        excludeNode,
        includeNode
      });
    }
    supportsNWI;
    includeNode;
    excludeNode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        (this.supportsNWI ? 1 : 0) | (this.excludeNode ? 2 : 0) | (this.includeNode ? 4 : 0)
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCTransferPresentation2 = _classThis;
})();
let ZWaveProtocolCCTransferNodeInformation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.TransferNodeInformation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCTransferNodeInformation2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCTransferNodeInformation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCTransferNodeInformation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sequenceNumber = options.sequenceNumber;
      this.sourceNodeId = options.sourceNodeId;
      this.basicDeviceClass = options.basicDeviceClass;
      this.genericDeviceClass = options.genericDeviceClass;
      this.specificDeviceClass = options.specificDeviceClass;
      this.isListening = options.isListening;
      this.isFrequentListening = options.isFrequentListening;
      this.isRouting = options.isRouting;
      this.supportedDataRates = options.supportedDataRates;
      this.protocolVersion = options.protocolVersion;
      this.optionalFunctionality = options.optionalFunctionality;
      this.nodeType = options.nodeType;
      this.supportsSecurity = options.supportsSecurity;
      this.supportsBeaming = options.supportsBeaming;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const sequenceNumber = raw.payload[0];
      const sourceNodeId = raw.payload[1];
      const { info } = (0, import_core.parseNodeProtocolInfoAndDeviceClass)(raw.payload.subarray(2));
      return new this({
        nodeId: ctx.sourceNodeId,
        sequenceNumber,
        sourceNodeId,
        ...info
      });
    }
    sequenceNumber;
    sourceNodeId;
    basicDeviceClass;
    genericDeviceClass;
    specificDeviceClass;
    isListening;
    isFrequentListening;
    isRouting;
    supportedDataRates;
    protocolVersion;
    optionalFunctionality;
    nodeType;
    supportsSecurity;
    supportsBeaming;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.sequenceNumber, this.sourceNodeId]),
        (0, import_core.encodeNodeProtocolInfoAndDeviceClass)(this)
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCTransferNodeInformation2 = _classThis;
})();
let ZWaveProtocolCCTransferRangeInformation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.TransferRangeInformation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCTransferRangeInformation2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCTransferRangeInformation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCTransferRangeInformation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sequenceNumber = options.sequenceNumber;
      this.testedNodeId = options.testedNodeId;
      this.neighborNodeIds = options.neighborNodeIds;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const sequenceNumber = raw.payload[0];
      const testedNodeId = raw.payload[1];
      const bitmaskLength = raw.payload[2];
      (0, import_core.validatePayload)(raw.payload.length >= 3 + bitmaskLength);
      const neighborNodeIds = (0, import_core.parseBitMask)(raw.payload.subarray(3, 3 + bitmaskLength));
      return new this({
        nodeId: ctx.sourceNodeId,
        sequenceNumber,
        testedNodeId,
        neighborNodeIds
      });
    }
    sequenceNumber;
    testedNodeId;
    neighborNodeIds;
    serialize(ctx) {
      const nodesBitmask = (0, import_core.encodeBitMask)(this.neighborNodeIds, import_core.MAX_NODES);
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          this.sequenceNumber,
          this.testedNodeId,
          nodesBitmask.length
        ]),
        nodesBitmask
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCTransferRangeInformation2 = _classThis;
})();
let ZWaveProtocolCCTransferEnd = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.TransferEnd)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCTransferEnd2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCTransferEnd");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCTransferEnd2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.status = options.status;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const status = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        status
      });
    }
    status;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.status]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCTransferEnd2 = _classThis;
})();
let ZWaveProtocolCCAssignReturnRoute = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AssignReturnRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCAssignReturnRoute2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAssignReturnRoute");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAssignReturnRoute2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.repeaters.length > import_core.MAX_REPEATERS) {
        throw new import_core.ZWaveError(`${this.constructor.name}: too many repeaters`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.destinationNodeId = options.destinationNodeId;
      this.routeIndex = options.routeIndex;
      this.repeaters = options.repeaters;
      this.destinationWakeUp = options.destinationWakeUp;
      this.destinationSpeed = options.destinationSpeed;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 7);
      const destinationNodeId = raw.payload[0];
      const routeIndex = raw.payload[1] >>> 4;
      const numRepeaters = raw.payload[1] & 15;
      const repeaters = [...raw.payload.subarray(2, 2 + numRepeaters)];
      const speedAndWakeup = raw.payload[2 + numRepeaters];
      const destinationSpeed = bitmask2DataRate(speedAndWakeup >>> 3 & 7);
      const destinationWakeUp = speedAndWakeup >>> 1 & 3;
      return new this({
        nodeId: ctx.sourceNodeId,
        destinationNodeId,
        routeIndex,
        repeaters,
        destinationSpeed,
        destinationWakeUp
      });
    }
    destinationNodeId;
    routeIndex;
    repeaters;
    destinationWakeUp;
    destinationSpeed;
    serialize(ctx) {
      const routeByte = this.routeIndex << 4 | this.repeaters.length;
      const speedMask = dataRate2Bitmask(this.destinationSpeed);
      const speedByte = speedMask << 3 | this.destinationWakeUp << 1;
      this.payload = import_shared.Bytes.from([
        this.destinationNodeId,
        routeByte,
        ...this.repeaters,
        speedByte
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCAssignReturnRoute2 = _classThis;
})();
let ZWaveProtocolCCNewNodeRegistered = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.NewNodeRegistered)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCNewNodeRegistered2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCNewNodeRegistered");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCNewNodeRegistered2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.newNodeId = options.newNodeId;
      this.basicDeviceClass = options.basicDeviceClass;
      this.genericDeviceClass = options.genericDeviceClass;
      this.specificDeviceClass = options.specificDeviceClass;
      this.isListening = options.isListening;
      this.isFrequentListening = options.isFrequentListening;
      this.isRouting = options.isRouting;
      this.supportedDataRates = options.supportedDataRates;
      this.protocolVersion = options.protocolVersion;
      this.optionalFunctionality = options.optionalFunctionality;
      this.nodeType = options.nodeType;
      this.supportsSecurity = options.supportsSecurity;
      this.supportsBeaming = options.supportsBeaming;
      this.supportedCCs = options.supportedCCs;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const newNodeId = raw.payload[0];
      const nif = (0, import_core.parseNodeInformationFrame)(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        newNodeId,
        ...nif
      });
    }
    newNodeId;
    basicDeviceClass;
    genericDeviceClass;
    specificDeviceClass;
    isListening;
    isFrequentListening;
    isRouting;
    supportedDataRates;
    protocolVersion;
    optionalFunctionality;
    nodeType;
    supportsSecurity;
    supportsBeaming;
    supportedCCs;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.newNodeId]),
        (0, import_core.encodeNodeInformationFrame)(this)
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCNewNodeRegistered2 = _classThis;
})();
let ZWaveProtocolCCNewRangeRegistered = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.NewRangeRegistered)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCNewRangeRegistered2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCNewRangeRegistered");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCNewRangeRegistered2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.testedNodeId = options.testedNodeId;
      this.neighborNodeIds = options.neighborNodeIds;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const testedNodeId = raw.payload[0];
      const numNeighbors = raw.payload[1];
      const neighborNodeIds = [
        ...raw.payload.subarray(2, 2 + numNeighbors)
      ];
      return new this({
        nodeId: ctx.sourceNodeId,
        testedNodeId,
        neighborNodeIds
      });
    }
    testedNodeId;
    neighborNodeIds;
    serialize(ctx) {
      const nodesBitmask = (0, import_core.encodeBitMask)(this.neighborNodeIds, import_core.MAX_NODES);
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.testedNodeId, nodesBitmask.length]),
        nodesBitmask
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCNewRangeRegistered2 = _classThis;
})();
let ZWaveProtocolCCTransferNewPrimaryControllerComplete = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.TransferNewPrimaryControllerComplete)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCTransferNewPrimaryControllerComplete2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCTransferNewPrimaryControllerComplete");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCTransferNewPrimaryControllerComplete2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.genericDeviceClass = options.genericDeviceClass;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const genericDeviceClass = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        genericDeviceClass
      });
    }
    genericDeviceClass;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.genericDeviceClass]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCTransferNewPrimaryControllerComplete2 = _classThis;
})();
let ZWaveProtocolCCAutomaticControllerUpdateStart = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AutomaticControllerUpdateStart)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCAutomaticControllerUpdateStart2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAutomaticControllerUpdateStart");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAutomaticControllerUpdateStart2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCAutomaticControllerUpdateStart2 = _classThis;
})();
let ZWaveProtocolCCSUCNodeID = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SUCNodeID)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCSUCNodeID2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSUCNodeID");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSUCNodeID2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sucNodeId = options.sucNodeId;
      this.isSIS = options.isSIS;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const sucNodeId = raw.payload[0];
      const capabilities = raw.payload[1] ?? 0;
      const isSIS = !!(capabilities & 1);
      return new this({
        nodeId: ctx.sourceNodeId,
        sucNodeId,
        isSIS
      });
    }
    sucNodeId;
    isSIS;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.sucNodeId, this.isSIS ? 1 : 0]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCSUCNodeID2 = _classThis;
})();
let ZWaveProtocolCCSetSUC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SetSUC)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCSetSUC2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSetSUC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSetSUC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.enableSIS = options.enableSIS;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const capabilities = raw.payload[1] ?? 0;
      const enableSIS = !!(capabilities & 1);
      return new this({
        nodeId: ctx.sourceNodeId,
        enableSIS
      });
    }
    enableSIS;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([1, this.enableSIS ? 1 : 0]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCSetSUC2 = _classThis;
})();
let ZWaveProtocolCCSetSUCAck = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SetSUCAck)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCSetSUCAck2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSetSUCAck");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSetSUCAck2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.accepted = options.accepted;
      this.isSIS = options.isSIS;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const accepted = raw.payload[0] === 1;
      const capabilities = raw.payload[1] ?? 0;
      const isSIS = !!(capabilities & 1);
      return new this({
        nodeId: ctx.sourceNodeId,
        accepted,
        isSIS
      });
    }
    accepted;
    isSIS;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.accepted ? 1 : 0,
        this.isSIS ? 1 : 0
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCSetSUCAck2 = _classThis;
})();
let ZWaveProtocolCCAssignSUCReturnRoute = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AssignSUCReturnRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCCAssignReturnRoute;
  var ZWaveProtocolCCAssignSUCReturnRoute2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAssignSUCReturnRoute");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAssignSUCReturnRoute2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCAssignSUCReturnRoute2 = _classThis;
})();
let ZWaveProtocolCCStaticRouteRequest = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.StaticRouteRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCStaticRouteRequest2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCStaticRouteRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCStaticRouteRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.nodeIds.some((n) => n < 1 || n > import_core.MAX_NODES)) {
        throw new import_core.ZWaveError(`All node IDs must be between 1 and ${import_core.MAX_NODES}!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.nodeIds = options.nodeIds;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5);
      const nodeIds = [...raw.payload.subarray(0, 5)].filter((id) => id > 0 && id <= import_core.MAX_NODES);
      return new this({
        nodeId: ctx.sourceNodeId,
        nodeIds
      });
    }
    nodeIds;
    serialize(ctx) {
      this.payload = import_shared.Bytes.alloc(5, 0);
      for (let i = 0; i < this.nodeIds.length && i < 5; i++) {
        this.payload[i] = this.nodeIds[i];
      }
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCStaticRouteRequest2 = _classThis;
})();
let ZWaveProtocolCCLost = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.Lost)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCLost2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCLost");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCLost2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.lostNodeId = options.lostNodeId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const lostNodeId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        lostNodeId
      });
    }
    lostNodeId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.lostNodeId]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCLost2 = _classThis;
})();
let ZWaveProtocolCCAcceptLost = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AcceptLost)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCAcceptLost2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAcceptLost");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAcceptLost2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.accepted = options.accepted;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      (0, import_core.validatePayload)(raw.payload[0] === 4 || raw.payload[0] === 5);
      const accepted = raw.payload[0] === 5;
      return new this({
        nodeId: ctx.sourceNodeId,
        accepted
      });
    }
    accepted;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.accepted ? 5 : 4]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCAcceptLost2 = _classThis;
})();
let ZWaveProtocolCCNOPPower = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.NOPPower)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCNOPPower2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCNOPPower");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCNOPPower2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.powerDampening < 0 || options.powerDampening > 14) {
        throw new import_core.ZWaveError(`${this.constructor.name}: power dampening must be between 0 and 14 dBm!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.powerDampening = options.powerDampening;
    }
    static from(raw, ctx) {
      let powerDampening;
      if (raw.payload.length >= 2) {
        powerDampening = raw.payload[1];
      } else if (raw.payload.length === 1) {
        powerDampening = [
          240,
          200,
          167,
          145,
          119,
          103,
          96,
          70,
          56,
          53,
          50,
          48,
          36,
          34,
          32
        ].indexOf(raw.payload[0]);
        if (powerDampening === -1)
          powerDampening = 0;
      } else {
        import_core.validatePayload.fail("Invalid payload length!");
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        powerDampening
      });
    }
    // Power dampening in (negative) dBm. A value of 2 means -2 dBm.
    powerDampening;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([0, this.powerDampening]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCNOPPower2 = _classThis;
})();
let ZWaveProtocolCCReservedIDs = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.ReservedIDs)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCReservedIDs2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCReservedIDs");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCReservedIDs2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.reservedNodeIDs = options.reservedNodeIDs;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numNodeIDs = raw.payload[0];
      (0, import_core.validatePayload)(raw.payload.length >= 1 + numNodeIDs);
      const reservedNodeIDs = [
        ...raw.payload.subarray(1, 1 + numNodeIDs)
      ];
      return new this({
        nodeId: ctx.sourceNodeId,
        reservedNodeIDs
      });
    }
    reservedNodeIDs;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.reservedNodeIDs.length,
        ...this.reservedNodeIDs
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCReservedIDs2 = _classThis;
})();
let ZWaveProtocolCCReserveNodeIDs = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.ReserveNodeIDs), (0, import_CommandClassDecorators.expectedCCResponse)(ZWaveProtocolCCReservedIDs)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCReserveNodeIDs2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCReserveNodeIDs");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCReserveNodeIDs2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.numNodeIDs = options.numNodeIDs;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numNodeIDs = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        numNodeIDs
      });
    }
    numNodeIDs;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.numNodeIDs]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCReserveNodeIDs2 = _classThis;
})();
let ZWaveProtocolCCNodesExistReply = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.NodesExistReply)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCNodesExistReply2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCNodesExistReply");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCNodesExistReply2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.nodeMaskType = options.nodeMaskType;
      this.nodeListUpdated = options.nodeListUpdated;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const nodeMaskType = raw.payload[0];
      const nodeListUpdated = raw.payload[1] === 1;
      return new this({
        nodeId: ctx.sourceNodeId,
        nodeMaskType,
        nodeListUpdated
      });
    }
    nodeMaskType;
    nodeListUpdated;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.nodeMaskType,
        this.nodeListUpdated ? 1 : 0
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCNodesExistReply2 = _classThis;
})();
function testResponseForZWaveProtocolNodesExist(sent, received) {
  return received.nodeMaskType === sent.nodeMaskType;
}
__name(testResponseForZWaveProtocolNodesExist, "testResponseForZWaveProtocolNodesExist");
let ZWaveProtocolCCNodesExist = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.NodesExist), (0, import_CommandClassDecorators.expectedCCResponse)(ZWaveProtocolCCNodesExistReply, testResponseForZWaveProtocolNodesExist)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCNodesExist2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCNodesExist");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCNodesExist2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.nodeMaskType = options.nodeMaskType;
      this.nodeIDs = options.nodeIDs;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const nodeMaskType = raw.payload[0];
      const numNodeIDs = raw.payload[1];
      (0, import_core.validatePayload)(raw.payload.length >= 2 + numNodeIDs);
      const nodeIDs = [...raw.payload.subarray(2, 2 + numNodeIDs)];
      return new this({
        nodeId: ctx.sourceNodeId,
        nodeMaskType,
        nodeIDs
      });
    }
    nodeMaskType;
    nodeIDs;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.nodeMaskType,
        this.nodeIDs.length,
        ...this.nodeIDs
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCNodesExist2 = _classThis;
})();
let ZWaveProtocolCCSetNWIMode = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SetNWIMode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCSetNWIMode2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSetNWIMode");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSetNWIMode2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.enabled = options.enabled;
      this.timeoutMinutes = options.timeoutMinutes;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const enabled = raw.payload[0] === 1;
      const timeoutMinutes = raw.payload[1] || void 0;
      return new this({
        nodeId: ctx.sourceNodeId,
        enabled,
        timeoutMinutes
      });
    }
    enabled;
    timeoutMinutes;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.enabled ? 1 : 0,
        this.timeoutMinutes ?? 0
      ]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCSetNWIMode2 = _classThis;
})();
let ZWaveProtocolCCExcludeRequest = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.ExcludeRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCCNodeInformationFrame;
  var ZWaveProtocolCCExcludeRequest2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCExcludeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCExcludeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCExcludeRequest2 = _classThis;
})();
let ZWaveProtocolCCAssignReturnRoutePriority = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AssignReturnRoutePriority)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCAssignReturnRoutePriority2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAssignReturnRoutePriority");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAssignReturnRoutePriority2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.targetNodeId = options.targetNodeId;
      this.routeNumber = options.routeNumber;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const targetNodeId = raw.payload[0];
      const routeNumber = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        targetNodeId,
        routeNumber
      });
    }
    targetNodeId;
    routeNumber;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.targetNodeId, this.routeNumber]);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCAssignReturnRoutePriority2 = _classThis;
})();
let ZWaveProtocolCCAssignSUCReturnRoutePriority = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.AssignSUCReturnRoutePriority)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCCAssignReturnRoutePriority;
  var ZWaveProtocolCCAssignSUCReturnRoutePriority2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCAssignSUCReturnRoutePriority");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCAssignSUCReturnRoutePriority2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCAssignSUCReturnRoutePriority2 = _classThis;
})();
let ZWaveProtocolCCSmartStartIncludedNodeInformation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SmartStartIncludedNodeInformation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCC;
  var ZWaveProtocolCCSmartStartIncludedNodeInformation2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSmartStartIncludedNodeInformation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSmartStartIncludedNodeInformation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.nwiHomeId.length !== 4) {
        throw new import_core.ZWaveError(`nwiHomeId must have length 4`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.nwiHomeId = options.nwiHomeId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const nwiHomeId = raw.payload.subarray(0, 4);
      return new this({
        nodeId: ctx.sourceNodeId,
        nwiHomeId
      });
    }
    nwiHomeId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from(this.nwiHomeId);
      return super.serialize(ctx);
    }
  };
  return ZWaveProtocolCCSmartStartIncludedNodeInformation2 = _classThis;
})();
let ZWaveProtocolCCSmartStartPrime = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SmartStartPrime)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCCNodeInformationFrame;
  var ZWaveProtocolCCSmartStartPrime2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSmartStartPrime");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSmartStartPrime2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCSmartStartPrime2 = _classThis;
})();
let ZWaveProtocolCCSmartStartInclusionRequest = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ZWaveProtocolCommand.SmartStartInclusionRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ZWaveProtocolCCNodeInformationFrame;
  var ZWaveProtocolCCSmartStartInclusionRequest2 = class extends _classSuper {
    static {
      __name(this, "ZWaveProtocolCCSmartStartInclusionRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveProtocolCCSmartStartInclusionRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ZWaveProtocolCCSmartStartInclusionRequest2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZWaveProtocolCC,
  ZWaveProtocolCCAcceptLost,
  ZWaveProtocolCCAssignIDs,
  ZWaveProtocolCCAssignReturnRoute,
  ZWaveProtocolCCAssignReturnRoutePriority,
  ZWaveProtocolCCAssignSUCReturnRoute,
  ZWaveProtocolCCAssignSUCReturnRoutePriority,
  ZWaveProtocolCCAutomaticControllerUpdateStart,
  ZWaveProtocolCCCommandComplete,
  ZWaveProtocolCCExcludeRequest,
  ZWaveProtocolCCFindNodesInRange,
  ZWaveProtocolCCGetNodesInRange,
  ZWaveProtocolCCLost,
  ZWaveProtocolCCNOPPower,
  ZWaveProtocolCCNewNodeRegistered,
  ZWaveProtocolCCNewRangeRegistered,
  ZWaveProtocolCCNodeInformationFrame,
  ZWaveProtocolCCNodesExist,
  ZWaveProtocolCCNodesExistReply,
  ZWaveProtocolCCRangeInfo,
  ZWaveProtocolCCRequestNodeInformationFrame,
  ZWaveProtocolCCReserveNodeIDs,
  ZWaveProtocolCCReservedIDs,
  ZWaveProtocolCCSUCNodeID,
  ZWaveProtocolCCSetNWIMode,
  ZWaveProtocolCCSetSUC,
  ZWaveProtocolCCSetSUCAck,
  ZWaveProtocolCCSmartStartIncludedNodeInformation,
  ZWaveProtocolCCSmartStartInclusionRequest,
  ZWaveProtocolCCSmartStartPrime,
  ZWaveProtocolCCStaticRouteRequest,
  ZWaveProtocolCCTransferEnd,
  ZWaveProtocolCCTransferNewPrimaryControllerComplete,
  ZWaveProtocolCCTransferNodeInformation,
  ZWaveProtocolCCTransferPresentation,
  ZWaveProtocolCCTransferRangeInformation
});
//# sourceMappingURL=ZWaveProtocolCC.js.map
