"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EncapsulatingCommandClass_exports = {};
__export(EncapsulatingCommandClass_exports, {
  getInnermostCommandClass: () => getInnermostCommandClass,
  isEncapsulatingCommandClass: () => isEncapsulatingCommandClass,
  isMultiEncapsulatingCommandClass: () => isMultiEncapsulatingCommandClass
});
module.exports = __toCommonJS(EncapsulatingCommandClass_exports);
var import_typeguards = require("alcalzone-shared/typeguards");
var import_CommandClass = require("./CommandClass.js");
function isEncapsulatingCommandClass(cc) {
  if (!(cc instanceof import_CommandClass.CommandClass))
    return false;
  if (!(cc.encapsulated instanceof import_CommandClass.CommandClass)) {
    return false;
  }
  let proto = Object.getPrototypeOf(cc.constructor);
  while (proto) {
    if (typeof proto.encapsulate === "function") {
      return true;
    }
    proto = Object.getPrototypeOf(proto);
  }
  return false;
}
__name(isEncapsulatingCommandClass, "isEncapsulatingCommandClass");
function getInnermostCommandClass(cc) {
  if (isEncapsulatingCommandClass(cc)) {
    return getInnermostCommandClass(cc.encapsulated);
  } else {
    return cc;
  }
}
__name(getInnermostCommandClass, "getInnermostCommandClass");
function isMultiEncapsulatingCommandClass(cc) {
  if (!(cc instanceof import_CommandClass.CommandClass))
    return false;
  if (!((0, import_typeguards.isArray)(cc.encapsulated) && cc.encapsulated.every((item) => item instanceof import_CommandClass.CommandClass))) {
    return false;
  }
  let proto = Object.getPrototypeOf(cc.constructor);
  while (proto) {
    if (typeof proto.encapsulate === "function") {
      return true;
    }
    proto = Object.getPrototypeOf(proto);
  }
  return false;
}
__name(isMultiEncapsulatingCommandClass, "isMultiEncapsulatingCommandClass");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getInnermostCommandClass,
  isEncapsulatingCommandClass,
  isMultiEncapsulatingCommandClass
});
//# sourceMappingURL=EncapsulatingCommandClass.js.map
