var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { CommandClasses, validatePayload, } from "@zwave-js/core";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
import { CCAPI } from "../lib/API.js";
import { CommandClass } from "../lib/CommandClass.js";
import { API, CCCommand, commandClass, implementedVersion, } from "../lib/CommandClassDecorators.js";
import { ApplicationStatus, ApplicationStatusCommand } from "../lib/_Types.js";
let ApplicationStatusCCAPI = (() => {
    let _classDecorators = [API(CommandClasses["Application Status"])];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = CCAPI;
    var ApplicationStatusCCAPI = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationStatusCCAPI = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        supportsCommand(cmd) {
            switch (cmd) {
                case ApplicationStatusCommand.Busy:
                case ApplicationStatusCommand.RejectedRequest:
                    return true; // These are receive-only commands
            }
            return super.supportsCommand(cmd);
        }
    };
    return ApplicationStatusCCAPI = _classThis;
})();
export { ApplicationStatusCCAPI };
let ApplicationStatusCC = (() => {
    let _classDecorators = [commandClass(CommandClasses["Application Status"]), implementedVersion(1)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = CommandClass;
    var ApplicationStatusCC = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationStatusCC = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ApplicationStatusCC = _classThis;
})();
export { ApplicationStatusCC };
let ApplicationStatusCCBusy = (() => {
    let _classDecorators = [CCCommand(ApplicationStatusCommand.Busy)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ApplicationStatusCC;
    var ApplicationStatusCCBusy = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationStatusCCBusy = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.status = options.status;
            this.waitTime = options.waitTime;
        }
        static from(raw, ctx) {
            validatePayload(raw.payload.length >= 1);
            const status = raw.payload[0];
            let waitTime;
            if (status === ApplicationStatus.TryAgainInWaitTimeSeconds
                && raw.payload.length >= 2) {
                waitTime = raw.payload[1];
            }
            return new this({
                nodeId: ctx.sourceNodeId,
                status,
                waitTime,
            });
        }
        status;
        waitTime;
        serialize(ctx) {
            this.payload = Bytes.from([this.status, this.waitTime ?? 0]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const message = {
                status: getEnumMemberName(ApplicationStatus, this.status),
            };
            if (this.status === ApplicationStatus.TryAgainInWaitTimeSeconds) {
                message["wait time"] = `${this.waitTime} seconds`;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return ApplicationStatusCCBusy = _classThis;
})();
export { ApplicationStatusCCBusy };
let ApplicationStatusCCRejectedRequest = (() => {
    let _classDecorators = [CCCommand(ApplicationStatusCommand.RejectedRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ApplicationStatusCC;
    var ApplicationStatusCCRejectedRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationStatusCCRejectedRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            validatePayload(raw.payload.length >= 1);
            const status = raw.payload[0];
            // This field MUST be set to 0
            validatePayload(status === 0);
            return new this({
                nodeId: ctx.sourceNodeId,
            });
        }
        serialize(ctx) {
            this.payload = Bytes.from([0x00]);
            return super.serialize(ctx);
        }
    };
    return ApplicationStatusCCRejectedRequest = _classThis;
})();
export { ApplicationStatusCCRejectedRequest };
//# sourceMappingURL=ApplicationStatusCC.js.map