import * as v from "@zwave-js/core/validation";
export function validateArgs_AssociationCCAPI_reportGroupCount() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportGroupCount(groupCount) {
                v.assert(v.primitive({ kind: "parameter", name: "groupCount" }, "number")(groupCount));
                return __decoratedMethod.call(this, groupCount);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_getGroup() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getGroup(groupId) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId));
                return __decoratedMethod.call(this, groupId);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_sendReport() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function sendReport(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'AssociationCCReportOptions', { "groupId": v.primitive({ kind: "property", name: "groupId" }, "number"), "maxNodes": v.primitive({ kind: "property", name: "maxNodes" }, "number"), "nodeIds": v.array({ kind: "property", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number")), "reportsToFollow": v.primitive({ kind: "property", name: "reportsToFollow" }, "number") })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_addNodeIds() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function addNodeIds(groupId, ...nodeIds) {
                v.assert(v.primitive({ kind: "parameter", name: "groupId" }, "number")(groupId), v.array({ kind: "parameter", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number"))(nodeIds));
                return __decoratedMethod.call(this, groupId, ...nodeIds);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_removeNodeIds() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function removeNodeIds(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, 'AssociationCCRemoveOptions', { "groupId": v.optional({ kind: "property", name: "groupId" }, v.primitive({ kind: "property", name: "groupId" }, "number")), "nodeIds": v.optional({ kind: "property", name: "nodeIds" }, v.array({ kind: "property", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number"))) })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_removeNodeIdsFromAllGroups() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function removeNodeIdsFromAllGroups(nodeIds) {
                v.assert(v.array({ kind: "parameter", name: "nodeIds" }, 'number', v.primitive({ kind: "item", name: "nodeIds" }, "number"))(nodeIds));
                return __decoratedMethod.call(this, nodeIds);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_getSpecificGroup() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getSpecificGroup() {
                v.assert();
                return __decoratedMethod.call(this);
            };
        }
    };
}
export function validateArgs_AssociationCCAPI_reportSpecificGroup() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportSpecificGroup(group) {
                v.assert(v.primitive({ kind: "parameter", name: "group" }, "number")(group));
                return __decoratedMethod.call(this, group);
            };
        }
    };
}
//# sourceMappingURL=AssociationCC._validateArgs.js.map