import * as v from "@zwave-js/core/validation";
export function validateArgs_IrrigationCCAPI_setSystemConfig() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function setSystemConfig(config) {
                v.assert(v.object({ kind: "parameter", name: "config" }, '<anonymous object>', { "masterValveDelay": v.primitive({ kind: "property", name: "masterValveDelay" }, "number"), "highPressureThreshold": v.primitive({ kind: "property", name: "highPressureThreshold" }, "number"), "lowPressureThreshold": v.primitive({ kind: "property", name: "lowPressureThreshold" }, "number"), "rainSensorPolarity": v.optional({ kind: "property", name: "rainSensorPolarity" }, v.oneOf({ kind: "property", name: "rainSensorPolarity" }, undefined, v.literal({ kind: "property", name: "rainSensorPolarity" }, 0), v.literal({ kind: "property", name: "rainSensorPolarity" }, 1))), "moistureSensorPolarity": v.optional({ kind: "property", name: "moistureSensorPolarity" }, v.oneOf({ kind: "property", name: "moistureSensorPolarity" }, undefined, v.literal({ kind: "property", name: "moistureSensorPolarity" }, 0), v.literal({ kind: "property", name: "moistureSensorPolarity" }, 1))) })(config));
                return __decoratedMethod.call(this, config);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_getValveInfo() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getValveInfo(valveId) {
                v.assert(v.oneOf({ kind: "parameter", name: "valveId" }, "ValveId", v.primitive({ kind: "parameter", name: "valveId" }, "number"), v.literal({ kind: "parameter", name: "valveId" }, "master"))(valveId));
                return __decoratedMethod.call(this, valveId);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_setValveConfig() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function setValveConfig(options) {
                v.assert(v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "valveId": v.oneOf({ kind: "property", name: "valveId" }, "ValveId", v.primitive({ kind: "property", name: "valveId" }, "number"), v.literal({ kind: "property", name: "valveId" }, "master")), "nominalCurrentHighThreshold": v.primitive({ kind: "property", name: "nominalCurrentHighThreshold" }, "number"), "nominalCurrentLowThreshold": v.primitive({ kind: "property", name: "nominalCurrentLowThreshold" }, "number"), "maximumFlow": v.primitive({ kind: "property", name: "maximumFlow" }, "number"), "highFlowThreshold": v.primitive({ kind: "property", name: "highFlowThreshold" }, "number"), "lowFlowThreshold": v.primitive({ kind: "property", name: "lowFlowThreshold" }, "number"), "useRainSensor": v.primitive({ kind: "property", name: "useRainSensor" }, "boolean"), "useMoistureSensor": v.primitive({ kind: "property", name: "useMoistureSensor" }, "boolean") })(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_getValveConfig() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getValveConfig(valveId) {
                v.assert(v.oneOf({ kind: "parameter", name: "valveId" }, "ValveId", v.primitive({ kind: "parameter", name: "valveId" }, "number"), v.literal({ kind: "parameter", name: "valveId" }, "master"))(valveId));
                return __decoratedMethod.call(this, valveId);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_runValve() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function runValve(valveId, duration) {
                v.assert(v.oneOf({ kind: "parameter", name: "valveId" }, "ValveId", v.primitive({ kind: "parameter", name: "valveId" }, "number"), v.literal({ kind: "parameter", name: "valveId" }, "master"))(valveId), v.primitive({ kind: "parameter", name: "duration" }, "number")(duration));
                return __decoratedMethod.call(this, valveId, duration);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_shutoffValve() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function shutoffValve(valveId) {
                v.assert(v.oneOf({ kind: "parameter", name: "valveId" }, "ValveId", v.primitive({ kind: "parameter", name: "valveId" }, "number"), v.literal({ kind: "parameter", name: "valveId" }, "master"))(valveId));
                return __decoratedMethod.call(this, valveId);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_setValveTable() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function setValveTable(tableId, entries) {
                v.assert(v.primitive({ kind: "parameter", name: "tableId" }, "number")(tableId), v.array({ kind: "parameter", name: "entries" }, 'ValveTableEntry', v.object({ kind: "item", name: "entries" }, 'ValveTableEntry', { "valveId": v.primitive({ kind: "property", name: "valveId" }, "number"), "duration": v.primitive({ kind: "property", name: "duration" }, "number") }))(entries));
                return __decoratedMethod.call(this, tableId, entries);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_getValveTable() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getValveTable(tableId) {
                v.assert(v.primitive({ kind: "parameter", name: "tableId" }, "number")(tableId));
                return __decoratedMethod.call(this, tableId);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_runTables() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function runTables(tableIDs) {
                v.assert(v.array({ kind: "parameter", name: "tableIDs" }, 'number', v.primitive({ kind: "item", name: "tableIDs" }, "number"))(tableIDs));
                return __decoratedMethod.call(this, tableIDs);
            };
        }
    };
}
export function validateArgs_IrrigationCCAPI_shutoffSystem() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function shutoffSystem(duration) {
                v.assert(v.primitive({ kind: "parameter", name: "duration" }, "number")(duration));
                return __decoratedMethod.call(this, duration);
            };
        }
    };
}
//# sourceMappingURL=IrrigationCC._validateArgs.js.map