"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssociationConfig_exports = {};
__export(AssociationConfig_exports, {
  ConditionalAssociationConfig: () => ConditionalAssociationConfig
});
module.exports = __toCommonJS(AssociationConfig_exports);
var import_shared = require("@zwave-js/shared");
var import_utils_safe = require("../utils_safe.js");
var import_ConditionalItem = require("./ConditionalItem.js");
class ConditionalAssociationConfig {
  static {
    __name(this, "ConditionalAssociationConfig");
  }
  constructor(filename, groupId, definition) {
    this.groupId = groupId;
    (0, import_ConditionalItem.validateCondition)(filename, definition, `Association ${groupId} contains an`);
    this.condition = definition.$if;
    if (typeof definition.label !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
Association ${groupId} has a non-string label`);
    }
    this.label = definition.label;
    if (definition.description != void 0 && typeof definition.description !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
Association ${groupId} has a non-string description`);
    }
    this.description = definition.description;
    if (typeof definition.maxNodes !== "number") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
maxNodes for association ${groupId} is not a number`);
    }
    this.maxNodes = definition.maxNodes;
    if (definition.isLifeline != void 0 && typeof definition.isLifeline !== "boolean") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
isLifeline in association ${groupId} must be a boolean`);
    }
    this.isLifeline = !!definition.isLifeline;
    if (definition.multiChannel != void 0 && typeof definition.multiChannel !== "boolean") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${filename}:
multiChannel in association ${groupId} must be a boolean`);
    }
    this.multiChannel = definition.multiChannel ?? "auto";
  }
  condition;
  groupId;
  label;
  description;
  maxNodes;
  /**
   * Whether this association group is used to report updates to the controller.
   * While Z-Wave+ defines a single lifeline, older devices may have multiple lifeline associations.
   */
  isLifeline;
  /**
   * Controls the strategy of setting up lifeline associations:
   *
   * * `true` - Use a multi channel association (if possible)
   * * `false` - Use a node association (if possible)
   * * `"auto"` - Prefer node associations, fall back to multi channel associations
   */
  multiChannel;
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    return (0, import_shared.pick)(this, [
      "groupId",
      "label",
      "description",
      "maxNodes",
      "isLifeline",
      "multiChannel"
    ]);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConditionalAssociationConfig
});
//# sourceMappingURL=AssociationConfig.js.map
