"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CompatConfig_exports = {};
__export(CompatConfig_exports, {
  CompatAddCC: () => CompatAddCC,
  CompatMapAlarm: () => CompatMapAlarm,
  CompatOverrideQueries: () => CompatOverrideQueries,
  ConditionalCompatConfig: () => ConditionalCompatConfig
});
module.exports = __toCommonJS(CompatConfig_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_utils_safe = require("../utils_safe.js");
var import_ConditionalItem = require("./ConditionalItem.js");
class ConditionalCompatConfig {
  static {
    __name(this, "ConditionalCompatConfig");
  }
  valueIdRegex = /^\$value\$\[.+\]$/;
  constructor(filename, definition) {
    this.condition = definition.$if;
    if (definition.queryOnWakeup != void 0) {
      if (!(0, import_typeguards.isArray)(definition.queryOnWakeup) || !definition.queryOnWakeup.every((cmd) => (0, import_typeguards.isArray)(cmd) && cmd.length >= 2 && typeof cmd[0] === "string" && typeof cmd[1] === "string" && cmd.slice(2).every((arg) => typeof arg === "string" || typeof arg === "number" || typeof arg === "boolean"))) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option queryOnWakeup`);
      }
      this.queryOnWakeup = definition.queryOnWakeup.map((cmd) => cmd.map((arg) => {
        if (typeof arg === "string" && this.valueIdRegex.test(arg)) {
          const tuple = JSON.parse(arg.slice("$value$".length));
          return {
            property: tuple[0],
            propertyKey: tuple[1]
          };
        }
        return arg;
      }));
    }
    if (definition.disableAutoRefresh != void 0) {
      if (definition.disableAutoRefresh !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option disableAutoRefresh must be true or omitted`);
      }
      this.disableAutoRefresh = definition.disableAutoRefresh;
    }
    if (definition.disableCallbackFunctionTypeCheck != void 0) {
      if (!(0, import_typeguards.isArray)(definition.disableCallbackFunctionTypeCheck) || !definition.disableCallbackFunctionTypeCheck.every((d) => typeof d === "number" && d % 1 === 0 && d > 0)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
when present, compat option disableCallbackFunctionTypeCheck msut be an array of positive integers`);
      }
      this.disableCallbackFunctionTypeCheck = definition.disableCallbackFunctionTypeCheck;
    }
    if (definition.disableStrictEntryControlDataValidation != void 0) {
      if (definition.disableStrictEntryControlDataValidation !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option disableStrictEntryControlDataValidation must be true or omitted`);
      }
      this.disableStrictEntryControlDataValidation = definition.disableStrictEntryControlDataValidation;
    }
    if (definition.disableStrictMeasurementValidation != void 0) {
      if (definition.disableStrictMeasurementValidation !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option disableStrictMeasurementValidation must be true or omitted`);
      }
      this.disableStrictMeasurementValidation = definition.disableStrictMeasurementValidation;
    }
    if (definition.encodeCCsUsingTargetVersion != void 0) {
      if (definition.encodeCCsUsingTargetVersion !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option encodeCCsUsingTargetVersion must be true or omitted`);
      }
      this.encodeCCsUsingTargetVersion = definition.encodeCCsUsingTargetVersion;
    }
    if (definition.forceNotificationIdleReset != void 0) {
      if (definition.forceNotificationIdleReset !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option forceNotificationIdleReset must be true or omitted`);
      }
      this.forceNotificationIdleReset = definition.forceNotificationIdleReset;
    }
    if (definition.forceSceneControllerGroupCount != void 0) {
      if (typeof definition.forceSceneControllerGroupCount !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option forceSceneControllerGroupCount must be a number!`);
      }
      if (definition.forceSceneControllerGroupCount < 0 || definition.forceSceneControllerGroupCount > 255) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option forceSceneControllerGroupCount must be between 0 and 255!`);
      }
      this.forceSceneControllerGroupCount = definition.forceSceneControllerGroupCount;
    }
    if (definition.mapBasicReport != void 0) {
      if (!isBasicReportMapping(definition.mapBasicReport)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option mapBasicReport contains an invalid value`);
      }
      this.mapBasicReport = definition.mapBasicReport;
    }
    if (definition.mapBasicSet != void 0) {
      if (!isBasicSetMapping(definition.mapBasicSet)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option mapBasicSet contains an invalid value`);
      }
      this.mapBasicSet = definition.mapBasicSet;
    }
    if (definition.preserveRootApplicationCCValueIDs != void 0) {
      if (definition.preserveRootApplicationCCValueIDs !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option preserveRootApplicationCCValueIDs`);
      }
      this.preserveRootApplicationCCValueIDs = definition.preserveRootApplicationCCValueIDs;
    }
    if (definition.preserveEndpoints != void 0) {
      if (definition.preserveEndpoints !== "*" && !((0, import_typeguards.isArray)(definition.preserveEndpoints) && definition.preserveEndpoints.every((d) => typeof d === "number" && d % 1 === 0 && d > 0))) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option preserveEndpoints must be "*" or an array of positive integers`);
      }
      this.preserveEndpoints = definition.preserveEndpoints;
    }
    if (definition.removeEndpoints != void 0) {
      if (definition.removeEndpoints !== "*" && !((0, import_typeguards.isArray)(definition.removeEndpoints) && definition.removeEndpoints.every((d) => typeof d === "number" && d % 1 === 0 && d > 0))) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option removeEndpoints must be "*" or an array of positive integers`);
      }
      this.removeEndpoints = definition.removeEndpoints;
    }
    if (definition.skipConfigurationNameQuery != void 0) {
      if (definition.skipConfigurationNameQuery !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option skipConfigurationNameQuery`);
      }
      this.skipConfigurationNameQuery = definition.skipConfigurationNameQuery;
    }
    if (definition.skipConfigurationInfoQuery != void 0) {
      if (definition.skipConfigurationInfoQuery !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option skipConfigurationInfoQuery`);
      }
      this.skipConfigurationInfoQuery = definition.skipConfigurationInfoQuery;
    }
    if (definition.treatMultilevelSwitchSetAsEvent != void 0) {
      if (definition.treatMultilevelSwitchSetAsEvent !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option treatMultilevelSwitchSetAsEvent`);
      }
      this.treatMultilevelSwitchSetAsEvent = definition.treatMultilevelSwitchSetAsEvent;
    }
    if (definition.treatSetAsReport != void 0) {
      if (!((0, import_typeguards.isArray)(definition.treatSetAsReport) && definition.treatSetAsReport.every((d) => typeof d === "string"))) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option treatSetAsReport must be an array of strings`);
      }
      this.treatSetAsReport = new Set(definition.treatSetAsReport);
    }
    if (definition.treatDestinationEndpointAsSource != void 0) {
      if (definition.treatDestinationEndpointAsSource !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option treatDestinationEndpointAsSource`);
      }
      this.treatDestinationEndpointAsSource = definition.treatDestinationEndpointAsSource;
    }
    if (definition.useUTCInTimeParametersCC != void 0) {
      if (definition.useUTCInTimeParametersCC !== true) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option useUTCInTimeParametersCC must be true or omitted`);
      }
      this.useUTCInTimeParametersCC = definition.useUTCInTimeParametersCC;
    }
    if (definition.manualValueRefreshDelayMs != void 0) {
      if (typeof definition.manualValueRefreshDelayMs !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option manualValueRefreshDelayMs must be a number!`);
      }
      if (definition.manualValueRefreshDelayMs % 1 !== 0 || definition.manualValueRefreshDelayMs < 0) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option manualValueRefreshDelayMs must be a non-negative integer!`);
      }
      this.manualValueRefreshDelayMs = definition.manualValueRefreshDelayMs;
    }
    if (definition.reportTimeout != void 0) {
      if (typeof definition.reportTimeout !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option reportTimeout must be a number!`);
      }
      if (definition.reportTimeout % 1 !== 0 || definition.reportTimeout < 1e3 || definition.reportTimeout > 1e4) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option reportTimeout must be an integer between 1000 and 10000!`);
      }
      this.reportTimeout = definition.reportTimeout;
    }
    if (definition.mapRootReportsToEndpoint != void 0) {
      if (typeof definition.mapRootReportsToEndpoint !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option mapRootReportsToEndpoint must be a number!`);
      }
      if (definition.mapRootReportsToEndpoint % 1 !== 0 || definition.mapRootReportsToEndpoint < 1) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option mapRootReportsToEndpoint must be a positive integer!`);
      }
      this.mapRootReportsToEndpoint = definition.mapRootReportsToEndpoint;
    }
    if (definition.overrideFloatEncoding != void 0) {
      if (!(0, import_typeguards.isObject)(definition.overrideFloatEncoding)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option overrideFloatEncoding`);
      }
      this.overrideFloatEncoding = {};
      if ("precision" in definition.overrideFloatEncoding) {
        if (typeof definition.overrideFloatEncoding.precision != "number") {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option overrideFloatEncoding.precision must be a number!`);
        }
        if (definition.overrideFloatEncoding.precision % 1 !== 0 || definition.overrideFloatEncoding.precision < 0) {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option overrideFloatEncoding.precision must be a positive integer!`);
        }
        this.overrideFloatEncoding.precision = definition.overrideFloatEncoding.precision;
      }
      if ("size" in definition.overrideFloatEncoding) {
        if (typeof definition.overrideFloatEncoding.size != "number") {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option overrideFloatEncoding.size must be a number!`);
        }
        if (definition.overrideFloatEncoding.size % 1 !== 0 || definition.overrideFloatEncoding.size < 1 || definition.overrideFloatEncoding.size > 4) {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option overrideFloatEncoding.size must be an integer between 1 and 4!`);
        }
        this.overrideFloatEncoding.size = definition.overrideFloatEncoding.size;
      }
      if (Object.keys(this.overrideFloatEncoding).length === 0) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option overrideFloatEncoding: size and/or precision must be specified!`);
      }
    }
    if (definition.commandClasses != void 0) {
      if (!(0, import_typeguards.isObject)(definition.commandClasses)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option commandClasses`);
      }
      if (definition.commandClasses.add != void 0) {
        if (!(0, import_typeguards.isObject)(definition.commandClasses.add)) {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option commandClasses.add`);
        } else if (!Object.values(definition.commandClasses.add).every((v) => (0, import_typeguards.isObject)(v))) {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
All values in compat option commandClasses.add must be objects`);
        }
        const addCCs = /* @__PURE__ */ new Map();
        for (const [key, info] of Object.entries(definition.commandClasses.add)) {
          const cc = (0, import_utils_safe.tryParseCCId)(key);
          if (cc == void 0) {
            (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Invalid Command Class "${key}" specified in compat option commandClasses.add!`);
          }
          addCCs.set(cc, new CompatAddCC(filename, info));
        }
        this.addCCs = addCCs;
      }
      if (definition.commandClasses.remove != void 0) {
        if (!(0, import_typeguards.isObject)(definition.commandClasses.remove)) {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option commandClasses.remove`);
        }
        const removeCCs = /* @__PURE__ */ new Map();
        for (const [key, info] of Object.entries(definition.commandClasses.remove)) {
          const cc = (0, import_utils_safe.tryParseCCId)(key);
          if (cc == void 0) {
            (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Invalid Command Class "${key}" specified in compat option commandClasses.remove!`);
          }
          if ((0, import_typeguards.isObject)(info) && "endpoints" in info) {
            if (info.endpoints === "*" || (0, import_typeguards.isArray)(info.endpoints) && info.endpoints.every((i) => typeof i === "number")) {
              removeCCs.set(cc, info.endpoints);
            } else {
              (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Compat option commandClasses.remove has an invalid "endpoints" property. Only "*" and numeric arrays are allowed!`);
            }
          } else {
            (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
All values in compat option commandClasses.remove must be objects with an "endpoints" property!`);
          }
        }
        this.removeCCs = removeCCs;
      }
    }
    if (definition.alarmMapping != void 0) {
      if (!(0, import_typeguards.isArray)(definition.alarmMapping) || !definition.alarmMapping.every((m) => (0, import_typeguards.isObject)(m))) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option alarmMapping must be an array where all items are objects!`);
      }
      this.alarmMapping = definition.alarmMapping.map((m, i) => new CompatMapAlarm(filename, m, i + 1));
    }
    if (definition.overrideQueries != void 0) {
      if (!(0, import_typeguards.isObject)(definition.overrideQueries)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
compat option overrideQueries must be an object!`);
      }
      this.overrideQueries = new CompatOverrideQueries(filename, definition.overrideQueries);
    }
  }
  alarmMapping;
  addCCs;
  removeCCs;
  disableAutoRefresh;
  disableStrictEntryControlDataValidation;
  disableStrictMeasurementValidation;
  disableCallbackFunctionTypeCheck;
  encodeCCsUsingTargetVersion;
  forceNotificationIdleReset;
  forceSceneControllerGroupCount;
  manualValueRefreshDelayMs;
  mapRootReportsToEndpoint;
  mapBasicReport;
  mapBasicSet;
  overrideFloatEncoding;
  overrideQueries;
  preserveRootApplicationCCValueIDs;
  preserveEndpoints;
  removeEndpoints;
  reportTimeout;
  skipConfigurationNameQuery;
  skipConfigurationInfoQuery;
  treatMultilevelSwitchSetAsEvent;
  treatSetAsReport;
  treatDestinationEndpointAsSource;
  useUTCInTimeParametersCC;
  queryOnWakeup;
  condition;
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    const ret = (0, import_shared.pick)(this, [
      "alarmMapping",
      "addCCs",
      "removeCCs",
      "disableAutoRefresh",
      "disableCallbackFunctionTypeCheck",
      "disableStrictEntryControlDataValidation",
      "disableStrictMeasurementValidation",
      "encodeCCsUsingTargetVersion",
      "forceNotificationIdleReset",
      "forceSceneControllerGroupCount",
      "manualValueRefreshDelayMs",
      "mapBasicReport",
      "mapBasicSet",
      "mapRootReportsToEndpoint",
      "overrideFloatEncoding",
      "overrideQueries",
      "reportTimeout",
      "preserveRootApplicationCCValueIDs",
      "preserveEndpoints",
      "removeEndpoints",
      "skipConfigurationNameQuery",
      "skipConfigurationInfoQuery",
      "treatMultilevelSwitchSetAsEvent",
      "treatSetAsReport",
      "treatDestinationEndpointAsSource",
      "useUTCInTimeParametersCC",
      "queryOnWakeup"
    ]);
    return (0, import_core.stripUndefined)(ret);
  }
}
class CompatAddCC {
  static {
    __name(this, "CompatAddCC");
  }
  constructor(filename, definition) {
    const endpoints = /* @__PURE__ */ new Map();
    const parseEndpointInfo = /* @__PURE__ */ __name((endpoint, info) => {
      const parsed = {};
      if (info.isSupported != void 0) {
        if (typeof info.isSupported !== "boolean") {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property isSupported in compat option commandClasses.add, endpoint ${endpoint} must be a boolean!`);
        } else {
          parsed.isSupported = info.isSupported;
        }
      }
      if (info.isControlled != void 0) {
        if (typeof info.isControlled !== "boolean") {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property isControlled in compat option commandClasses.add, endpoint ${endpoint} must be a boolean!`);
        } else {
          parsed.isControlled = info.isControlled;
        }
      }
      if (info.secure != void 0) {
        if (typeof info.secure !== "boolean") {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property secure in compat option commandClasses.add, endpoint ${endpoint} must be a boolean!`);
        } else {
          parsed.secure = info.secure;
        }
      }
      if (info.version != void 0) {
        if (typeof info.version !== "number") {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property version in compat option commandClasses.add, endpoint ${endpoint} must be a number!`);
        } else {
          parsed.version = info.version;
        }
      }
      endpoints.set(endpoint, parsed);
    }, "parseEndpointInfo");
    if (definition.isSupported != void 0 || definition.isControlled != void 0 || definition.version != void 0 || definition.secure != void 0) {
      parseEndpointInfo(0, definition);
    }
    if ((0, import_typeguards.isObject)(definition.endpoints)) {
      if (!Object.keys(definition.endpoints).every((k) => /^\d+$/.test(k))) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
invalid endpoint index in compat option commandClasses.add`);
      } else {
        for (const [ep, info] of Object.entries(definition.endpoints)) {
          parseEndpointInfo(parseInt(ep), info);
        }
      }
    }
    this.endpoints = endpoints;
  }
  endpoints;
}
class CompatMapAlarm {
  static {
    __name(this, "CompatMapAlarm");
  }
  constructor(filename, definition, index) {
    if (!(0, import_typeguards.isObject)(definition.from)) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "from" must be an object!`);
    } else {
      if (typeof definition.from.alarmType !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "from.alarmType" must be a number!`);
      }
      if (definition.from.alarmLevel != void 0 && typeof definition.from.alarmLevel !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: if property "from.alarmLevel" is given, it must be a number!`);
      }
    }
    if (!(0, import_typeguards.isObject)(definition.to)) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "to" must be an object!`);
    } else {
      if (typeof definition.to.notificationType !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "to.notificationType" must be a number!`);
      }
      if (typeof definition.to.notificationEvent !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "to.notificationEvent" must be a number!`);
      }
      if (definition.to.eventParameters != void 0) {
        if (!(0, import_typeguards.isObject)(definition.to.eventParameters)) {
          (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "to.eventParameters" must be an object!`);
        } else {
          for (const [key, val] of Object.entries(definition.to.eventParameters)) {
            if (typeof val !== "number" && val !== "alarmLevel") {
              (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
error in compat option alarmMapping, mapping #${index}: property "to.eventParameters.${key}" must be a number or the literal "alarmLevel"!`);
            }
          }
        }
      }
    }
    this.from = (0, import_shared.pick)(definition.from, ["alarmType", "alarmLevel"]);
    this.to = (0, import_shared.pick)(definition.to, [
      "notificationType",
      "notificationEvent",
      "eventParameters"
    ]);
  }
  from;
  to;
}
class CompatOverrideQueries {
  static {
    __name(this, "CompatOverrideQueries");
  }
  constructor(filename, definition) {
    const overrides = /* @__PURE__ */ new Map();
    const parseOverride = /* @__PURE__ */ __name((cc, info) => {
      if (typeof info.method !== "string") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "method" in compat option overrideQueries, CC ${(0, import_core.getCCName)(cc)} must be a string!`);
      } else if (info.matchArgs != void 0 && !(0, import_typeguards.isArray)(info.matchArgs)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "matchArgs" in compat option overrideQueries, CC ${(0, import_core.getCCName)(cc)} must be an array!`);
      } else if (!("result" in info)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "result" is missing in in compat option overrideQueries, CC ${(0, import_core.getCCName)(cc)}!`);
      } else if (info.endpoint != void 0 && typeof info.endpoint !== "number") {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "endpoint" in compat option overrideQueries, CC ${(0, import_core.getCCName)(cc)} must be a number!`);
      } else if (info.persistValues && !(0, import_typeguards.isObject)(info.persistValues)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "persistValues" in compat option overrideQueries, CC ${(0, import_core.getCCName)(cc)} must be an object!`);
      } else if (info.extendMetadata && !(0, import_typeguards.isObject)(info.extendMetadata)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "extendMetadata" in compat option overrideQueries, CC ${(0, import_core.getCCName)(cc)} must be an object!`);
      }
      return {
        endpoint: info.endpoint,
        method: info.method,
        matchArgs: info.matchArgs,
        result: info.result,
        persistValues: info.persistValues,
        extendMetadata: info.extendMetadata
      };
    }, "parseOverride");
    for (const [key, value] of Object.entries(definition)) {
      const cc = (0, import_utils_safe.tryParseCCId)(key);
      if (cc == void 0) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Invalid Command Class "${key}" specified in compat option overrideQueries!`);
      }
      let overrideDefinitions;
      if ((0, import_typeguards.isObject)(value)) {
        overrideDefinitions = [value];
      } else if (!(0, import_typeguards.isArray)(value)) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `config/devices/${filename}:
Property "${key}" in compat option overrideQueries must be a single override object or an array thereof!`);
      } else {
        overrideDefinitions = value;
      }
      overrides.set(cc, overrideDefinitions.map((info) => parseOverride(cc, info)));
    }
    this.overrides = overrides;
  }
  // CC -> endpoint -> queries
  overrides;
  hasOverride(ccId) {
    return this.overrides.has(ccId);
  }
  matchOverride(cc, endpointIndex, method, args) {
    const queries = this.overrides.get(cc);
    if (!queries)
      return void 0;
    for (const query of queries) {
      if ((query.endpoint ?? 0) !== endpointIndex)
        continue;
      if (query.method !== method)
        continue;
      if (query.matchArgs) {
        if (query.matchArgs.length !== args.length)
          continue;
        if (!query.matchArgs.every((arg, i) => arg === args[i])) {
          continue;
        }
      }
      return (0, import_shared.pick)(query, ["result", "persistValues", "extendMetadata"]);
    }
  }
}
const basicReportMappings = [
  false,
  "auto",
  "Binary Sensor"
];
function isBasicReportMapping(v) {
  return basicReportMappings.includes(v);
}
__name(isBasicReportMapping, "isBasicReportMapping");
const basicSetMappings = [
  "event",
  "report",
  "auto",
  "Binary Sensor"
];
function isBasicSetMapping(v) {
  return basicSetMappings.includes(v);
}
__name(isBasicSetMapping, "isBasicSetMapping");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CompatAddCC,
  CompatMapAlarm,
  CompatOverrideQueries,
  ConditionalCompatConfig
});
//# sourceMappingURL=CompatConfig.js.map
