"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ConditionalPrimitive_exports = {};
__export(ConditionalPrimitive_exports, {
  ConditionalPrimitiveVariant: () => ConditionalPrimitiveVariant,
  parseConditionalPrimitive: () => parseConditionalPrimitive
});
module.exports = __toCommonJS(ConditionalPrimitive_exports);
var import_typeguards = require("alcalzone-shared/typeguards");
var import_utils_safe = require("../utils_safe.js");
var import_ConditionalItem = require("./ConditionalItem.js");
function parseConditionalPrimitive(filename, valueType, propertyName, definition, errorMessagePrefix = "") {
  if ((0, import_typeguards.isArray)(definition) && definition.every((i, index, dfn) => (
    // In arrays, only the last item may be non-conditional
    (0, import_typeguards.isObject)(i) && typeof i.value === valueType || index === dfn.length - 1 && typeof i === valueType
  ))) {
    return definition.map((d) => typeof d === valueType ? new ConditionalPrimitiveVariant(d) : new ConditionalPrimitiveVariant(d.value, typeof d.$if === "string" ? d.$if : void 0));
  } else if (typeof definition === valueType) {
    return definition;
  } else {
    (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}:
${errorMessagePrefix}${propertyName} must be a ${valueType} or an array of conditional ${valueType} entries`);
  }
}
__name(parseConditionalPrimitive, "parseConditionalPrimitive");
class ConditionalPrimitiveVariant {
  static {
    __name(this, "ConditionalPrimitiveVariant");
  }
  value;
  condition;
  constructor(value, condition) {
    this.value = value;
    this.condition = condition;
  }
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    return this.value;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConditionalPrimitiveVariant,
  parseConditionalPrimitive
});
//# sourceMappingURL=ConditionalPrimitive.js.map
