import { type JSONObject, type ReadonlyObjectKeyMap } from "@zwave-js/shared";
import { type ConditionalItem } from "./ConditionalItem.js";
import type { ConditionalDeviceConfig } from "./DeviceConfig.js";
import type { DeviceID } from "./shared.js";
export declare class ConditionalParamInformation implements ConditionalItem<ParamInformation> {
    constructor(parent: ConditionalDeviceConfig, parameterNumber: number, valueBitMask: number | undefined, definition: JSONObject);
    private parent;
    readonly parameterNumber: number;
    readonly valueBitMask?: number;
    readonly label: string;
    readonly description?: string;
    readonly valueSize: number;
    readonly minValue?: number;
    readonly maxValue?: number;
    readonly unsigned?: boolean;
    readonly defaultValue: number;
    readonly recommendedValue?: number;
    readonly unit?: string;
    readonly readOnly?: true;
    readonly writeOnly?: true;
    readonly allowManualEntry: boolean;
    readonly destructive?: boolean;
    readonly options: readonly ConditionalConfigOption[];
    readonly hidden?: boolean;
    readonly condition?: string;
    evaluateCondition(deviceId?: DeviceID): ParamInformation | undefined;
}
export type ParamInformation = Omit<ConditionalParamInformation, "condition" | "evaluateCondition" | "options" | "minValue" | "maxValue"> & {
    options: readonly ConfigOption[];
    minValue: NonNullable<ConditionalParamInformation["minValue"]>;
    maxValue: NonNullable<ConditionalParamInformation["maxValue"]>;
};
export declare class ConditionalConfigOption implements ConditionalItem<ConfigOption> {
    readonly value: number;
    readonly label: string;
    readonly condition?: string | undefined;
    constructor(value: number, label: string, condition?: string | undefined);
    evaluateCondition(deviceId?: DeviceID): ConfigOption | undefined;
}
export interface ConfigOption {
    value: number;
    label: string;
}
export type ConditionalParamInfoMap = ReadonlyObjectKeyMap<{
    parameter: number;
    valueBitMask?: number;
}, ConditionalParamInformation[]>;
export type ParamInfoMap = ReadonlyObjectKeyMap<{
    parameter: number;
    valueBitMask?: number;
}, ParamInformation>;
export declare function parseConditionalParamInformationMap(definition: JSONObject, parent: ConditionalDeviceConfig, errorPrefix?: string): ConditionalParamInfoMap;
//# sourceMappingURL=ParamInformation.d.ts.map