import { type JSONObject } from "@zwave-js/shared";
import { type ConditionalItem } from "./ConditionalItem.js";
import type { DeviceID } from "./shared.js";
export declare class ConditionalSceneConfig implements ConditionalItem<SceneConfig> {
    constructor(filename: string, sceneId: number, definition: JSONObject);
    readonly condition?: string;
    readonly sceneId: number;
    readonly label: string;
    readonly description?: string;
    evaluateCondition(deviceId?: DeviceID): SceneConfig | undefined;
}
export type SceneConfig = Omit<ConditionalSceneConfig, "condition" | "evaluateCondition">;
//# sourceMappingURL=SceneConfig.d.ts.map